/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.CasterEngine;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartMedium;
import thaumcraft.api.casters.IFocusPartModifier;
import thaumcraft.api.casters.MutatorStore;
import thaumcraft.api.casters.MutatorType;

public class FModScatter
implements IFocusPartModifier {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/scatter.png");

    @Override
    public IFocusPart.EnumPartAttribute[] getAttributes() {
        return new IFocusPart.EnumPartAttribute[]{IFocusPart.EnumPartAttribute.RANGED};
    }

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.MODIFIER;
    }

    @Override
    public String getKey() {
        return "thaumcraft.SCATTER";
    }

    @Override
    public String getResearch() {
        return "FOCUSPROJECTILE";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.AIR;
    }

    @Override
    public int getGemColor() {
        return 0x585858;
    }

    @Override
    public int getIconColor() {
        return 14808489;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public boolean canConnectTo(IFocusPart part) {
        return part instanceof IFocusPartMedium;
    }

    @Override
    public void applyBaseMutators(MutatorStore mutators) {
        mutators.modifyMutator(mutators.POWER, 0.3f);
        mutators.modifyMutator(mutators.COST, 1.5f);
    }

    @Override
    public boolean applyAtCast(Entity caster, @Nullable ItemStack casterStack, FocusCore core, RayTraceResult source, Vec3d castVector) {
        MutatorStore temp = new MutatorStore();
        temp.registerMutator(new MutatorType("accuracy", MutatorStore.EnumMutatorOperand.MULT));
        temp.modifyMutator("accuracy", 0.33f);
        for (int a = 0; a < 5; ++a) {
            core.ignorePart(this);
            CasterEngine.cast(core.copy(), caster, casterStack, source, castVector, temp);
        }
        return true;
    }

    @Override
    public byte getApplicationOrder() {
        return 120;
    }
}

