/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.CasterEngine;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartMedium;
import thaumcraft.api.casters.IFocusPartModifier;
import thaumcraft.api.casters.MutatorStore;
import thaumcraft.common.lib.utils.EntityUtils;

public class FModChain
implements IFocusPartModifier {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/chain.png");
    private static HashMap<Integer, ArrayList<Integer>> targetList = new HashMap();

    @Override
    public IFocusPart.EnumPartAttribute[] getAttributes() {
        return new IFocusPart.EnumPartAttribute[]{IFocusPart.EnumPartAttribute.ENTITIES, IFocusPart.EnumPartAttribute.RANGED};
    }

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.MODIFIER;
    }

    @Override
    public String getKey() {
        return "thaumcraft.CHAIN";
    }

    @Override
    public byte getApplicationOrder() {
        return 110;
    }

    @Override
    public String getResearch() {
        return "FOCUSBOLT";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.MOTION;
    }

    @Override
    public int getGemColor() {
        return 0x585858;
    }

    @Override
    public int getIconColor() {
        return 16109737;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public void applyBaseMutators(MutatorStore mutators) {
        mutators.modifyMutator(mutators.COST, 2.0f);
    }

    @Override
    public boolean canConnectTo(IFocusPart part) {
        return part instanceof IFocusPartMedium;
    }

    @Override
    public boolean applyAtMediumResolution(Entity caster, ItemStack casterStack, FocusCore core, RayTraceResult target, RayTraceResult source, Vec3d castVector) {
        if (target.field_72308_g != null && (double)core.effects[0].mutators.getValue(core.effects[0].mutators.POWER) > 0.2) {
            Map sortedMap;
            Iterator iterator;
            if (!targetList.containsKey(core.uniqueId)) {
                targetList.put(core.uniqueId, new ArrayList());
            }
            ArrayList<Integer> targets = targetList.get(core.uniqueId);
            MutatorStore castingMutators = new MutatorStore();
            castingMutators.modifyMutator(core.effects[0].mutators.POWER, 0.75f);
            List<EntityLivingBase> list = EntityUtils.getEntitiesInRange(caster.field_70170_p, target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, caster, EntityLivingBase.class, 8.0);
            HashMap<EntityLivingBase, Double> unsortedMap = new HashMap<EntityLivingBase, Double>();
            for (EntityLivingBase e : list) {
                if (!(target.field_72308_g instanceof EntityPlayer) && e instanceof EntityPlayer || e.field_70128_L || e == target.field_72308_g || targets.contains(e.func_145782_y())) continue;
                unsortedMap.put(e, target.field_72308_g.func_70068_e((Entity)e) + (double)e.field_70172_ad);
            }
            if (!unsortedMap.isEmpty() && (iterator = (sortedMap = (Map)unsortedMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new))).keySet().iterator()).hasNext()) {
                EntityLivingBase t = (EntityLivingBase)iterator.next();
                Vec3d newCastVec = target.field_72307_f.func_178788_d(t.func_174791_d().func_72441_c(0.0, (double)(t.field_70131_O / 2.0f), 0.0));
                newCastVec = newCastVec.func_72432_b().func_186678_a(-1.0);
                RayTraceResult r = new RayTraceResult(target.field_72308_g, target.field_72307_f.func_178787_e(newCastVec));
                targets.add(t.func_145782_y());
                CasterEngine.cast(core, caster, casterStack, r, newCastVec, castingMutators);
            }
        } else {
            targetList.remove(core.uniqueId);
        }
        return false;
    }
}

