/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.CasterEngine;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartMedium;
import thaumcraft.api.casters.IFocusPartModifier;
import thaumcraft.api.casters.MutatorStore;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXFocusPartImpactBurst;
import thaumcraft.common.lib.utils.EntityUtils;

public class FModBurst
implements IFocusPartModifier {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/burst.png");

    @Override
    public IFocusPart.EnumPartAttribute[] getAttributes() {
        return new IFocusPart.EnumPartAttribute[]{IFocusPart.EnumPartAttribute.ENTITIES};
    }

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.MODIFIER;
    }

    @Override
    public String getKey() {
        return "thaumcraft.BURST";
    }

    @Override
    public String getResearch() {
        return "FOCUSBURST";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.AVERSION;
    }

    @Override
    public int getGemColor() {
        return 0xAA5858;
    }

    @Override
    public int getIconColor() {
        return 14808489;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public void applyBaseMutators(MutatorStore mutators) {
        mutators.modifyMutator(mutators.COST, 3.0f);
    }

    @Override
    public boolean canConnectTo(IFocusPart part) {
        return part instanceof IFocusPartMedium;
    }

    @Override
    public boolean applyAtMediumResolution(Entity caster, @Nullable ItemStack casterStack, FocusCore core, RayTraceResult target, RayTraceResult source, Vec3d castVector) {
        String[] keys = new String[core.effects.length];
        for (int a = 0; a < core.effects.length; ++a) {
            keys[a] = core.effects[a].effect.getKey();
        }
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXFocusPartImpactBurst(target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, keys), new NetworkRegistry.TargetPoint(caster.field_70170_p.field_73011_w.getDimension(), target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, 32.0));
        List<EntityLivingBase> list = EntityUtils.getEntitiesInRange(caster.field_70170_p, target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, caster, EntityLivingBase.class, 4.0);
        for (EntityLivingBase e : list) {
            if ((target.field_72308_g == null || !(target.field_72308_g instanceof EntityPlayer)) && e instanceof EntityPlayer || e.field_70128_L) continue;
            double dist = target.field_72307_f.func_72438_d(e.func_174791_d());
            FocusCore newCore = core.copy();
            for (FocusCore.FocusEffect fe : newCore.effects) {
                fe.mutators.modifyMutator(fe.mutators.POWER, MathHelper.func_76131_a((float)(1.0f - (float)(dist / 8.0)), (float)0.5f, (float)1.0f));
            }
            RayTraceResult nt = new RayTraceResult((Entity)e, new Vec3d(e.field_70165_t, e.field_70163_u + (double)(e.field_70131_O / 2.0f), e.field_70161_v));
            newCore.ignorePart(this);
            CasterEngine.applyEffectsFromFocus(newCore, nt, nt, caster, casterStack);
        }
        return true;
    }

    @Override
    public byte getApplicationOrder() {
        return 100;
    }
}

