/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.CasterEngine;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartMedium;
import thaumcraft.api.casters.MutatorStore;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.Utils;

public class FMediumTouch
implements IFocusPartMedium {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/touch.png");

    @Override
    public IFocusPart.EnumPartAttribute[] getAttributes() {
        return new IFocusPart.EnumPartAttribute[]{IFocusPart.EnumPartAttribute.TOUCH, IFocusPart.EnumPartAttribute.ENTITIES, IFocusPart.EnumPartAttribute.BLOCKS};
    }

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.MEDIUM;
    }

    @Override
    public IFocusPartMedium.EnumFocusCastMethod getCastMethod() {
        return IFocusPartMedium.EnumFocusCastMethod.INSTANT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.TOUCH";
    }

    @Override
    public String getResearch() {
        return "BASEAUROMANCY@3";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.EARTH;
    }

    @Override
    public int getGemColor() {
        return 5811450;
    }

    @Override
    public int getIconColor() {
        return 12706559;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public void applyBaseMutators(MutatorStore mutators) {
        mutators.modifyMutator(mutators.COST, 0.5f);
        mutators.modifyMutator(mutators.POWER, 1.1f);
    }

    @Override
    public boolean onCast(Entity caster, ItemStack casterStack, FocusCore core, RayTraceResult source, Vec3d castVector) {
        Entity pointedEntity = EntityUtils.getPointedEntity(caster.field_70170_p, caster, castVector, 0.0, 5.0, 0.1f);
        RayTraceResult mop = pointedEntity != null ? new RayTraceResult(pointedEntity) : Utils.rayTrace(caster.field_70170_p, caster, castVector, true, 5.0);
        if (mop != null) {
            CasterEngine.applyEffectsFromFocus(core, source, mop, caster, casterStack);
            return true;
        }
        return false;
    }
}

