/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartMedium;
import thaumcraft.api.casters.MutatorStore;
import thaumcraft.api.casters.MutatorType;
import thaumcraft.common.entities.projectile.EntityGenericProjectile;

public class FMediumProjectile
implements IFocusPartMedium {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/projectile.png");

    @Override
    public IFocusPart.EnumPartAttribute[] getAttributes() {
        return new IFocusPart.EnumPartAttribute[]{IFocusPart.EnumPartAttribute.RANGED, IFocusPart.EnumPartAttribute.ENTITIES, IFocusPart.EnumPartAttribute.BLOCKS};
    }

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.MEDIUM;
    }

    @Override
    public String getKey() {
        return "thaumcraft.PROJECTILE";
    }

    @Override
    public String getResearch() {
        return "FOCUSPROJECTILE@2";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.FLIGHT;
    }

    @Override
    public int getGemColor() {
        return 5800698;
    }

    @Override
    public int getIconColor() {
        return 16765440;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public void applyBaseMutators(MutatorStore mutators) {
        mutators.registerMutator(new MutatorType("accuracy", MutatorStore.EnumMutatorOperand.MULT));
    }

    @Override
    public boolean onCast(Entity caster, ItemStack casterStack, FocusCore core, RayTraceResult source, Vec3d castVector) {
        float speed = 1.5f;
        float acc = core.effects[0].mutators.getValue("accuracy");
        if (acc == 0.0f) {
            acc = 1.0f;
        }
        float spread = 2.0f / acc;
        if (!caster.field_70170_p.field_72995_K && caster instanceof EntityLivingBase) {
            EntityGenericProjectile projectile = new EntityGenericProjectile(caster.field_70170_p, (EntityLivingBase)caster, casterStack, speed, spread, core);
            projectile.func_70107_b(source.field_72307_f.field_72450_a, source.field_72307_f.field_72448_b, source.field_72307_f.field_72449_c);
            projectile.func_70186_c(castVector.field_72450_a, castVector.field_72448_b, castVector.field_72449_c, speed, spread);
            caster.field_70170_p.func_72838_d((Entity)projectile);
        }
        return true;
    }
}

