/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.CasterEngine;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.api.casters.IFocusPartMedium;
import thaumcraft.api.items.IArchitect;
import thaumcraft.common.items.casters.foci.FModPotency;
import thaumcraft.common.lib.utils.Utils;

public class FMediumPlan
implements IFocusPartMedium {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/plan.png");

    @Override
    public IFocusPart.EnumPartAttribute[] getAttributes() {
        return new IFocusPart.EnumPartAttribute[]{IFocusPart.EnumPartAttribute.TOUCH, IFocusPart.EnumPartAttribute.BLOCKS};
    }

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.MEDIUM;
    }

    @Override
    public IFocusPartMedium.EnumFocusCastMethod getCastMethod() {
        return IFocusPartMedium.EnumFocusCastMethod.INSTANT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.PLAN";
    }

    @Override
    public String getResearch() {
        return "FOCUSPLAN";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.CRAFT;
    }

    @Override
    public int getGemColor() {
        return 11635966;
    }

    @Override
    public int getIconColor() {
        return 44453;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public boolean onCast(Entity caster, ItemStack casterStack, FocusCore core, RayTraceResult source, Vec3d castVector) {
        RayTraceResult mop = Utils.rayTrace(caster.field_70170_p, caster, false);
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            CasterEngine.applyEffectsFromFocus(core, source, mop, caster, casterStack);
            return true;
        }
        return false;
    }

    @Override
    public boolean canConnectTo(IFocusPart part) {
        if (part instanceof IFocusPartEffect && !(part instanceof IArchitect)) {
            return false;
        }
        if (part instanceof FModPotency) {
            return true;
        }
        return IFocusPartMedium.super.canConnectTo(part);
    }
}

