/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.CasterEngine;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartMedium;
import thaumcraft.api.casters.MutatorStore;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXZap;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.Utils;

public class FMediumBolt
implements IFocusPartMedium {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/bolt.png");
    private ArrayList<Long> exList = new ArrayList();

    @Override
    public IFocusPart.EnumPartAttribute[] getAttributes() {
        return new IFocusPart.EnumPartAttribute[]{IFocusPart.EnumPartAttribute.RANGED, IFocusPart.EnumPartAttribute.ENTITIES, IFocusPart.EnumPartAttribute.BLOCKS};
    }

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.MEDIUM;
    }

    @Override
    public String getKey() {
        return "thaumcraft.BOLT";
    }

    @Override
    public String getResearch() {
        return "FOCUSBOLT@2";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.FIRE;
    }

    @Override
    public int getGemColor() {
        return 5821431;
    }

    @Override
    public int getIconColor() {
        return 0xC0FFFF;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public void applyBaseMutators(MutatorStore mutators) {
        mutators.modifyMutator(mutators.COST, 1.25f);
    }

    @Override
    public boolean onCast(Entity caster, ItemStack casterStack, FocusCore core, RayTraceResult source, Vec3d castVector) {
        float range = 16.0f;
        Entity pointedEntity = EntityUtils.getPointedEntity(caster.field_70170_p, source, castVector, 2.0, (double)range, 0.1f);
        RayTraceResult mop = pointedEntity != null ? new RayTraceResult(pointedEntity) : Utils.rayTrace(caster.field_70170_p, caster, false, range);
        Vec3d end = mop != null ? mop.field_72307_f : castVector.func_186678_a((double)range).func_178787_e(source.field_72307_f);
        for (FocusCore.FocusEffect fe : core.effects) {
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXZap(source.field_72307_f, end, fe.effect.getGemColor(), fe.mutators.getValue(fe.mutators.POWER) / 5.0f), new NetworkRegistry.TargetPoint(caster.field_70170_p.field_73011_w.getDimension(), source.field_72307_f.field_72450_a, source.field_72307_f.field_72448_b, source.field_72307_f.field_72449_c, 64.0));
        }
        if (mop != null) {
            double rr = source.field_72307_f.func_72438_d(mop.field_72307_f) + 0.1;
            mop.field_72307_f = source.field_72307_f.func_178787_e(castVector.func_72432_b().func_186678_a(rr));
            CasterEngine.applyEffectsFromFocus(core, source, mop, caster, casterStack);
        }
        return true;
    }

    @Override
    public boolean applyAtEffect(Entity caster, @Nullable ItemStack casterStack, FocusCore.FocusEffect focusEffect, RayTraceResult target, RayTraceResult source, Vec3d castVector) {
        return false;
    }
}

