/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockBamf;

public class FEffectMagic
implements IFocusPartEffect {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/magic.png");

    @Override
    public IFocusPart.EnumPartAttribute[] getAttributes() {
        return new IFocusPart.EnumPartAttribute[]{IFocusPart.EnumPartAttribute.ENTITIES};
    }

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.EFFECT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.MAGIC";
    }

    @Override
    public String getResearch() {
        return "FOCUSMAGIC";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.MAGIC;
    }

    @Override
    public int getGemColor() {
        return 0xCF00FF;
    }

    @Override
    public int getIconColor() {
        return 0xFFC0FF;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getBaseCost() {
        return 2.0f;
    }

    @Override
    public float getDamageForDisplay(FocusCore.FocusEffect focusEffect) {
        return 4.0f * focusEffect.mutators.getValue(focusEffect.mutators.POWER);
    }

    @Override
    public void applyToTarget(Entity caster, ItemStack casterStack, FocusCore.FocusEffect focusEffect, RayTraceResult medium, RayTraceResult target) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockBamf(medium.field_72307_f.field_72450_a, medium.field_72307_f.field_72448_b, medium.field_72307_f.field_72449_c, this.getGemColor(), true, true, null), new NetworkRegistry.TargetPoint(caster.field_70170_p.field_73011_w.getDimension(), medium.field_72307_f.field_72450_a, medium.field_72307_f.field_72448_b, medium.field_72307_f.field_72449_c, 32.0));
        if (target.field_72313_a == RayTraceResult.Type.ENTITY && target.field_72308_g != null) {
            float damage = this.getDamageForDisplay(focusEffect);
            target.field_72308_g.func_70097_a(DamageSource.func_76354_b((Entity)(medium.field_72308_g != null ? medium.field_72308_g : caster), (Entity)caster), damage);
        }
    }

    @Override
    public void onCast(Entity caster, @Nullable ItemStack casterStack) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_187542_ac, SoundCategory.PLAYERS, 0.5f, 2.0f + (float)(caster.field_70170_p.field_73012_v.nextGaussian() * (double)0.05f));
    }
}

