/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXFocusPartImpact;

public class FEffectFrost
implements IFocusPartEffect {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/frost.png");

    @Override
    public IFocusPart.EnumPartAttribute[] getAttributes() {
        return new IFocusPart.EnumPartAttribute[]{IFocusPart.EnumPartAttribute.ENTITIES, IFocusPart.EnumPartAttribute.BLOCKS, IFocusPart.EnumPartAttribute.TIMED};
    }

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.EFFECT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.FROST";
    }

    @Override
    public String getResearch() {
        return "FOCUSFROST";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.COLD;
    }

    @Override
    public int getGemColor() {
        return 3836158;
    }

    @Override
    public int getIconColor() {
        return 13299966;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getBaseCost() {
        return 2.0f;
    }

    @Override
    public float getDamageForDisplay(FocusCore.FocusEffect focusEffect) {
        return 4.0f * focusEffect.mutators.getValue(focusEffect.mutators.POWER);
    }

    @Override
    public void applyToTarget(Entity caster, ItemStack casterStack, FocusCore.FocusEffect focusEffect, RayTraceResult medium, RayTraceResult target) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXFocusPartImpact(target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, new String[]{this.getKey()}), new NetworkRegistry.TargetPoint(caster.field_70170_p.field_73011_w.getDimension(), target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, 32.0));
        if (target.field_72313_a == RayTraceResult.Type.ENTITY && target.field_72308_g != null) {
            float damage = this.getDamageForDisplay(focusEffect);
            int cold = 40;
            int frost = 1;
            target.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)(medium.field_72308_g != null ? medium.field_72308_g : caster), (Entity)caster), damage);
            if (target.field_72308_g instanceof EntityLivingBase) {
                ((EntityLivingBase)target.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76421_d, cold, frost));
            }
        } else if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
            float f = Math.min(16.0f, 2.0f * focusEffect.mutators.getValue(focusEffect.mutators.POWER));
            for (BlockPos.MutableBlockPos blockpos$mutableblockpos1 : BlockPos.func_177975_b((BlockPos)target.func_178782_a().func_177963_a((double)(-f), (double)(-f), (double)(-f)), (BlockPos)target.func_178782_a().func_177963_a((double)f, (double)f, (double)f))) {
                IBlockState iblockstate1;
                if (!(blockpos$mutableblockpos1.func_177957_d(medium.field_72307_f.field_72450_a, medium.field_72307_f.field_72448_b, medium.field_72307_f.field_72449_c) <= (double)(f * f)) || (iblockstate1 = caster.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos1)).func_185904_a() != Material.field_151586_h || (Integer)iblockstate1.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0 || !caster.field_70170_p.func_175716_a(Blocks.field_185778_de, (BlockPos)blockpos$mutableblockpos1, false, EnumFacing.DOWN, (Entity)null, (ItemStack)null)) continue;
                caster.field_70170_p.func_175656_a((BlockPos)blockpos$mutableblockpos1, Blocks.field_185778_de.func_176223_P());
                caster.field_70170_p.func_175684_a(blockpos$mutableblockpos1.func_185334_h(), Blocks.field_185778_de, MathHelper.func_76136_a((Random)caster.field_70170_p.field_73012_v, (int)60, (int)120));
            }
        }
    }

    @Override
    public boolean hasCustomFX() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawCustomFX(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        FXGeneric fb = new FXGeneric(world, posX, posY, posZ, motionX, motionY, motionZ);
        fb.func_187114_a(40 + world.field_73012_v.nextInt(40));
        fb.setAlphaF(1.0f, 0.0f);
        fb.setParticles(8, 1, 1);
        fb.setGravity(0.033f);
        fb.setSlowDown(0.8);
        fb.setRandomMovementScale(0.0025f, 1.0E-4f, 0.0025f);
        fb.setScale((float)((double)0.7f + world.field_73012_v.nextGaussian() * (double)0.3f));
        fb.setRotationSpeed(world.field_73012_v.nextFloat() * 3.0f, (float)world.field_73012_v.nextGaussian() / 4.0f);
        ParticleEngine.INSTANCE.addEffectWithDelay(world, fb, 0);
    }

    @Override
    public void onCast(Entity caster, @Nullable ItemStack casterStack) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_187942_hp, SoundCategory.PLAYERS, 0.2f, 1.0f + (float)(caster.field_70170_p.field_73012_v.nextGaussian() * (double)0.05f));
    }
}

