/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXFocusPartImpact;

public class FEffectFire
implements IFocusPartEffect {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/fire.png");

    @Override
    public IFocusPart.EnumPartAttribute[] getAttributes() {
        return new IFocusPart.EnumPartAttribute[]{IFocusPart.EnumPartAttribute.ENTITIES, IFocusPart.EnumPartAttribute.BLOCKS, IFocusPart.EnumPartAttribute.TIMED};
    }

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.EFFECT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.FIRE";
    }

    @Override
    public String getResearch() {
        return "BASEAUROMANCY@3";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.FIRE;
    }

    @Override
    public int getGemColor() {
        return 16519424;
    }

    @Override
    public int getIconColor() {
        return 16366673;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getBaseCost() {
        return 2.0f;
    }

    @Override
    public float getDamageForDisplay(FocusCore.FocusEffect focusEffect) {
        return 4.0f * focusEffect.mutators.getValue(focusEffect.mutators.POWER);
    }

    @Override
    public void applyToTarget(Entity caster, ItemStack casterStack, FocusCore.FocusEffect focusEffect, RayTraceResult medium, RayTraceResult target) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXFocusPartImpact(target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, new String[]{this.getKey()}), new NetworkRegistry.TargetPoint(caster.field_70170_p.field_73011_w.getDimension(), target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, 32.0));
        if (target.field_72313_a == RayTraceResult.Type.ENTITY && target.field_72308_g != null) {
            if (target.field_72308_g.func_70045_F()) {
                return;
            }
            float fire = 2.0f * focusEffect.mutators.getValue(focusEffect.mutators.TIME) * focusEffect.mutators.getValue(focusEffect.mutators.TIME);
            float damage = this.getDamageForDisplay(focusEffect);
            target.field_72308_g.func_70097_a(new EntityDamageSourceIndirect("fireball", medium.field_72308_g != null ? medium.field_72308_g : caster, caster).func_76361_j(), damage);
            target.field_72308_g.func_70015_d(Math.round(fire));
        } else if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = target.func_178782_a();
            if (caster.field_70170_p.func_175623_d(pos = pos.func_177972_a(target.field_178784_b))) {
                caster.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, caster.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f);
                caster.field_70170_p.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 11);
            }
        }
    }

    @Override
    public void onCast(Entity caster, @Nullable ItemStack casterStack) {
        caster.func_130014_f_().func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_187606_E, SoundCategory.PLAYERS, 0.2f, 1.0f + (float)(caster.func_130014_f_().field_73012_v.nextGaussian() * (double)0.05f));
    }

    @Override
    public boolean hasCustomFX() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawCustomFX(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        FXDispatcher.GenPart pp = new FXDispatcher.GenPart();
        pp.grav = -0.2f;
        pp.age = 10;
        pp.alpha = new float[]{0.7f};
        pp.partStart = 640;
        pp.partInc = 1;
        pp.partNum = 10;
        pp.slowDown = 0.75;
        pp.scale = new float[]{(float)(1.5 + world.field_73012_v.nextGaussian() * (double)0.2f)};
        FXDispatcher.INSTANCE.drawGenericParticles(posX, posY, posZ, motionX, motionY, motionZ, pp);
    }
}

