/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.FocusHelper;
import thaumcraft.api.casters.IFocusBlockPicker;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.api.items.IArchitect;
import thaumcraft.common.items.casters.CasterManager;
import thaumcraft.common.items.casters.ItemCaster;
import thaumcraft.common.items.casters.ItemFocus;
import thaumcraft.common.lib.events.ServerEvents;
import thaumcraft.common.lib.utils.BlockUtils;

public class FEffectExchange
implements IFocusPartEffect,
IFocusBlockPicker,
IArchitect {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/exchange.png");
    ArrayList<BlockPos> checked = new ArrayList();

    @Override
    public IFocusPart.EnumPartAttribute[] getAttributes() {
        return new IFocusPart.EnumPartAttribute[]{IFocusPart.EnumPartAttribute.BLOCKS, IFocusPart.EnumPartAttribute.HARVEST};
    }

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.EFFECT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.EXCHANGE";
    }

    @Override
    public String getResearch() {
        return "FOCUSEXCHANGE";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.EXCHANGE;
    }

    @Override
    public int getGemColor() {
        return 13927953;
    }

    @Override
    public int getIconColor() {
        return 16775142;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getBaseCost() {
        return 0.25f;
    }

    @Override
    public void applyToTarget(Entity caster, ItemStack casterStack, FocusCore.FocusEffect focusEffect, RayTraceResult medium, RayTraceResult target) {
        if (target.field_72313_a == RayTraceResult.Type.BLOCK && !caster.field_70170_p.field_72995_K && caster instanceof EntityPlayer && casterStack != null) {
            boolean silk = focusEffect.mutators.getValue(focusEffect.mutators.SILKTOUCH) > 0.0f;
            int fortune = (int)focusEffect.mutators.getValue(focusEffect.mutators.FORTUNE);
            ItemCaster c = (ItemCaster)casterStack.func_77973_b();
            if (c.getPickedBlock(casterStack) == null) {
                return;
            }
            for (BlockPos p : this.getArchitectBlocks(casterStack, caster.field_70170_p, target.func_178782_a(), target.field_178784_b, (EntityPlayer)caster)) {
                ServerEvents.addSwapper(caster.field_70170_p, p, caster.field_70170_p.func_180495_p(p), c.getPickedBlock(casterStack), true, 0, (EntityPlayer)caster, true, false, this.getGemColor(), true, silk, fortune, ServerEvents.DEFAULT_PREDICATE, this.getBaseCost() * focusEffect.mutators.getValue(focusEffect.mutators.COST));
            }
        }
    }

    @Override
    public void onCast(Entity caster, @Nullable ItemStack casterStack) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 0.2f, 2.0f + (float)(caster.field_70170_p.field_73012_v.nextGaussian() * (double)0.05f));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ArrayList<BlockPos> getArchitectBlocks(ItemStack stack, World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        ItemCaster caster = (ItemCaster)stack.func_77973_b();
        ItemFocus focus = caster.getFocus(stack);
        if (focus != null) {
            if (ItemFocus.getCore((ItemStack)caster.getFocusStack((ItemStack)stack)).medium == FocusHelper.PLAN) {
                IBlockState bi = world.func_180495_p(pos);
                this.checked.clear();
                if (side.func_176740_k() == EnumFacing.Axis.Z) {
                    this.checkNeighbours(world, pos, bi, new BlockPos((Vec3i)pos), side, CasterManager.getAreaZ(stack), CasterManager.getAreaY(stack), CasterManager.getAreaX(stack), out, player);
                    return out;
                }
                this.checkNeighbours(world, pos, bi, new BlockPos((Vec3i)pos), side, CasterManager.getAreaX(stack), CasterManager.getAreaY(stack), CasterManager.getAreaZ(stack), out, player);
                return out;
            }
        }
        out.add(pos);
        return out;
    }

    public void checkNeighbours(World world, BlockPos pos1, IBlockState bi, BlockPos pos2, EnumFacing side, int sizeX, int sizeY, int sizeZ, ArrayList<BlockPos> list, EntityPlayer player) {
        if (this.checked.contains(pos2)) {
            return;
        }
        this.checked.add(pos2);
        switch (side.func_176740_k()) {
            case Y: {
                if (Math.abs(pos2.func_177958_n() - pos1.func_177958_n()) > sizeX) {
                    return;
                }
                if (Math.abs(pos2.func_177952_p() - pos1.func_177952_p()) <= sizeZ) break;
                return;
            }
            case Z: {
                if (Math.abs(pos2.func_177958_n() - pos1.func_177958_n()) > sizeX) {
                    return;
                }
                if (Math.abs(pos2.func_177956_o() - pos1.func_177956_o()) <= sizeZ) break;
                return;
            }
            case X: {
                if (Math.abs(pos2.func_177956_o() - pos1.func_177956_o()) > sizeX) {
                    return;
                }
                if (Math.abs(pos2.func_177952_p() - pos1.func_177952_p()) <= sizeZ) break;
                return;
            }
        }
        if (world.func_180495_p(pos2) != bi || !BlockUtils.isBlockExposed(world, pos2) || world.func_175623_d(pos2) || !(world.func_180495_p(pos2).func_185887_b(world, pos2) >= 0.0f) || !world.canMineBlockBody(player, pos2)) {
            return;
        }
        list.add(pos2);
        for (EnumFacing dir : EnumFacing.values()) {
            if (dir == side || dir.func_176734_d() == side) continue;
            this.checkNeighbours(world, pos1, bi, pos2.func_177972_a(dir), side, sizeX, sizeY, sizeZ, list, player);
        }
    }

    @Override
    public boolean showAxis(ItemStack stack, World world, EntityPlayer player, EnumFacing side, IArchitect.EnumAxis axis) {
        int dim = CasterManager.getAreaDim(stack);
        switch (side.func_176740_k()) {
            case Y: {
                if ((axis != IArchitect.EnumAxis.X || dim != 0 && dim != 1) && (axis != IArchitect.EnumAxis.Z || dim != 0 && dim != 2)) break;
                return true;
            }
            case Z: {
                if ((axis != IArchitect.EnumAxis.Y || dim != 0 && dim != 1) && (axis != IArchitect.EnumAxis.X || dim != 0 && dim != 2)) break;
                return true;
            }
            case X: {
                if ((axis != IArchitect.EnumAxis.Y || dim != 0 && dim != 1) && (axis != IArchitect.EnumAxis.Z || dim != 0 && dim != 2)) break;
                return true;
            }
        }
        return false;
    }
}

