/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockBamf;

public class FEffectCurse
implements IFocusPartEffect {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/curse.png");

    @Override
    public IFocusPart.EnumPartAttribute[] getAttributes() {
        return new IFocusPart.EnumPartAttribute[]{IFocusPart.EnumPartAttribute.ENTITIES, IFocusPart.EnumPartAttribute.TIMED};
    }

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.EFFECT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.CURSE";
    }

    @Override
    public String getResearch() {
        return "FOCUSCURSE";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.DEATH;
    }

    @Override
    public int getGemColor() {
        return 2815273;
    }

    @Override
    public int getIconColor() {
        return 0x805080;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getBaseCost() {
        return 5.0f;
    }

    @Override
    public float getDamageForDisplay(FocusCore.FocusEffect focusEffect) {
        return 1.5f * focusEffect.mutators.getValue(focusEffect.mutators.POWER);
    }

    @Override
    public void applyToTarget(Entity caster, ItemStack casterStack, FocusCore.FocusEffect focusEffect, RayTraceResult medium, RayTraceResult target) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockBamf(target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, this.getGemColor(), true, true, null), new NetworkRegistry.TargetPoint(caster.field_70170_p.field_73011_w.getDimension(), medium.field_72307_f.field_72450_a, medium.field_72307_f.field_72448_b, medium.field_72307_f.field_72449_c, 32.0));
        if (target.field_72313_a == RayTraceResult.Type.ENTITY && target.field_72308_g != null) {
            int duration = (int)(80.0f * focusEffect.mutators.getValue(focusEffect.mutators.TIME));
            float eff = 1.0f * focusEffect.mutators.getValue(focusEffect.mutators.POWER) - 1.0f;
            float damage = this.getDamageForDisplay(focusEffect);
            if (eff < 0.0f) {
                eff = 0.0f;
            }
            target.field_72308_g.func_70097_a(DamageSource.func_76354_b((Entity)(medium.field_72308_g != null ? medium.field_72308_g : caster), (Entity)caster), damage);
            if (target.field_72308_g instanceof EntityLivingBase) {
                ((EntityLivingBase)target.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76421_d, duration / 2, Math.round(eff)));
                ((EntityLivingBase)target.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76437_t, duration, Math.round(eff)));
                ((EntityLivingBase)target.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration * 2, Math.round(eff)));
                ((EntityLivingBase)target.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_189112_A, duration * 3, Math.round(eff)));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawCustomFX(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        FXDispatcher.INSTANCE.drawGenericParticles16(posX, posY, posZ, motionX, motionY, motionZ, 0.5f, 0.0f, 1.0f, 0.7f, false, 108 + world.field_73012_v.nextInt(4), 1, 1, 4, 0, (float)(2.0 + world.field_73012_v.nextGaussian() * 0.5), 0.0f, 0);
    }

    @Override
    public boolean hasCustomFX() {
        return true;
    }

    @Override
    public void onCast(Entity caster, @Nullable ItemStack casterStack) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_187514_aD, SoundCategory.PLAYERS, 0.1f, 0.8f);
    }
}

