/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.FocusHelper;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.api.items.IArchitect;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.items.casters.CasterManager;
import thaumcraft.common.items.casters.ItemCaster;
import thaumcraft.common.items.casters.ItemFocus;
import thaumcraft.common.lib.events.ServerEvents;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXFocusPartImpact;
import thaumcraft.common.lib.utils.BlockUtils;

public class FEffectBreak
implements IFocusPartEffect,
IArchitect {
    ResourceLocation icon = new ResourceLocation("thaumcraft", "textures/foci/break.png");
    ArrayList<BlockPos> checked = new ArrayList();

    @Override
    public IFocusPart.EnumPartAttribute[] getAttributes() {
        return new IFocusPart.EnumPartAttribute[]{IFocusPart.EnumPartAttribute.BLOCKS, IFocusPart.EnumPartAttribute.HARVEST};
    }

    @Override
    public IFocusPart.EnumFocusPartType getType() {
        return IFocusPart.EnumFocusPartType.EFFECT;
    }

    @Override
    public String getKey() {
        return "thaumcraft.BREAK";
    }

    @Override
    public String getResearch() {
        return "FOCUSBREAK";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.ENTROPY;
    }

    @Override
    public int getGemColor() {
        return 9063176;
    }

    @Override
    public int getIconColor() {
        return 16249568;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public float getBaseCost() {
        return 0.5f;
    }

    @Override
    public void applyToTarget(final Entity caster, ItemStack casterStack, FocusCore.FocusEffect focusEffect, RayTraceResult medium, final RayTraceResult target) {
        if (target.field_72313_a == RayTraceResult.Type.BLOCK && caster instanceof EntityPlayer && !caster.field_70170_p.field_72995_K) {
            boolean silk = focusEffect.mutators.getValue(focusEffect.mutators.SILKTOUCH) > 0.0f;
            int fortune = (int)focusEffect.mutators.getValue(focusEffect.mutators.FORTUNE);
            float strength = focusEffect.mutators.getValue(focusEffect.mutators.POWER);
            strength *= strength;
            boolean w = false;
            ArrayList<BlockPos> usl = this.getArchitectBlocks(casterStack, caster.field_70170_p, target.func_178782_a(), target.field_178784_b, (EntityPlayer)caster);
            ArrayList sl = (ArrayList)usl.stream().sorted(new BlockUtils.BlockPosComparator(target.func_178782_a())).collect(Collectors.toList());
            int n = 0;
            for (final BlockPos p : sl) {
                float dur = caster.field_70170_p.func_180495_p(p).func_185887_b(caster.field_70170_p, p) * 10.0f;
                dur = (float)Math.sqrt(dur);
                ServerEvents.addBreaker(caster.field_70170_p, p, (EntityPlayer)caster, true, silk, fortune, strength, dur, dur, (int)(dur / strength / 3.0f * (float)n), new Runnable(){

                    @Override
                    public void run() {
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXFocusPartImpact((double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5, new String[]{FEffectBreak.this.getKey()}), new NetworkRegistry.TargetPoint(caster.field_70170_p.field_73011_w.getDimension(), target.field_72307_f.field_72450_a, target.field_72307_f.field_72448_b, target.field_72307_f.field_72449_c, 32.0));
                    }
                });
                if (w) {
                    float a = this.getBaseCost() * focusEffect.mutators.getValue(focusEffect.mutators.COST);
                    if (AuraHelper.drainVis(caster.field_70170_p, target.func_178782_a(), a, false) < a) break;
                }
                w = true;
                ++n;
            }
        }
    }

    @Override
    public boolean hasCustomFX() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawCustomFX(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        FXGeneric fb = new FXGeneric(world, posX, posY, posZ, motionX, motionY, motionZ);
        fb.func_187114_a(6 + world.field_73012_v.nextInt(6));
        int q = world.field_73012_v.nextInt(4);
        fb.setParticles(704 + q * 3, 3, 1);
        fb.setSlowDown(0.8);
        fb.setScale((float)((double)1.7f + world.field_73012_v.nextGaussian() * (double)0.3f));
        ParticleEngine.INSTANCE.addEffect(world, (Particle)fb);
    }

    @Override
    public void onCast(Entity caster, @Nullable ItemStack casterStack) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_187598_bd, SoundCategory.PLAYERS, 0.1f, 2.0f + (float)(caster.field_70170_p.field_73012_v.nextGaussian() * (double)0.05f));
    }

    @Override
    public boolean showAxis(ItemStack stack, World world, EntityPlayer player, EnumFacing side, IArchitect.EnumAxis axis) {
        int dim = CasterManager.getAreaDim(stack);
        switch (axis) {
            case Y: {
                if (dim != 0 && dim != 3) break;
                return true;
            }
            case Z: {
                if (dim != 0 && dim != 2) break;
                return true;
            }
            case X: {
                if (dim != 0 && dim != 1) break;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ArrayList<BlockPos> getArchitectBlocks(ItemStack stack, World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        ItemCaster caster = (ItemCaster)stack.func_77973_b();
        ItemFocus focus = caster.getFocus(stack);
        if (focus != null) {
            if (ItemFocus.getCore((ItemStack)caster.getFocusStack((ItemStack)stack)).medium == FocusHelper.PLAN) {
                this.checked.clear();
                this.checkNeighbours(world, pos, new BlockPos((Vec3i)pos), side, CasterManager.getAreaX(stack), CasterManager.getAreaY(stack), CasterManager.getAreaZ(stack), out, player);
                return out;
            }
        }
        out.add(pos);
        return out;
    }

    public void checkNeighbours(World world, BlockPos pos1, BlockPos pos2, EnumFacing side, int sizeX, int sizeY, int sizeZ, ArrayList<BlockPos> list, EntityPlayer player) {
        if (this.checked.contains(pos2)) {
            return;
        }
        this.checked.add(pos2);
        if (!world.func_175623_d(pos2) && world.func_180495_p(pos2).func_185887_b(world, pos2) >= 0.0f && world.canMineBlockBody(player, pos2)) {
            list.add(pos2);
        }
        int xs = -sizeX + pos1.func_177958_n();
        int xe = sizeX + pos1.func_177958_n();
        int ys = -sizeY + pos1.func_177956_o();
        int ye = sizeY + pos1.func_177956_o();
        int zs = -sizeZ + pos1.func_177952_p();
        int ze = sizeZ + pos1.func_177952_p();
        xs -= sizeX * side.func_82601_c();
        xe -= sizeX * side.func_82601_c();
        ys -= sizeY * side.func_96559_d();
        ye -= sizeY * side.func_96559_d();
        zs -= sizeZ * side.func_82599_e();
        ze -= sizeZ * side.func_82599_e();
        for (EnumFacing dir : EnumFacing.values()) {
            BlockPos q = pos2.func_177972_a(dir);
            if (q.func_177958_n() < xs || q.func_177958_n() > xe || q.func_177956_o() < ys || q.func_177956_o() > ye || q.func_177952_p() < zs || q.func_177952_p() > ze) continue;
            this.checkNeighbours(world, pos1, q, side, sizeX, sizeY, sizeZ, list, player);
        }
    }
}

