/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters;

import java.awt.Color;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartModifier;
import thaumcraft.common.items.ItemTCBase;

public class ItemFocus
extends ItemTCBase {
    public ItemFocus() {
        super("focus", new String[0]);
        this.field_77777_bU = 1;
        this.func_77656_e(0);
        this.func_77637_a(null);
    }

    public int[] getFocusColors(ItemStack focusstack) {
        int[] nArray;
        int[] colors = focusstack.func_77978_p().func_74759_k("colors");
        if (colors == null || colors.length == 0) {
            colors = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};
            FocusCore core = ItemFocus.getCore(focusstack);
            if (core != null && core.effects != null) {
                int r = 0;
                int g = 0;
                int b = 0;
                for (FocusCore.FocusEffect ef : core.effects) {
                    Color c = new Color(ef.effect.getGemColor());
                    r += c.getRed();
                    g += c.getGreen();
                    b += c.getBlue();
                }
                Color c = new Color(r /= core.effects.length, g /= core.effects.length, b /= core.effects.length);
                colors[0] = c.getRGB();
                int i = 1;
                for (IFocusPart p : core.partsRaw.values()) {
                    colors[i] = p.getIconColor();
                    ++i;
                }
                NBTTagIntArray cn = new NBTTagIntArray(colors);
                focusstack.func_77983_a("colors", (NBTBase)cn);
            }
        }
        if (colors.length > 0) {
            nArray = colors;
        } else {
            int[] nArray2 = new int[8];
            nArray2[0] = 0xFFFFFF;
            nArray2[1] = 0xFFFFFF;
            nArray2[2] = 0xFFFFFF;
            nArray2[3] = 0xFFFFFF;
            nArray2[4] = 0xFFFFFF;
            nArray2[5] = 0xFFFFFF;
            nArray2[6] = 0xFFFFFF;
            nArray = nArray2;
            nArray2[7] = 0xFFFFFF;
        }
        return nArray;
    }

    public String getSortingHelper(ItemStack focusstack) {
        return ItemFocus.getCore(focusstack).getSortingHelper();
    }

    public static void setCore(ItemStack focusstack, FocusCore core) {
        NBTTagCompound tag = core.serialize();
        focusstack.func_77983_a("core", (NBTBase)tag);
    }

    public static FocusCore getCore(ItemStack focusstack) {
        NBTTagCompound tag = focusstack.func_179543_a("core", true);
        return new FocusCore(tag);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        float al = this.getVisCost(stack);
        String amount = ItemStack.field_111284_a.format(al);
        list.add(amount + " " + I18n.func_74838_a((String)"item.Focus.cost1"));
        this.addFocusInformation(stack, player, list, par4);
    }

    public void addFocusInformation(ItemStack focusstack, EntityPlayer player, List list, boolean par4) {
        FocusCore core = ItemFocus.getCore(focusstack);
        String t = TextFormatting.GOLD + core.medium.getName();
        if (core.mediumModifiers != null && core.mediumModifiers.length > 0) {
            t = t + TextFormatting.DARK_AQUA + " [";
            boolean q = false;
            for (IFocusPartModifier p : core.mediumModifiers) {
                if (p.getType() == IFocusPart.EnumFocusPartType.EFFECT) continue;
                t = t + (q ? ", " : "") + p.getName();
                q = true;
            }
            t = t + "]";
        }
        list.add(t);
        float d = 0.0f;
        for (FocusCore.FocusEffect fe : core.effects) {
            String t0 = TextFormatting.DARK_PURPLE + fe.effect.getName();
            d += fe.effect.getDamageForDisplay(fe);
            if (fe.modifiers != null && fe.modifiers.length > 0) {
                t0 = t0 + TextFormatting.DARK_AQUA + " [";
                boolean q = false;
                for (IFocusPartModifier p : fe.modifiers) {
                    if (p.getType() == IFocusPart.EnumFocusPartType.MEDIUM) continue;
                    t0 = t0 + (q ? ", " : "") + p.getName();
                    q = true;
                }
                t0 = t0 + "]";
            }
            list.add(t0);
            if (!(d > 0.0f)) continue;
            list.add(TextFormatting.DARK_RED + "  " + I18n.func_74837_a((String)"attribute.modifier.equals.0", (Object[])new Object[]{ItemStack.field_111284_a.format(d), I18n.func_74838_a((String)"attribute.name.generic.attackDamage")}));
        }
    }

    public EnumRarity func_77613_e(ItemStack focusstack) {
        return EnumRarity.RARE;
    }

    public float getVisCost(ItemStack focusstack) {
        return ItemFocus.getCore((ItemStack)focusstack).cost;
    }

    public int getActivationTime(ItemStack focusstack) {
        return ItemFocus.getCore(focusstack).getFinalChargeTime();
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return super.func_77659_a(itemStackIn, worldIn, playerIn, hand);
    }
}

