/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.Thaumcraft;
import thaumcraft.api.casters.CasterEngine;
import thaumcraft.api.casters.CasterTriggerRegistry;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.FocusHelper;
import thaumcraft.api.casters.IFocusBlockPicker;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.api.casters.IFocusPartMedium;
import thaumcraft.api.casters.IInteractWithCaster;
import thaumcraft.api.casters.MutatorStore;
import thaumcraft.api.items.IArchitect;
import thaumcraft.api.items.IArchitectExtended;
import thaumcraft.api.items.RechargeHelper;
import thaumcraft.codechicken.lib.math.MathHelper;
import thaumcraft.common.items.ItemTCBase;
import thaumcraft.common.items.casters.CasterManager;
import thaumcraft.common.items.casters.ICaster;
import thaumcraft.common.items.casters.ItemFocus;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketAuraToClient;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.world.aura.AuraChunk;
import thaumcraft.common.world.aura.AuraHandler;

public class ItemCaster
extends ItemTCBase
implements IArchitectExtended,
ICaster {
    int area = 0;
    DecimalFormat myFormatter = new DecimalFormat("#######.#");
    ArrayList<BlockPos> checked = new ArrayList();

    public ItemCaster(String name, int area) {
        super(name, new String[0]);
        this.area = area;
        this.field_77777_bU = 1;
        this.func_77656_e(0);
        this.func_185043_a(new ResourceLocation("focus"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                ItemFocus f = ((ItemCaster)stack.func_77973_b()).getFocus(stack);
                if (stack.func_77973_b() instanceof ItemCaster && f != null) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77973_b() != null && oldStack.func_77973_b() == this && newStack.func_77973_b() != null && newStack.func_77973_b() == this) {
            ItemFocus oldf = ((ItemCaster)oldStack.func_77973_b()).getFocus(oldStack);
            ItemFocus newf = ((ItemCaster)newStack.func_77973_b()).getFocus(newStack);
            int s1 = 0;
            int s2 = 0;
            if (oldf != null) {
                s1 = ItemFocus.getCore(((ItemCaster)oldStack.func_77973_b()).getFocusStack(oldStack)).getSortingHelper().hashCode();
            }
            if (newf != null) {
                s2 = ItemFocus.getCore(((ItemCaster)newStack.func_77973_b()).getFocusStack(newStack)).getSortingHelper().hashCode();
            }
            return s1 != s2;
        }
        return newStack.func_77973_b() != oldStack.func_77973_b();
    }

    public boolean func_77645_m() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    private float getAuraPool(EntityPlayer player) {
        float tot = 0.0f;
        switch (this.area) {
            default: {
                tot = AuraHandler.getVis(player.field_70170_p, player.func_180425_c());
                break;
            }
            case 1: {
                tot = AuraHandler.getVis(player.field_70170_p, player.func_180425_c());
                for (EnumFacing face : EnumFacing.field_176754_o) {
                    tot += AuraHandler.getVis(player.field_70170_p, player.func_180425_c().func_177967_a(face, 16));
                }
                break;
            }
            case 2: {
                tot = 0.0f;
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        tot += AuraHandler.getVis(player.field_70170_p, player.func_180425_c().func_177982_a(xx * 16, 0, zz * 16));
                    }
                }
            }
        }
        return tot;
    }

    @Override
    public boolean consumeVis(ItemStack is, EntityPlayer player, float amount, boolean crafting, boolean sim) {
        amount *= this.getConsumptionModifier(is, player, crafting);
        float tot = this.getAuraPool(player);
        if (tot < amount) {
            return false;
        }
        if (sim) {
            return true;
        }
        block0 : switch (this.area) {
            default: {
                amount -= AuraHandler.drainVis(player.field_70170_p, player.func_180425_c(), amount, sim);
                break;
            }
            case 1: {
                float i = amount / 5.0f;
                while (amount > 0.0f) {
                    if (i > amount) {
                        i = amount;
                    }
                    if ((amount -= AuraHandler.drainVis(player.field_70170_p, player.func_180425_c(), i, sim)) <= 0.0f) break block0;
                    if (i > amount) {
                        i = amount;
                    }
                    for (EnumFacing face : EnumFacing.field_176754_o) {
                        if ((amount -= AuraHandler.drainVis(player.field_70170_p, player.func_180425_c().func_177967_a(face, 16), i, sim)) <= 0.0f) break block0;
                    }
                }
                break;
            }
            case 2: {
                float i = amount / 9.0f;
                while (amount > 0.0f) {
                    if (i > amount) {
                        i = amount;
                    }
                    for (int xx = -1; xx <= 1; ++xx) {
                        for (int zz = -1; zz <= 1; ++zz) {
                            if ((amount -= AuraHandler.drainVis(player.field_70170_p, player.func_180425_c().func_177982_a(xx * 16, 0, zz * 16), i, sim)) <= 0.0f) break block0;
                        }
                    }
                }
                break block0;
            }
        }
        return amount <= 0.0f;
    }

    @Override
    public float getConsumptionModifier(ItemStack is, EntityPlayer player, boolean crafting) {
        float consumptionModifier = 1.0f;
        if (player != null) {
            consumptionModifier -= CasterManager.getTotalVisDiscount(player);
        }
        return Math.max(consumptionModifier, 0.1f);
    }

    @Override
    public ItemFocus getFocus(ItemStack stack) {
        NBTTagCompound nbt;
        ItemStack fs;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("focus") && (fs = ItemStack.func_77949_a((NBTTagCompound)(nbt = stack.func_77978_p().func_74775_l("focus")))) != null) {
            return (ItemFocus)fs.func_77973_b();
        }
        return null;
    }

    @Override
    public ItemStack getFocusStack(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("focus")) {
            NBTTagCompound nbt = stack.func_77978_p().func_74775_l("focus");
            return ItemStack.func_77949_a((NBTTagCompound)nbt);
        }
        return null;
    }

    @Override
    public void setFocus(ItemStack stack, ItemStack focus) {
        if (focus == null) {
            stack.func_77978_p().func_82580_o("focus");
        } else {
            stack.func_77983_a("focus", (NBTBase)focus.func_77955_b(new NBTTagCompound()));
        }
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.UNCOMMON;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (stack.func_77942_o()) {
            float amt;
            String tt = "";
            int amount = RechargeHelper.getCharge(stack);
            float mod = this.getConsumptionModifier(stack, player, false);
            String consumption = this.myFormatter.format(mod * 100.0f);
            String text = "";
            ItemStack focus = this.getFocusStack(stack);
            if (focus != null && (amt = ((ItemFocus)focus.func_77973_b()).getVisCost(focus) * mod) > 0.0f) {
                text = "\u00a7r, " + this.myFormatter.format(amt) + " " + I18n.func_74838_a((String)"item.Focus.cost1");
            }
            if (Thaumcraft.proxy.isShiftKeyDown()) {
                list.add(" \u00a7" + I18n.func_74838_a((String)"tc.vis.cost") + "\u00a7r " + this.myFormatter.format(amount) + ", \u00a7o(" + consumption + "%" + text);
            } else {
                if (tt.length() > 0) {
                    tt = tt + " | ";
                }
                tt = tt + "\u00a7" + this.myFormatter.format(amount) + "\u00a7r";
            }
        }
        if (this.getFocus(stack) != null) {
            list.add(TextFormatting.BOLD + "" + TextFormatting.ITALIC + "" + TextFormatting.GREEN + this.getFocus(stack).func_77653_i(this.getFocusStack(stack)));
            if (Thaumcraft.proxy.isShiftKeyDown()) {
                this.getFocus(stack).addFocusInformation(this.getFocusStack(stack), player, list, par4);
            }
        }
    }

    public void func_77663_a(ItemStack is, World w, Entity e, int slot, boolean currentItem) {
        if (currentItem && !w.field_72995_K && e.field_70173_aa % 10 == 0 && e instanceof EntityPlayerMP) {
            this.updateAura(is, w, (EntityPlayerMP)e);
        }
    }

    private void updateAura(ItemStack stack, World world, EntityPlayerMP player) {
        float cv = 0.0f;
        float cf = 0.0f;
        short bv = 0;
        switch (this.area) {
            default: {
                AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.getDimension(), (int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
                cv = ac.getVis();
                cf = ac.getFlux();
                bv = ac.getBase();
                break;
            }
            case 1: {
                AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.getDimension(), (int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
                cv = ac.getVis();
                cf = ac.getFlux();
                bv = ac.getBase();
                for (EnumFacing face : EnumFacing.field_176754_o) {
                    ac = AuraHandler.getAuraChunk(world.field_73011_w.getDimension(), ((int)player.field_70165_t >> 4) + face.func_82601_c(), ((int)player.field_70161_v >> 4) + face.func_82599_e());
                    cv += ac.getVis();
                    cf += ac.getFlux();
                    bv = (short)(bv + ac.getBase());
                }
                break;
            }
            case 2: {
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.getDimension(), ((int)player.field_70165_t >> 4) + xx, ((int)player.field_70161_v >> 4) + zz);
                        cv += ac.getVis();
                        cf += ac.getFlux();
                        bv = (short)(bv + ac.getBase());
                    }
                }
            }
        }
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketAuraToClient(new AuraChunk(null, bv, cv, cf)), player);
    }

    public EnumActionResult onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        IBlockState bs = world.func_180495_p(pos);
        if (bs.func_177230_c() instanceof IInteractWithCaster && ((IInteractWithCaster)bs.func_177230_c()).onCasterRightClick(world, itemstack, player, pos, side, hand)) {
            return EnumActionResult.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof IInteractWithCaster && ((IInteractWithCaster)tile).onCasterRightClick(world, itemstack, player, pos, side, hand)) {
            return EnumActionResult.SUCCESS;
        }
        if (CasterTriggerRegistry.hasTrigger(bs)) {
            return CasterTriggerRegistry.performTrigger(world, itemstack, player, pos, side, bs) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        ItemStack fb = this.getFocusStack(itemstack);
        if (fb != null) {
            FocusCore core = ItemFocus.getCore(fb);
            for (IFocusPart fe : core.partsRaw.values()) {
                ItemStack isout;
                if (!(fe instanceof IFocusBlockPicker) || !player.func_70093_af() || world.func_175625_s(pos) != null) continue;
                if (!world.field_72995_K) {
                    isout = new ItemStack(bs.func_177230_c(), 1, bs.func_177230_c().func_176201_c(bs));
                    try {
                        ItemStack is;
                        if (bs != Blocks.field_150350_a && (is = BlockUtils.getSilkTouchDrop(bs)) != null) {
                            isout = is.func_77946_l();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } else {
                    player.func_184609_a(hand);
                    return EnumActionResult.PASS;
                }
                this.storePickedBlock(itemstack, isout);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    private RayTraceResult generateSourceVector(Entity e) {
        Vec3d v = e.func_174791_d();
        boolean mainhand = true;
        if (e instanceof EntityPlayer) {
            if (((EntityPlayer)e).func_184614_ca() != null && ((EntityPlayer)e).func_184614_ca().func_77973_b() instanceof ICaster) {
                mainhand = true;
            } else if (((EntityPlayer)e).func_184592_cb() != null && ((EntityPlayer)e).func_184592_cb().func_77973_b() instanceof ICaster) {
                mainhand = false;
            }
        }
        double posX = -MathHelper.cos((e.field_70177_z - 0.5f) / 180.0f * 3.141593f) * (double)0.2f * (double)(mainhand ? 1 : -1);
        double posZ = -MathHelper.sin((e.field_70177_z - 0.5f) / 180.0f * 3.141593f) * (double)0.3f * (double)(mainhand ? 1 : -1);
        Vec3d vl = e.func_70040_Z();
        v = v.func_72441_c(posX, (double)e.func_70047_e() - 0.4000000014901161, posZ);
        v = v.func_178787_e(vl);
        return new RayTraceResult(e, v);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemstack, World world, EntityPlayer player, EnumHand hand) {
        ItemStack focusStack = this.getFocusStack(itemstack);
        ItemFocus focus = this.getFocus(itemstack);
        if (focus != null) {
            FocusCore nc;
            FocusCore core = ItemFocus.getCore(focusStack);
            if (player.func_70093_af()) {
                for (IFocusPart fe : core.partsRaw.values()) {
                    if (!(fe instanceof IFocusBlockPicker) || !player.func_70093_af()) continue;
                    return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
                }
            }
            if (world.field_72995_K) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            if (core.getFinalCastMethod() == IFocusPartMedium.EnumFocusCastMethod.INSTANT) {
                if (this.consumeVis(itemstack, player, focus.getVisCost(focusStack), false, true)) {
                    nc = core.copy();
                    nc.uniqueId = world.field_73012_v.nextInt();
                    if (CasterEngine.cast(nc, (Entity)player, itemstack, this.generateSourceVector((Entity)player), player.func_70040_Z(), new MutatorStore())) {
                        player.func_184609_a(hand);
                        this.consumeVis(itemstack, player, focus.getVisCost(focusStack), false, false);
                        CasterManager.setCooldown((EntityLivingBase)player, focus.getActivationTime(focusStack));
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
                    }
                    return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                }
            } else {
                if (core.getFinalCastMethod() == IFocusPartMedium.EnumFocusCastMethod.DEFAULT && !CasterManager.isOnCooldown((EntityLivingBase)player) && this.consumeVis(itemstack, player, focus.getVisCost(focusStack), false, true)) {
                    nc = core.copy();
                    nc.uniqueId = world.field_73012_v.nextInt();
                    if (CasterEngine.cast(nc, (Entity)player, itemstack, this.generateSourceVector((Entity)player), player.func_70040_Z(), new MutatorStore())) {
                        this.consumeVis(itemstack, player, focus.getVisCost(focusStack), false, false);
                        CasterManager.setCooldown((EntityLivingBase)player, focus.getActivationTime(focusStack));
                    }
                }
                player.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
        }
        return super.func_77659_a(itemstack, world, player, hand);
    }

    public void onUsingTick(ItemStack itemstack, EntityLivingBase player, int count) {
        ItemStack focusStack = this.getFocusStack(itemstack);
        ItemFocus focus = this.getFocus(itemstack);
        if (focus != null) {
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            FocusCore core = ItemFocus.getCore(focusStack);
            if (core.getFinalCastMethod() == IFocusPartMedium.EnumFocusCastMethod.DEFAULT && count % focus.getActivationTime(focusStack) == 0 && !CasterManager.isOnCooldown(player) && this.consumeVis(itemstack, (EntityPlayer)player, focus.getVisCost(focusStack), false, true)) {
                FocusCore nc = core.copy();
                nc.uniqueId = player.func_130014_f_().field_73012_v.nextInt();
                if (CasterEngine.cast(nc, (Entity)player, itemstack, this.generateSourceVector((Entity)player), player.func_70040_Z(), new MutatorStore())) {
                    this.consumeVis(itemstack, (EntityPlayer)player, focus.getVisCost(focusStack), false, false);
                    CasterManager.setCooldown(player, focus.getActivationTime(focusStack));
                }
            } else if (core.getFinalCastMethod() == IFocusPartMedium.EnumFocusCastMethod.CHARGE && count == 1) {
                player.func_184597_cx();
            }
        }
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityLivingBase player, int timeLeft) {
        FocusCore core;
        if (world.field_72995_K) {
            return;
        }
        ItemStack focusStack = this.getFocusStack(itemstack);
        ItemFocus focus = this.getFocus(itemstack);
        if (focus != null && (core = ItemFocus.getCore(focusStack)).getFinalCastMethod() == IFocusPartMedium.EnumFocusCastMethod.CHARGE) {
            float max = focus.getActivationTime(focusStack);
            float count = this.func_77626_a(itemstack) - timeLeft;
            if (count > max) {
                count = max;
            }
            float progress = count / max;
            double rad = (double)(100.0f + progress * 80.0f) * 0.017453292519943;
            float charge = (float)MathHelper.clip(2.0 + 1.5 * Math.tan(rad) / 5.671, 0.5, 2.0);
            if (this.consumeVis(itemstack, (EntityPlayer)player, focus.getVisCost(focusStack) * charge, false, true)) {
                MutatorStore ms = new MutatorStore();
                ms.modifyMutator(ms.POWER, charge);
                FocusCore nc = core.copy();
                nc.uniqueId = world.field_73012_v.nextInt();
                if (CasterEngine.cast(nc, (Entity)player, itemstack, this.generateSourceVector((Entity)player), player.func_70040_Z(), ms)) {
                    this.consumeVis(itemstack, (EntityPlayer)player, focus.getVisCost(focusStack) * charge, false, false);
                }
            }
        }
    }

    public int func_77626_a(ItemStack itemstack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    @Override
    public ArrayList<BlockPos> getArchitectBlocks(ItemStack stack, World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        ItemFocus focus = this.getFocus(stack);
        if (focus != null) {
            if (ItemFocus.getCore((ItemStack)this.getFocusStack((ItemStack)stack)).medium == FocusHelper.PLAN) {
                for (FocusCore.FocusEffect fe : ItemFocus.getCore((ItemStack)this.getFocusStack((ItemStack)stack)).effects) {
                    IFocusPartEffect fpe = fe.effect;
                    if (!(fpe instanceof IArchitect)) continue;
                    return ((IArchitect)((Object)fpe)).getArchitectBlocks(stack, world, pos, side, player);
                }
            }
        }
        return null;
    }

    @Override
    public boolean showAxis(ItemStack stack, World world, EntityPlayer player, EnumFacing side, IArchitect.EnumAxis axis) {
        ItemFocus focus = this.getFocus(stack);
        if (focus != null) {
            if (ItemFocus.getCore((ItemStack)this.getFocusStack((ItemStack)stack)).medium == FocusHelper.PLAN) {
                for (FocusCore.FocusEffect fe : ItemFocus.getCore((ItemStack)this.getFocusStack((ItemStack)stack)).effects) {
                    IFocusPartEffect fpe = fe.effect;
                    if (!(fpe instanceof IArchitect)) continue;
                    return ((IArchitect)((Object)fpe)).showAxis(stack, world, player, side, axis);
                }
            }
        }
        return false;
    }

    @Override
    public RayTraceResult getArchitectMOP(ItemStack stack, World world, EntityLivingBase player) {
        ItemFocus focus = this.getFocus(stack);
        if (focus != null) {
            if (ItemFocus.getCore((ItemStack)this.getFocusStack((ItemStack)stack)).medium == FocusHelper.PLAN) {
                return Utils.rayTrace(world, (Entity)player, false);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean useBlockHighlight(ItemStack stack) {
        ItemFocus focus = this.getFocus(stack);
        if (focus == null) return false;
        if (ItemFocus.getCore((ItemStack)this.getFocusStack((ItemStack)stack)).medium != FocusHelper.PLAN) return false;
        return true;
    }

    public void storePickedBlock(ItemStack stack, ItemStack stackout) {
        NBTTagCompound item = new NBTTagCompound();
        stack.func_77983_a("picked", (NBTBase)stackout.func_77955_b(item));
    }

    @Override
    public ItemStack getPickedBlock(ItemStack stack) {
        ItemStack out = null;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("picked")) {
            out = new ItemStack(Blocks.field_150350_a);
            out.func_77963_c(stack.func_77978_p().func_74775_l("picked"));
        }
        return out;
    }
}

