/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.renderers.tile;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.client.renderers.models.block.ModelBoreBase;
import thaumcraft.common.tiles.essentia.TileAlembic;

@SideOnly(value=Side.CLIENT)
public class TileAlembicRenderer
extends TileEntitySpecialRenderer {
    private ModelBoreBase modelBore = new ModelBoreBase();
    private static final ResourceLocation TEX_LABEL = new ResourceLocation("thaumcraft", "textures/models/label.png");
    private static final ResourceLocation TEX_BORE = new ResourceLocation("thaumcraft", "textures/models/bore.png");

    public void renderTileEntityAt(TileAlembic tile, double x, double y, double z, float f) {
        if (tile.aspectFilter != null) {
            GL11.glPushMatrix();
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            switch (tile.facing) {
                case 5: {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 3: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 2: {
                    GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.5f, (float)-0.376f);
            UtilsFX.renderQuadCentered(TEX_LABEL, 0.44f, 1.0f, 1.0f, 1.0f, -99, 771, 1.0f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.5f, (float)-0.377f);
            GL11.glScaled((double)0.02, (double)0.02, (double)0.02);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            UtilsFX.drawTag(-8, -8, tile.aspectFilter);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
        if (tile.func_145831_w() != null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_147499_a(TEX_BORE);
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                TileEntity te;
                if (!tile.canOutputTo(dir) || (te = ThaumcraftApiHelper.getConnectableTile(tile.func_145831_w(), tile.func_174877_v(), dir)) == null || !((IEssentiaTransport)te).canInputFrom(dir.func_176734_d())) continue;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
                switch (dir.ordinal()) {
                    case 0: {
                        GL11.glTranslatef((float)-0.5f, (float)0.5f, (float)0.0f);
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                        break;
                    }
                    case 1: {
                        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        break;
                    }
                    case 2: {
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 3: {
                        GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 4: {
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 5: {
                        GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                }
                this.modelBore.renderNozzle();
                GL11.glPopMatrix();
            }
        }
    }

    public void func_180535_a(TileEntity par1TileEntity, double par2, double par4, double par6, float par8, int q) {
        this.renderTileEntityAt((TileAlembic)par1TileEntity, par2, par4, par6, par8);
    }
}

