/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.events;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.golems.ISealDisplayer;
import thaumcraft.api.golems.seals.ISealConfigArea;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.seals.SealPos;
import thaumcraft.api.items.IArchitect;
import thaumcraft.api.items.IArchitectExtended;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.RechargeHelper;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.client.gui.GuiResearchPopup;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.client.lib.events.HudHandler;
import thaumcraft.client.lib.events.ShaderHandler;
import thaumcraft.client.lib.events.WandRenderingHandler;
import thaumcraft.codechicken.lib.raytracer.RayTracer;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.construct.golem.seals.SealEntity;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.entities.monster.mods.ChampionModifier;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.events.EssentiaHandler;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketNote;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.tiles.crafting.TileInfusionMatrix;
import thaumcraft.common.tiles.devices.TileArcaneEar;
import thaumcraft.common.tiles.devices.TileRedstoneRelay;

public class RenderEventHandler {
    public static RenderEventHandler INSTANCE = new RenderEventHandler();
    @SideOnly(value=Side.CLIENT)
    public HudHandler hudHandler = new HudHandler();
    @SideOnly(value=Side.CLIENT)
    public WandRenderingHandler wandHandler = new WandRenderingHandler();
    @SideOnly(value=Side.CLIENT)
    ShaderHandler shaderhandler = new ShaderHandler();
    public static List blockTags = new ArrayList();
    public static float tagscale = 0.0f;
    public static GuiResearchPopup researchPopup = null;
    public int tickCount = 0;
    boolean checkedDate = false;
    private Random random = new Random();
    public static TreeMap<Integer, ChargeEntry> chargedItems = new TreeMap();
    public static boolean resetShaders = false;
    private static int oldDisplayWidth = 0;
    private static int oldDisplayHeight = 0;
    final ResourceLocation CFRAME = new ResourceLocation("thaumcraft", "textures/misc/frame_corner.png");
    final ResourceLocation MIDDLE = new ResourceLocation("thaumcraft", "textures/misc/seal_area.png");
    EnumFacing[][] rotfaces = new EnumFacing[][]{{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.NORTH, EnumFacing.WEST}, {EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST}, {EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.EAST}, {EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.WEST}};
    int[][] rotmat = new int[][]{{0, 270, 0}, {270, 180, 270}, {90, 0, 90}, {180, 90, 180}, {180, 180, 0}, {90, 270, 270}, {270, 90, 90}, {0, 0, 180}};
    public static HashMap<Integer, ShaderGroup> shaderGroups = new HashMap();
    public static boolean fogFiddled = false;
    public static float fogTarget = 0.0f;
    public static int fogDuration = 0;
    public static float prevVignetteBrightness = 0.0f;
    public static float targetBrightness = 1.0f;
    protected static final ResourceLocation vignetteTexPath = new ResourceLocation("thaumcraft", "textures/misc/vignette.png");

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START) {
            if (event.player.field_70173_aa % 20 == 0) {
                this.checkChargedItems(event.player);
            }
            try {
                if (event.player.func_145782_y() == mc.field_71439_g.func_145782_y()) {
                    this.shaderhandler.checkShaders(event, mc);
                    if (ShaderHandler.warpVignette > 0) {
                        --ShaderHandler.warpVignette;
                        targetBrightness = 0.0f;
                    } else {
                        targetBrightness = 1.0f;
                    }
                    if (fogFiddled) {
                        if (fogDuration < 100) {
                            fogTarget = 0.1f * ((float)fogDuration / 100.0f);
                        } else if (fogTarget < 0.1f) {
                            fogTarget += 0.001f;
                        }
                        if (--fogDuration < 0) {
                            fogFiddled = false;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void checkChargedItems(EntityPlayer player) {
        int a;
        long time = System.currentTimeMillis();
        int count = 0;
        ItemStack[] inv = player.field_71071_by.field_70462_a;
        int a2 = 0;
        while (true) {
            EntityPlayer entityPlayer = player;
            if (a2 >= entityPlayer.field_71071_by.func_70451_h()) break;
            if (inv[a2] != null && inv[a2].func_77973_b() instanceof IRechargable) {
                this.addItemToChargedList(inv[a2], count, time, player);
            } else {
                chargedItems.remove(count);
            }
            ++count;
            ++a2;
        }
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (a = 0; a < baubles.getSlots(); ++a) {
            if (baubles.getStackInSlot(a) != null && baubles.getStackInSlot(a).func_77973_b() instanceof IRechargable) {
                this.addItemToChargedList(baubles.getStackInSlot(a), count, time, player);
            } else {
                chargedItems.remove(count);
            }
            ++count;
        }
        inv = player.field_71071_by.field_70460_b;
        for (a = 0; a < inv.length; ++a) {
            if (inv[a] != null && inv[a].func_77973_b() instanceof IRechargable) {
                this.addItemToChargedList(inv[a], count, time, player);
            } else {
                chargedItems.remove(count);
            }
            ++count;
        }
    }

    private void addItemToChargedList(ItemStack item, int count, long time, EntityPlayer player) {
        ChargeEntry ce;
        IRechargable.EnumChargeDisplay ecd = ((IRechargable)item.func_77973_b()).showInHud(item, (EntityLivingBase)player);
        if (ecd == IRechargable.EnumChargeDisplay.NEVER) {
            return;
        }
        float nc = RechargeHelper.getChargePercentage(item, player);
        if (nc < 0.0f) {
            chargedItems.remove(count);
            return;
        }
        if (ecd == IRechargable.EnumChargeDisplay.PERIODIC) {
            int q = ((IRechargable)item.func_77973_b()).getMaxCharge(item, (EntityLivingBase)player) / 4;
            int c = RechargeHelper.getCharge(item);
            if (c != 0 && c % q != 0) {
                return;
            }
        }
        if ((ce = chargedItems.get(count)) != null && ce.item.func_77973_b() == item.func_77973_b() && ce.charge != nc) {
            ce.diff = nc > ce.charge ? (byte)1 : (byte)-1;
            ce.tickTime = time;
            ce.charge = nc;
            ce.time = ce.time < time - 9500L ? time : time - 500L;
        } else if (ce == null) {
            chargedItems.put(count, new ChargeEntry(time, item, nc));
        } else {
            ce.diff = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientWorldTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.SERVER) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        WorldClient world = mc.field_71441_e;
        if (event.phase == TickEvent.Phase.START) {
            ++this.tickCount;
            for (String fxk : ((ConcurrentHashMap.CollectionView)((Object)EssentiaHandler.sourceFX.keySet())).toArray(new String[0])) {
                EssentiaHandler.EssentiaSourceFX fx = EssentiaHandler.sourceFX.get(fxk);
                if (world == null) continue;
                int mod = 0;
                TileEntity tile = world.func_175625_s(fx.start);
                if (tile != null && tile instanceof TileInfusionMatrix) {
                    mod = -1;
                }
                FXDispatcher.INSTANCE.essentiaTrailFx(fx.end, fx.start.func_177981_b(mod), this.tickCount, fx.color, 0.1f, fx.ext);
                EssentiaHandler.sourceFX.remove(fxk);
            }
        } else {
            LinkedBlockingQueue<HudHandler.KnowledgeGainTracker> temp = new LinkedBlockingQueue<HudHandler.KnowledgeGainTracker>();
            if (this.hudHandler.knowledgeGainTrackers.isEmpty()) {
                if (this.hudHandler.kgFade > 0.0f) {
                    this.hudHandler.kgFade -= 1.0f;
                }
            } else {
                this.hudHandler.kgFade += 10.0f;
                if (this.hudHandler.kgFade > 40.0f) {
                    this.hudHandler.kgFade = 40.0f;
                }
                while (!this.hudHandler.knowledgeGainTrackers.isEmpty()) {
                    HudHandler.KnowledgeGainTracker current = this.hudHandler.knowledgeGainTrackers.poll();
                    if (current == null || current.progress <= 0) continue;
                    --current.progress;
                    temp.offer(current);
                }
                while (!temp.isEmpty()) {
                    this.hudHandler.knowledgeGainTrackers.offer((HudHandler.KnowledgeGainTracker)temp.poll());
                }
            }
            if (mc.field_71441_e != null && !this.checkedDate) {
                this.checkedDate = true;
                Calendar calendar = mc.field_71441_e.func_83015_S();
                if (calendar.get(2) + 1 == 10 && calendar.get(5) == 31) {
                    Config.isHalloween = true;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            UtilsFX.sysPartialTicks = event.renderTickTime;
        } else {
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
                long time = System.currentTimeMillis();
                if (researchPopup == null) {
                    researchPopup = new GuiResearchPopup(mc);
                }
                researchPopup.updateResearchWindow();
                if (player != null) {
                    this.hudHandler.renderHuds(mc, event.renderTickTime, player, time);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void tooltipEvent(ItemTooltipEvent event) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        GuiScreen gui = mc.field_71462_r;
        if (gui instanceof GuiContainer) {
            if (gui.func_146272_n() != Config.showTags && !Mouse.isGrabbed()) {
                int width;
                AspectList tags = ThaumcraftCraftingManager.getObjectTags(event.getItemStack());
                int index = 0;
                if (tags.size() > 0) {
                    for (Aspect tag : tags.getAspects()) {
                        if (tag == null) continue;
                        ++index;
                    }
                }
                if ((width = index * 18) > 0) {
                    double sw = mc.field_71466_p.func_78256_a(" ");
                    int t = MathHelper.func_76143_f((double)((double)width / sw));
                    int l = MathHelper.func_76143_f((double)(18.0 / (double)mc.field_71466_p.field_78288_b));
                    String is = "\u00ef\u00bf\u00bdl                                                                                                                 ";
                    StringBuilder sb = new StringBuilder(is);
                    sb.setLength(t);
                    sb.append(TextFormatting.RESET);
                    for (int a = 0; a < l; ++a) {
                        event.getToolTip().add(sb.toString());
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void tooltipEvent(RenderTooltipEvent.PostText event) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        GuiScreen gui = mc.field_71462_r;
        if (gui instanceof GuiContainer) {
            if (gui.func_146272_n() != Config.showTags && !Mouse.isGrabbed()) {
                int bot = event.getHeight();
                if (event.getLines().size() > 0) {
                    for (int a = event.getLines().size() - 1; a >= 0; --a) {
                        if (!(event.getLines().get(a) == null || ((String)event.getLines().get(a)).startsWith("\u00ef\u00bf\u00bd7\u00ef\u00bf\u00bdl  ") && ((String)event.getLines().get(a)).endsWith("\u00ef\u00bf\u00bdr"))) {
                            bot -= 10;
                            continue;
                        }
                        if (a > 0 && event.getLines().get(a - 1) != null && ((String)event.getLines().get(a - 1)).startsWith("\u00ef\u00bf\u00bd7\u00ef\u00bf\u00bdl  ") && ((String)event.getLines().get(a)).endsWith("\u00ef\u00bf\u00bdr")) break;
                    }
                }
                this.hudHandler.renderAspectsInGui((GuiContainer)gui, (EntityPlayer)mc.field_71439_g, event.getStack(), bot, event.getX(), event.getY());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        long time = System.nanoTime() / 1000000L;
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            this.wandHandler.handleFociRadial(mc, time, event);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.PORTAL) {
            this.renderVignette(targetBrightness, event.getResolution().func_78327_c(), event.getResolution().func_78324_d());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderShaders(RenderGameOverlayEvent.Pre event) {
        if (Config.shaders && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft mc = Minecraft.func_71410_x();
            if (OpenGlHelper.field_148824_g) {
                if (shaderGroups.size() > 0) {
                    this.updateShaderFrameBuffers(mc);
                    GL11.glMatrixMode((int)5890);
                    GL11.glLoadIdentity();
                    for (ShaderGroup sg : shaderGroups.values()) {
                        GL11.glPushMatrix();
                        try {
                            sg.func_148018_a(event.getPartialTicks());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        GL11.glPopMatrix();
                    }
                    mc.func_147110_a().func_147610_a(true);
                }
            }
        }
    }

    private void updateShaderFrameBuffers(Minecraft mc) {
        if (resetShaders || mc.field_71443_c != oldDisplayWidth || oldDisplayHeight != mc.field_71440_d) {
            for (ShaderGroup sg : shaderGroups.values()) {
                sg.func_148026_a(mc.field_71443_c, mc.field_71440_d);
            }
            oldDisplayWidth = mc.field_71443_c;
            oldDisplayHeight = mc.field_71440_d;
            resetShaders = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void blockHighlight(DrawBlockHighlightEvent event) {
        int ticks = event.getPlayer().field_70173_aa;
        RayTraceResult target = event.getTarget();
        if (blockTags.size() > 0) {
            int x = (Integer)blockTags.get(0);
            int y = (Integer)blockTags.get(1);
            int z = (Integer)blockTags.get(2);
            AspectList ot = (AspectList)blockTags.get(3);
            EnumFacing dir = EnumFacing.field_82609_l[(Integer)blockTags.get(4)];
            if (x == target.func_178782_a().func_177958_n() && y == target.func_178782_a().func_177956_o() && z == target.func_178782_a().func_177952_p()) {
                if (tagscale < 0.5f) {
                    tagscale += 0.031f - tagscale / 10.0f;
                }
                RenderEventHandler.drawTagsOnContainer((float)target.func_178782_a().func_177958_n() + (float)dir.func_82601_c() / 2.0f, (float)target.func_178782_a().func_177956_o() + (float)dir.func_96559_d() / 2.0f, (float)target.func_178782_a().func_177952_p() + (float)dir.func_82599_e() / 2.0f, ot, 220, dir, event.getPartialTicks());
            }
        }
        if (target != null && target.func_178782_a() != null) {
            RayTraceResult hit;
            TileEntity te = event.getPlayer().field_70170_p.func_175625_s(target.func_178782_a());
            if (te != null && te instanceof TileRedstoneRelay && (hit = RayTracer.retraceBlock(event.getPlayer().field_70170_p, event.getPlayer(), target.func_178782_a())) != null) {
                if (hit.subHit == 0) {
                    this.drawTextInAir(target.func_178782_a().func_177958_n(), (double)target.func_178782_a().func_177956_o() + 0.3, target.func_178782_a().func_177952_p(), event.getPartialTicks(), "Out: " + ((TileRedstoneRelay)te).getOut());
                } else if (hit.subHit == 1) {
                    this.drawTextInAir(target.func_178782_a().func_177958_n(), (double)target.func_178782_a().func_177956_o() + 0.3, target.func_178782_a().func_177952_p(), event.getPartialTicks(), "In: " + ((TileRedstoneRelay)te).getIn());
                }
            }
            if (EntityUtils.hasGoggles((Entity)event.getPlayer())) {
                boolean spaceAbove = event.getPlayer().field_70170_p.func_175623_d(target.func_178782_a().func_177984_a());
                if (te != null) {
                    int note = -1;
                    if (te instanceof TileEntityNote) {
                        note = ((TileEntityNote)te).field_145879_a;
                    } else if (te instanceof TileArcaneEar) {
                        note = ((TileArcaneEar)te).note;
                    } else if (te instanceof IAspectContainer && ((IAspectContainer)te).getAspects() != null && ((IAspectContainer)te).getAspects().size() > 0) {
                        float shift = 0.0f;
                        if (tagscale < 0.3f) {
                            tagscale += 0.031f - tagscale / 10.0f;
                        }
                        RenderEventHandler.drawTagsOnContainer(target.func_178782_a().func_177958_n(), (float)target.func_178782_a().func_177956_o() + (spaceAbove ? 0.4f : 0.0f) + shift, target.func_178782_a().func_177952_p(), ((IAspectContainer)te).getAspects(), 220, spaceAbove ? EnumFacing.UP : event.getTarget().field_178784_b, event.getPartialTicks());
                    }
                    if (note >= 0) {
                        if (ticks % 5 == 0) {
                            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNote(target.func_178782_a().func_177958_n(), target.func_178782_a().func_177956_o(), target.func_178782_a().func_177952_p(), event.getPlayer().field_70170_p.field_73011_w.getDimension()));
                        }
                        this.drawTextInAir(target.func_178782_a().func_177958_n(), target.func_178782_a().func_177956_o() + 1, target.func_178782_a().func_177952_p(), event.getPartialTicks(), "Note: " + note);
                    }
                }
            }
        }
        if (target.field_72313_a == RayTraceResult.Type.BLOCK && event.getPlayer().func_184614_ca() != null && (event.getPlayer().func_184614_ca().func_77973_b() instanceof IArchitect || event.getPlayer().func_184614_ca().func_77973_b() instanceof IArchitectExtended)) {
            boolean proceed = true;
            RayTraceResult target2 = null;
            if (event.getPlayer().func_184614_ca().func_77973_b() instanceof IArchitectExtended) {
                proceed = ((IArchitectExtended)event.getPlayer().func_184614_ca().func_77973_b()).useBlockHighlight(event.getPlayer().func_184614_ca());
                target2 = ((IArchitectExtended)event.getPlayer().func_184614_ca().func_77973_b()).getArchitectMOP(event.getPlayer().func_184614_ca(), event.getPlayer().field_70170_p, (EntityLivingBase)event.getPlayer());
            }
            if (proceed && this.wandHandler.handleArchitectOverlay(event.getPlayer().func_184614_ca(), event.getPlayer(), event.getPartialTicks(), ticks, target2 == null ? target : target2)) {
                event.setCanceled(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderLast(RenderWorldLastEvent event) {
        EntityPlayer player;
        if (tagscale > 0.0f) {
            tagscale -= 0.005f;
        }
        float partialTicks = event.getPartialTicks();
        Minecraft mc = Minecraft.func_71410_x();
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer && (player = (EntityPlayer)mc.func_175606_aa()).func_184614_ca() != null) {
            if (player.func_184614_ca().func_77973_b() instanceof ISealDisplayer) {
                this.drawSeals(partialTicks, player);
            }
            if (player.func_184614_ca().func_77973_b() instanceof IArchitectExtended) {
                RayTraceResult target = ((IArchitectExtended)player.func_184614_ca().func_77973_b()).getArchitectMOP(player.func_184614_ca(), player.field_70170_p, (EntityLivingBase)player);
                this.wandHandler.handleArchitectOverlay(player.func_184614_ca(), player, partialTicks, player.field_70173_aa, target);
            }
        }
    }

    private void drawSeals(float partialTicks, EntityPlayer player) {
        ConcurrentHashMap<SealPos, SealEntity> seals = SealHandler.sealEntities.get(player.field_70170_p.field_73011_w.getDimension());
        if (seals != null && seals.size() > 0) {
            GL11.glPushMatrix();
            if (player.func_70093_af()) {
                GL11.glDisable((int)2929);
            }
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2884);
            double iPX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double iPY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
            double iPZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            GL11.glTranslated((double)(-iPX), (double)(-iPY), (double)(-iPZ));
            for (ISealEntity iSealEntity : seals.values()) {
                double dis = player.func_174831_c(iSealEntity.getSealPos().pos);
                if (!(dis <= 256.0)) continue;
                float alpha = 1.0f - (float)(dis / 256.0);
                boolean ia = false;
                if (iSealEntity.isStoppedByRedstone(player.field_70170_p)) {
                    ia = true;
                    if (player.field_70170_p.field_73012_v.nextFloat() < partialTicks / 12.0f) {
                        FXDispatcher.INSTANCE.spark((float)iSealEntity.getSealPos().pos.func_177958_n() + 0.5f + (float)iSealEntity.getSealPos().face.func_82601_c() * 0.66f, (float)iSealEntity.getSealPos().pos.func_177956_o() + 0.5f + (float)iSealEntity.getSealPos().face.func_96559_d() * 0.66f, (float)iSealEntity.getSealPos().pos.func_177952_p() + 0.5f + (float)iSealEntity.getSealPos().face.func_82599_e() * 0.66f, 2.0f, 0.8f - player.field_70170_p.field_73012_v.nextFloat() * 0.2f, 0.0f, 0.0f, 1.0f);
                        ia = false;
                    }
                }
                this.renderSeal(iSealEntity.getSealPos().pos.func_177958_n(), iSealEntity.getSealPos().pos.func_177956_o(), iSealEntity.getSealPos().pos.func_177952_p(), alpha, iSealEntity.getSealPos().face, iSealEntity.getSeal().getSealIcon(), ia);
                this.drawSealArea(player, iSealEntity, alpha, partialTicks);
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2884);
            if (player.func_70093_af()) {
                GL11.glEnable((int)2929);
            }
            GL11.glPopMatrix();
        }
    }

    private void drawSealArea(EntityPlayer player, ISealEntity seal, float alpha, float partialTicks) {
        GL11.glPushMatrix();
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (seal.getColor() > 0) {
            Color c = new Color(EnumDyeColor.func_176764_b((int)(seal.getColor() - 1)).func_176768_e().field_76291_p);
            r = (float)c.getRed() / 255.0f;
            g = (float)c.getGreen() / 255.0f;
            b = (float)c.getBlue() / 255.0f;
        } else {
            r = 0.7f + MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks + (float)seal.getSealPos().pos.func_177958_n()) / 4.0f)) * 0.1f;
            g = 0.7f + MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks + (float)seal.getSealPos().pos.func_177956_o()) / 5.0f)) * 0.1f;
            b = 0.7f + MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks + (float)seal.getSealPos().pos.func_177952_p()) / 6.0f)) * 0.1f;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)seal.getSealPos().pos.func_177958_n() + 0.5), (double)((double)seal.getSealPos().pos.func_177956_o() + 0.5), (double)((double)seal.getSealPos().pos.func_177952_p() + 0.5));
        GL11.glRotatef((float)90.0f, (float)(-seal.getSealPos().face.func_96559_d()), (float)seal.getSealPos().face.func_82601_c(), (float)(-seal.getSealPos().face.func_82599_e()));
        if (seal.getSealPos().face.func_82599_e() < 0) {
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.51f);
        } else {
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.51f);
        }
        GL11.glRotatef((float)((float)(player.field_70173_aa % 360) + partialTicks), (float)0.0f, (float)0.0f, (float)1.0f);
        UtilsFX.renderQuadCentered(this.MIDDLE, 0.9f, r, g, b, 200, 771, alpha * 0.8f);
        GL11.glPopMatrix();
        if (seal.getSeal() instanceof ISealConfigArea) {
            GL11.glDepthMask((boolean)false);
            AxisAlignedBB area = new AxisAlignedBB((double)seal.getSealPos().pos.func_177958_n(), (double)seal.getSealPos().pos.func_177956_o(), (double)seal.getSealPos().pos.func_177952_p(), (double)(seal.getSealPos().pos.func_177958_n() + 1), (double)(seal.getSealPos().pos.func_177956_o() + 1), (double)(seal.getSealPos().pos.func_177952_p() + 1)).func_72317_d((double)seal.getSealPos().face.func_82601_c(), (double)seal.getSealPos().face.func_96559_d(), (double)seal.getSealPos().face.func_82599_e()).func_72321_a(seal.getSealPos().face.func_82601_c() != 0 ? (double)((seal.getArea().func_177958_n() - 1) * seal.getSealPos().face.func_82601_c()) : 0.0, seal.getSealPos().face.func_96559_d() != 0 ? (double)((seal.getArea().func_177956_o() - 1) * seal.getSealPos().face.func_96559_d()) : 0.0, seal.getSealPos().face.func_82599_e() != 0 ? (double)((seal.getArea().func_177952_p() - 1) * seal.getSealPos().face.func_82599_e()) : 0.0).func_72314_b(seal.getSealPos().face.func_82601_c() == 0 ? (double)(seal.getArea().func_177958_n() - 1) : 0.0, seal.getSealPos().face.func_96559_d() == 0 ? (double)(seal.getArea().func_177956_o() - 1) : 0.0, seal.getSealPos().face.func_82599_e() == 0 ? (double)(seal.getArea().func_177952_p() - 1) : 0.0);
            double[][] locs = new double[][]{{area.field_72340_a, area.field_72338_b, area.field_72339_c}, {area.field_72340_a, area.field_72337_e - 1.0, area.field_72339_c}, {area.field_72336_d - 1.0, area.field_72338_b, area.field_72339_c}, {area.field_72336_d - 1.0, area.field_72337_e - 1.0, area.field_72339_c}, {area.field_72336_d - 1.0, area.field_72338_b, area.field_72334_f - 1.0}, {area.field_72336_d - 1.0, area.field_72337_e - 1.0, area.field_72334_f - 1.0}, {area.field_72340_a, area.field_72338_b, area.field_72334_f - 1.0}, {area.field_72340_a, area.field_72337_e - 1.0, area.field_72334_f - 1.0}};
            int q = 0;
            for (double[] loc : locs) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(loc[0] + 0.5), (double)(loc[1] + 0.5), (double)(loc[2] + 0.5));
                int w = 0;
                for (EnumFacing face : this.rotfaces[q]) {
                    GL11.glPushMatrix();
                    GL11.glRotatef((float)90.0f, (float)(-face.func_96559_d()), (float)face.func_82601_c(), (float)(-face.func_82599_e()));
                    if (face.func_82599_e() < 0) {
                        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.49f);
                    } else {
                        GL11.glTranslated((double)0.0, (double)0.0, (double)0.49f);
                    }
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                    GL11.glRotatef((float)this.rotmat[q][w], (float)0.0f, (float)0.0f, (float)1.0f);
                    UtilsFX.renderQuadCentered(this.CFRAME, 1.0f, r, g, b, 200, 771, alpha * 0.7f);
                    GL11.glPopMatrix();
                    ++w;
                }
                GL11.glPopMatrix();
                ++q;
            }
            GL11.glDepthMask((boolean)true);
        }
        GL11.glPopMatrix();
    }

    void renderSeal(int x, int y, int z, float alpha, EnumFacing face, ResourceLocation resourceLocation, boolean ia) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)(ia ? 0.5f : 1.0f), (float)(ia ? 0.5f : 1.0f), (float)(ia ? 0.5f : 1.0f), (float)alpha);
        this.translateSeal(x, y, z, face.ordinal(), -0.05f);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        UtilsFX.renderItemIn2D(resourceLocation.toString(), Minecraft.func_71410_x().func_175606_aa().func_70093_af() ? 0.0f : 0.1f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void translateSeal(float x, float y, float z, int orientation, float off) {
        if (orientation == 1) {
            GL11.glTranslatef((float)(x + 0.25f), (float)(y + 1.0f), (float)(z + 0.75f));
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == 0) {
            GL11.glTranslatef((float)(x + 0.25f), (float)y, (float)(z + 0.25f));
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (orientation == 3) {
            GL11.glTranslatef((float)(x + 0.25f), (float)(y + 0.25f), (float)(z + 1.0f));
        } else if (orientation == 2) {
            GL11.glTranslatef((float)(x + 0.75f), (float)(y + 0.25f), (float)z);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (orientation == 5) {
            GL11.glTranslatef((float)(x + 1.0f), (float)(y + 0.25f), (float)(z + 0.75f));
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (orientation == 4) {
            GL11.glTranslatef((float)x, (float)(y + 0.25f), (float)(z + 0.25f));
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-off));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void fogDensityEvent(EntityViewRenderEvent.RenderFogEvent event) {
        if (fogFiddled && fogTarget > 0.0f) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)fogTarget);
        }
    }

    @SubscribeEvent
    public void livingTick(LivingEvent.LivingUpdateEvent event) {
        Integer t;
        EntityCreature mob;
        if (event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityCreature && !event.getEntity().field_70128_L && (mob = (EntityCreature)event.getEntity()).func_110148_a(ThaumcraftApiHelper.CHAMPION_MOD) != null && (t = Integer.valueOf((int)mob.func_110148_a(ThaumcraftApiHelper.CHAMPION_MOD).func_111126_e())) != null && t >= 0 && t < ChampionModifier.mods.length) {
            ChampionModifier.mods[t.intValue()].effect.showFX((EntityLivingBase)mob);
        }
    }

    @SubscribeEvent
    public void renderLivingPre(RenderLivingEvent.Pre event) {
        Integer t;
        EntityCreature mob;
        if (event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityCreature && !event.getEntity().field_70128_L && (mob = (EntityCreature)event.getEntity()).func_110148_a(ThaumcraftApiHelper.CHAMPION_MOD) != null && (t = Integer.valueOf((int)mob.func_110148_a(ThaumcraftApiHelper.CHAMPION_MOD).func_111126_e())) != null && t >= 0 && t < ChampionModifier.mods.length) {
            ChampionModifier.mods[t.intValue()].effect.preRender((EntityLivingBase)mob, event.getRenderer());
        }
    }

    public static void drawTagsOnContainer(double x, double y, double z, AspectList tags, int bright, EnumFacing dir, float partialTicks) {
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer && tags != null && tags.size() > 0 && dir != null) {
            EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
            double iPX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double iPY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
            double iPZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            int rowsize = 5;
            int current = 0;
            float shifty = 0.0f;
            int left = tags.size();
            for (Aspect tag : tags.getAspects()) {
                int div = Math.min(left, rowsize);
                if (current >= rowsize) {
                    current = 0;
                    shifty -= tagscale * 1.05f;
                    if ((left -= rowsize) < rowsize) {
                        div = left % rowsize;
                    }
                }
                float shift = ((float)current - (float)div / 2.0f + 0.5f) * tagscale * 4.0f;
                shift *= tagscale;
                Color color = new Color(tag.getColor());
                GL11.glPushMatrix();
                GL11.glDisable((int)2929);
                GL11.glTranslated((double)(-iPX + x + 0.5 + (double)(tagscale * 2.0f * (float)dir.func_82601_c())), (double)(-iPY + y - (double)shifty + 0.5 + (double)(tagscale * 2.0f * (float)dir.func_96559_d())), (double)(-iPZ + z + 0.5 + (double)(tagscale * 2.0f * (float)dir.func_82599_e())));
                float xd = (float)(iPX - (x + 0.5));
                float zd = (float)(iPZ - (z + 0.5));
                float rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
                GL11.glRotatef((float)(rotYaw + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)shift, (double)0.0, (double)0.0);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glScalef((float)tagscale, (float)tagscale, (float)tagscale);
                UtilsFX.renderQuadCentered(tag.getImage(), 1.0f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, bright, 771, 0.75f);
                if (tags.getAmount(tag) >= 0) {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    String am = "" + tags.getAmount(tag);
                    GL11.glScalef((float)0.04f, (float)0.04f, (float)0.04f);
                    GL11.glTranslated((double)0.0, (double)6.0, (double)-0.1);
                    int sw = Minecraft.func_71410_x().field_71466_p.func_78256_a(am);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(am, 14 - sw, 1, 0x111111);
                    GL11.glTranslated((double)0.0, (double)0.0, (double)-0.1);
                    Minecraft.func_71410_x().field_71466_p.func_78276_b(am, 13 - sw, 0, 0xFFFFFF);
                }
                GL11.glEnable((int)2929);
                GL11.glPopMatrix();
                ++current;
            }
        }
    }

    public void drawTextInAir(double x, double y, double z, float partialTicks, String text) {
        if (Minecraft.func_71410_x().func_175606_aa() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
            double iPX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double iPY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
            double iPZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-iPX + x + 0.5), (double)(-iPY + y + 0.5), (double)(-iPZ + z + 0.5));
            float xd = (float)(iPX - (x + 0.5));
            float zd = (float)(iPZ - (z + 0.5));
            float rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
            GL11.glRotatef((float)(rotYaw + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)0.02f, (float)0.02f, (float)0.02f);
            int sw = Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(text, 1 - sw / 2, 1, 0x111111);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.1);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(text, -sw / 2, 0, 0xFFFFFF);
            GL11.glPopMatrix();
        }
    }

    protected void renderVignette(float brightness, double sw, double sh) {
        int k = (int)sw;
        int l = (int)sh;
        brightness = 1.0f - brightness;
        if ((prevVignetteBrightness = (float)((double)prevVignetteBrightness + (double)(brightness - prevVignetteBrightness) * 0.01)) > 0.0f) {
            float b = prevVignetteBrightness * (1.0f + MathHelper.func_76126_a((float)((float)Minecraft.func_71410_x().field_71439_g.field_70173_aa / 2.0f)) * 0.1f);
            GL11.glPushMatrix();
            GL11.glClear((int)256);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)sw, (double)sh, (double)0.0, (double)1000.0, (double)3000.0);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(vignetteTexPath);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            OpenGlHelper.func_148821_a((int)0, (int)769, (int)1, (int)0);
            GL11.glColor4f((float)b, (float)b, (float)b, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
            tessellator.func_178180_c().func_181662_b(0.0, (double)l, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b((double)k, (double)l, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b((double)k, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b(0.0, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glPopMatrix();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void textureStitchEventPre(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(new ResourceLocation("thaumcraft", "research/quill"));
        event.getMap().func_174942_a(new ResourceLocation("thaumcraft", "blocks/crystal"));
        event.getMap().func_174942_a(new ResourceLocation("thaumcraft", "blocks/taint_growth_1"));
        event.getMap().func_174942_a(new ResourceLocation("thaumcraft", "blocks/taint_growth_2"));
        event.getMap().func_174942_a(new ResourceLocation("thaumcraft", "blocks/taint_growth_3"));
        event.getMap().func_174942_a(new ResourceLocation("thaumcraft", "blocks/taint_growth_4"));
    }

    public class ChargeEntry {
        public long time;
        public long tickTime;
        public ItemStack item;
        float charge = 0.0f;
        byte diff = 0;

        public ChargeEntry(long time, ItemStack item, float charge) {
            this.time = time;
            this.item = item;
            this.charge = charge;
        }
    }
}

