/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.api.research.theorycraft.ITheorycraftAid;
import thaumcraft.api.research.theorycraft.ResearchTableData;
import thaumcraft.api.research.theorycraft.TheorycraftManager;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.client.gui.plugins.GuiImageButton;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.container.ContainerResearchTable;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketStartTheoryToServer;
import thaumcraft.common.tiles.crafting.TileResearchTable;

@SideOnly(value=Side.CLIENT)
public class GuiResearchTable
extends GuiContainer {
    private float xSize_lo;
    private float ySize_lo;
    private TileResearchTable table;
    private FontRenderer galFontRenderer;
    private String username;
    EntityPlayer player;
    ResourceLocation txBackground = new ResourceLocation("thaumcraft", "textures/gui/gui_research_table.png");
    ResourceLocation txBase = new ResourceLocation("thaumcraft", "textures/gui/gui_base.png");
    ResourceLocation txPaper = new ResourceLocation("thaumcraft", "textures/gui/paper.png");
    ResourceLocation txPaperGilded = new ResourceLocation("thaumcraft", "textures/gui/papergilded.png");
    ResourceLocation txQuestion = new ResourceLocation("thaumcraft", "textures/aspects/_unknown.png");
    ResearchTableData.CardChoice lastDraw;
    float[] cardHover = new float[]{0.0f, 0.0f, 0.0f};
    float[] cardZoomOut = new float[]{0.0f, 0.0f, 0.0f};
    float[] cardZoomIn = new float[]{0.0f, 0.0f, 0.0f};
    boolean[] cardActive = new boolean[]{true, true, true};
    boolean cardSelected = false;
    public HashMap<String, Integer> tempCatTotals = new HashMap();
    long nexCatCheck = 0L;
    long nextCheck = 0L;
    int dummyInspirationStart = 0;
    Set<String> currentAids = new HashSet<String>();
    Set<String> selectedAids = new HashSet<String>();
    GuiImageButton buttonCreate = new GuiImageButton((GuiScreen)this, 1, this.field_147003_i + 128, this.field_147009_r + 22, 49, 11, "button.create.theory", null, this.txBase, 37, 66, 51, 13, 0x88FFAA);
    GuiImageButton buttonComplete = new GuiImageButton((GuiScreen)this, 7, this.field_147003_i + 191, this.field_147009_r + 96, 49, 11, "button.complete.theory", null, this.txBase, 37, 66, 51, 13, 0x88FFAA);
    GuiImageButton buttonScrap = new GuiImageButton((GuiScreen)this, 9, this.field_147003_i + 128, this.field_147009_r + 168, 49, 11, "button.scrap.theory", null, this.txBase, 37, 66, 51, 13, 0xFF2222);
    public ArrayList<ResearchTableData.CardChoice> cardChoices = new ArrayList();

    public GuiResearchTable(EntityPlayer player, TileResearchTable e) {
        super((Container)new ContainerResearchTable(player.field_71071_by, e));
        this.table = e;
        this.field_146999_f = 255;
        this.field_147000_g = 255;
        this.galFontRenderer = FMLClientHandler.instance().getClient().field_71464_q;
        this.username = player.func_70005_c_();
        this.player = player;
        if (this.table.data != null) {
            for (String cat : this.table.data.categoryTotals.keySet()) {
                this.tempCatTotals.put(cat, this.table.data.categoryTotals.get(cat));
            }
            this.syncFromTableChoices();
            this.lastDraw = this.table.data.lastDraw;
        }
    }

    private void syncFromTableChoices() {
        this.cardChoices.clear();
        for (ResearchTableData.CardChoice cc : this.table.data.cardChoices) {
            this.cardChoices.add(cc);
        }
    }

    protected void func_146979_b(int mx, int my) {
    }

    public void func_73863_a(int mx, int my, float par3) {
        super.func_73863_a(mx, my, par3);
        this.xSize_lo = mx;
        this.ySize_lo = my;
        int xx = this.field_147003_i;
        int yy = this.field_147009_r;
        RenderHelper.func_74518_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.table.data == null) {
            if (!this.currentAids.isEmpty()) {
                int side = Math.min(this.currentAids.size(), 6);
                int c = 0;
                int r = 0;
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                this.field_146297_k.field_71446_o.func_110577_a(this.txBase);
                for (String key : this.currentAids) {
                    ITheorycraftAid mutator = TheorycraftManager.aids.get(key);
                    if (mutator == null) continue;
                    int x = xx + 128 + 20 * c - side * 10;
                    int y = yy + 85 + 35 * r;
                    if (this.func_146978_c(x - xx, y - yy, 16, 16, mx, my) && !this.selectedAids.contains(key)) {
                        this.func_73729_b(x, y, 0, 96, 16, 16);
                    }
                    if (++c < side) continue;
                    ++r;
                    c = 0;
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        } else {
            int sx = 128;
            int cw = 110;
            int sz = this.cardChoices.size();
            int a = 0;
            if (!this.cardSelected) {
                for (ResearchTableData.CardChoice cardChoice : this.cardChoices) {
                    if (!(this.cardZoomOut[a] >= 1.0f)) continue;
                    float dx = 55 + sx - 55 * sz + cw * a - 65;
                    float fx = 65.0f + dx * this.cardZoomOut[a];
                    float qx = 191.0f - fx;
                    if (this.cardActive[a]) {
                        fx += qx * this.cardZoomIn[a];
                    }
                    this.drawSheetOverlay(fx, 100.0, cardChoice, mx, my);
                    ++a;
                }
            }
            int qq = 0;
            if (this.table.func_70301_a(0) == null || this.table.func_70301_a(0).func_77952_i() == this.table.func_70301_a(0).func_77958_k()) {
                sx = Math.max(this.field_146289_q.func_78256_a(I18n.func_74838_a((String)"tile.researchtable.noink.0")), this.field_146289_q.func_78256_a(I18n.func_74838_a((String)"tile.researchtable.noink.1"))) / 2;
                UtilsFX.drawCustomTooltip((GuiScreen)this, this.field_146289_q, Arrays.asList(I18n.func_74838_a((String)"tile.researchtable.noink.0"), I18n.func_74838_a((String)"tile.researchtable.noink.1")), xx - sx + 116, yy + 60 + qq, 11, true);
                qq += 40;
            }
            if (this.table.func_70301_a(1) == null) {
                sx = this.field_146289_q.func_78256_a(I18n.func_74838_a((String)"tile.researchtable.nopaper.0")) / 2;
                UtilsFX.drawCustomTooltip((GuiScreen)this, this.field_146289_q, Arrays.asList(I18n.func_74838_a((String)"tile.researchtable.nopaper.0")), xx - sx + 116, yy + 60 + qq, 11, true);
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mx, int my) {
        this.checkButtons();
        int xx = this.field_147003_i;
        int yy = this.field_147009_r;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.field_146297_k.field_71446_o.func_110577_a(this.txBackground);
        this.func_73729_b(xx, yy, 0, 0, 255, 255);
        this.field_146289_q.func_78276_b(" ", 0, 0, 0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.table.data == null) {
            if (this.nextCheck < (long)this.player.field_70173_aa) {
                this.currentAids = this.table.checkSurroundingAids();
                this.dummyInspirationStart = ResearchTableData.getAvailableInspiration(this.player);
                this.nextCheck = this.player.field_70173_aa + 100;
            }
            this.field_146297_k.field_71446_o.func_110577_a(this.txBase);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(xx + 128 - this.dummyInspirationStart * 5), (double)(yy + 55), (double)0.0);
            GL11.glScaled((double)0.5, (double)0.5, (double)0.0);
            for (int a = 0; a < this.dummyInspirationStart; ++a) {
                this.func_73729_b(20 * a, 0, this.dummyInspirationStart - this.selectedAids.size() <= a ? 48 : 32, 96, 16, 16);
            }
            GL11.glPopMatrix();
            if (!this.currentAids.isEmpty()) {
                int side = Math.min(this.currentAids.size(), 6);
                int c = 0;
                int r = 0;
                for (String key : this.currentAids) {
                    ITheorycraftAid mutator = TheorycraftManager.aids.get(key);
                    if (mutator == null) continue;
                    int x = xx + 128 + 20 * c - side * 10;
                    int y = yy + 85 + 35 * r;
                    if (this.selectedAids.contains(key)) {
                        this.field_146297_k.field_71446_o.func_110577_a(this.txBase);
                        this.func_73729_b(x, y, 0, 96, 16, 16);
                    }
                    GL11.glPushMatrix();
                    RenderHelper.func_74520_c();
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179091_B();
                    GlStateManager.func_179142_g();
                    GlStateManager.func_179145_e();
                    ItemStack s = mutator.getAidObject() instanceof ItemStack ? (ItemStack)mutator.getAidObject() : new ItemStack((Block)mutator.getAidObject());
                    this.field_146296_j.func_180450_b(s, x, y);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179126_j();
                    GL11.glPopMatrix();
                    if (++c < side) continue;
                    ++r;
                    c = 0;
                }
            }
        } else {
            int a;
            this.checkCards();
            this.field_146297_k.field_71446_o.func_110577_a(this.txBase);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(xx + 15), (double)(yy + 150), (double)0.0);
            if (this.table.data != null) {
                for (a = 0; a < this.table.data.bonusDraws; ++a) {
                    this.func_73729_b(a * 2, a, 64, 96, 16, 16);
                }
            }
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslated((double)(xx + 128 - this.table.data.inspirationStart * 5), (double)(yy + 16), (double)0.0);
            GL11.glScaled((double)0.5, (double)0.5, (double)0.0);
            for (a = 0; a < this.table.data.inspirationStart; ++a) {
                this.func_73729_b(20 * a, 0, this.table.data.inspiration <= a ? 48 : 32, 96, 16, 16);
            }
            GL11.glPopMatrix();
            int sheets = 0;
            if (this.table.func_70301_a(1) != null) {
                sheets = 1 + this.table.func_70301_a((int)1).field_77994_a / 4;
            }
            Random r = new Random(55L);
            if (sheets > 0 && !this.table.data.isComplete()) {
                for (int a2 = 0; a2 < sheets; ++a2) {
                    this.drawSheet(xx + 65, yy + 100, 6.0, r, 1.0f, 1.0f, null);
                }
                boolean highlight = false;
                int var7 = mx - (25 + xx);
                int var8 = my - (55 + yy);
                if (this.cardChoices.isEmpty() && var7 >= 0 && var8 >= 0 && var7 < 75 && var8 < 90) {
                    highlight = true;
                }
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(highlight ? 1.0f : 0.5f));
                GlStateManager.func_179147_l();
                this.field_146297_k.field_71446_o.func_110577_a(this.txQuestion);
                GL11.glTranslated((double)(xx + 65), (double)(yy + 100), (double)0.0);
                GL11.glScaled((double)(highlight ? 1.75 : 1.5), (double)(highlight ? 1.75 : 1.5), (double)0.0);
                UtilsFX.drawTexturedQuadFull(-8.0f, -8.0f, 0.0);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
            for (Long seed : this.table.data.savedCards) {
                r = new Random(seed);
                this.drawSheet(xx + 191, yy + 100, 6.0, r, 1.0f, 1.0f, null);
            }
            if (this.lastDraw != null) {
                r = new Random(this.lastDraw.card.getSeed());
                this.drawSheet(xx + 191, yy + 100, 6.0, r, 1.0f, 1.0f, this.lastDraw);
            }
            ArrayList<String> sparkle = new ArrayList<String>();
            if (this.nexCatCheck < (long)this.player.field_70173_aa) {
                for (String cat : ResearchCategories.researchCategories.keySet()) {
                    int t0 = 0;
                    if (this.table.data.categoryTotals.containsKey(cat)) {
                        t0 = this.table.data.categoryTotals.get(cat);
                    }
                    int t1 = 0;
                    if (this.tempCatTotals.containsKey(cat)) {
                        t1 = this.tempCatTotals.get(cat);
                    }
                    if (t0 == 0 && t1 == 0) {
                        this.tempCatTotals.remove(cat);
                        continue;
                    }
                    if (t1 > t0) {
                        --t1;
                    }
                    if (t1 < t0) {
                        ++t1;
                        sparkle.add(cat);
                    }
                    this.tempCatTotals.put(cat, t1);
                }
                this.nexCatCheck = this.player.field_70173_aa + 1;
            }
            HashMap<String, Integer> unsortedMap = new HashMap<String, Integer>();
            String hf = null;
            int lf = 0;
            for (String cat : this.tempCatTotals.keySet()) {
                int cf = this.tempCatTotals.get(cat);
                if (cf == 0) continue;
                if (cf > lf) {
                    lf = cf;
                    hf = cat;
                }
                unsortedMap.put(cat, cf);
            }
            if (hf != null) {
                unsortedMap.put(hf, (Integer)unsortedMap.get(hf));
            }
            Comparator valueComparator = (e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue());
            Map sortedMap = unsortedMap.entrySet().stream().sorted(valueComparator).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            int i = 0;
            for (String field : sortedMap.keySet()) {
                int q;
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)(xx + 253), (float)(yy + 16 + i * 18 + (i > 0 ? 4 : 0)), (float)0.0f);
                GL11.glScaled((double)0.0625, (double)0.0625, (double)0.0625);
                this.field_146297_k.field_71446_o.func_110577_a(ResearchCategories.getResearchCategory((String)field).icon);
                this.func_73729_b(0, 0, 0, 0, 255, 255);
                GL11.glPopMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)5.0f);
                String s = sortedMap.get(field) + "%";
                if (i == 0) {
                    q = (Integer)sortedMap.get(field) / 4;
                    s = s + " (+" + q + ")";
                }
                this.field_146297_k.field_71466_p.func_175063_a(s, (float)(xx + 276), (float)(yy + 20 + i * 18 + (i > 0 ? 4 : 0)), this.table.data.categoriesBlocked.contains(field) ? 0x606060 : (i == 0 ? 57536 : 0xFFFFFF));
                if (sparkle.contains(field)) {
                    for (q = 0; q < 2; ++q) {
                        float rr = (float)MathHelper.func_76136_a((Random)this.player.func_70681_au(), (int)255, (int)255) / 255.0f;
                        float gg = (float)MathHelper.func_76136_a((Random)this.player.func_70681_au(), (int)189, (int)255) / 255.0f;
                        float bb = (float)MathHelper.func_76136_a((Random)this.player.func_70681_au(), (int)64, (int)255) / 255.0f;
                        FXDispatcher.INSTANCE.drawSimpleSparkleGui(this.player.func_70681_au(), (float)(xx + 276) + this.player.func_70681_au().nextFloat() * (float)this.field_146289_q.func_78256_a(s), (float)(yy + 20) + this.player.func_70681_au().nextFloat() * 8.0f + (float)(i * 18) + (float)(i > 0 ? 4 : 0), this.player.field_70170_p.field_73012_v.nextGaussian() * 0.5, this.player.field_70170_p.field_73012_v.nextGaussian() * 0.5, 24.0f, rr, gg, bb, 0, 0.9f, -1.0f);
                    }
                }
                int var7 = mx - (xx + 256);
                int var8 = my - (yy + 16 + i * 18 + (i > 0 ? 4 : 0));
                if (var7 >= 0 && var8 >= 0 && var7 < 16 && var8 < 16) {
                    GL11.glPushMatrix();
                    UtilsFX.drawCustomTooltip((GuiScreen)this, this.field_146289_q, Arrays.asList(ResearchCategories.getCategoryName(field)), mx + 8, my + 8, 11);
                    GL11.glPopMatrix();
                    RenderHelper.func_74518_a();
                }
                ++i;
            }
            int sx = 128;
            int cw = 110;
            int sz = this.cardChoices.size();
            int a3 = 0;
            for (ResearchTableData.CardChoice cardChoice : this.cardChoices) {
                r = new Random(cardChoice.card.getSeed());
                int var7 = mx - (5 + sx - 55 * sz + xx + cw * a3);
                int var8 = my - (100 + yy - 60);
                if ((double)this.cardZoomOut[a3] >= 0.95 && !this.cardSelected) {
                    if (var7 >= 0 && var8 >= 0 && var7 < 100 && var8 < 120) {
                        int n = a3;
                        this.cardHover[n] = this.cardHover[n] + Math.max((0.25f - this.cardHover[a3]) / 3.0f * partialTicks, 0.0025f);
                    } else {
                        int n = a3;
                        this.cardHover[n] = this.cardHover[n] - 0.1f * partialTicks;
                    }
                }
                if (a3 == sz - 1 || (double)this.cardZoomOut[a3 + 1] > 0.6) {
                    float f = this.cardZoomOut[a3];
                    int n = a3;
                    this.cardZoomOut[n] = this.cardZoomOut[n] + Math.max((1.0f - this.cardZoomOut[a3]) / 5.0f * partialTicks, 0.0025f);
                    if (this.cardZoomOut[a3] > 0.0f && f == 0.0f) {
                        this.playButtonPageFlip();
                    }
                }
                float prevZoomIn = this.cardZoomIn[a3];
                if (this.cardSelected) {
                    int n = a3;
                    this.cardZoomIn[n] = (float)((double)this.cardZoomIn[n] + (this.cardActive[a3] ? Math.max((double)((1.0f - this.cardZoomIn[a3]) / 3.0f * partialTicks), 0.0025) : (double)(0.3f * partialTicks)));
                    this.cardHover[a3] = 1.0f - this.cardZoomIn[a3];
                }
                this.cardZoomIn[a3] = MathHelper.func_76131_a((float)this.cardZoomIn[a3], (float)0.0f, (float)1.0f);
                this.cardHover[a3] = MathHelper.func_76131_a((float)this.cardHover[a3], (float)0.0f, (float)0.25f);
                this.cardZoomOut[a3] = MathHelper.func_76131_a((float)this.cardZoomOut[a3], (float)0.0f, (float)1.0f);
                float dx = 55 + sx - 55 * sz + xx + cw * a3 - (xx + 65);
                float fx = (float)(xx + 65) + dx * this.cardZoomOut[a3];
                float qx = (float)(xx + 191) - fx;
                if (this.cardActive[a3]) {
                    fx += qx * this.cardZoomIn[a3];
                }
                this.drawSheet(fx, yy + 100, 6.0f + this.cardZoomOut[a3] * 2.0f - this.cardZoomIn[a3] * 2.0f + this.cardHover[a3], r, this.cardActive[a3] ? 1.0f : 1.0f - this.cardZoomIn[a3], Math.max(1.0f - this.cardZoomOut[a3], this.cardZoomIn[a3]), cardChoice);
                if (this.cardSelected && this.cardActive[a3] && this.cardZoomIn[a3] >= 1.0f && prevZoomIn < 1.0f) {
                    this.playButtonWrite();
                    this.cardChoices.clear();
                    this.cardSelected = false;
                    this.lastDraw = this.table.data.lastDraw;
                    break;
                }
                ++a3;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
    }

    private void drawSheet(double x, double y, double scale, Random r, float alpha, float tilt, ResearchTableData.CardChoice cardChoice) {
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GL11.glTranslated((double)(x + r.nextGaussian()), (double)(y + r.nextGaussian()), (double)0.0);
        GL11.glScaled((double)scale, (double)scale, (double)0.0);
        GL11.glRotated((double)(r.nextGaussian() * (double)tilt), (double)0.0, (double)0.0, (double)1.0);
        GL11.glPushMatrix();
        if (cardChoice != null && cardChoice.fromAid) {
            this.field_146297_k.field_71446_o.func_110577_a(this.txPaperGilded);
        } else {
            this.field_146297_k.field_71446_o.func_110577_a(this.txPaper);
        }
        if (r.nextBoolean()) {
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        }
        if (r.nextBoolean()) {
            GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        }
        GL11.glDisable((int)2884);
        UtilsFX.drawTexturedQuadFull(-8.0f, -8.0f, 0.0);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        if (cardChoice != null && alpha == 1.0f) {
            ResearchCategory rc;
            if (cardChoice.card.getResearchCategory() != null && (rc = ResearchCategories.getResearchCategory(cardChoice.card.getResearchCategory())) != null) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha / 6.0f));
                GL11.glPushMatrix();
                GL11.glScaled((double)0.5, (double)0.5, (double)0.0);
                this.field_146297_k.field_71446_o.func_110577_a(rc.icon);
                UtilsFX.drawTexturedQuadFull(-8.0f, -8.0f, 0.0);
                GL11.glPopMatrix();
            }
            GL11.glPushMatrix();
            GL11.glScaled((double)0.0625, (double)0.0625, (double)0.0);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
            String name = TextFormatting.BOLD + cardChoice.card.getLocalizedName() + TextFormatting.RESET;
            int sz = this.field_146289_q.func_78256_a(name);
            this.field_146289_q.func_78276_b(name, -sz / 2, -65, 0);
            this.field_146289_q.func_78279_b(cardChoice.card.getLocalizedText(), -70, -48, 140, 0);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            this.field_146297_k.field_71446_o.func_110577_a(this.txBase);
            GL11.glScaled((double)0.0625, (double)0.0625, (double)0.0);
            int cc = cardChoice.card.getInspirationCost();
            boolean add = false;
            if (cc < 0) {
                add = true;
                cc = Math.abs(cc) + 1;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            for (int a = 0; a < cc; ++a) {
                if (a == 0 && add) {
                    this.func_73729_b(-10 * cc + 20 * a, -95, 48, 0, 16, 16);
                    continue;
                }
                this.func_73729_b(-10 * cc + 20 * a, -95, 32, 96, 16, 16);
            }
            GL11.glPopMatrix();
            if (cardChoice.card.getRequiredItems() != null) {
                ItemStack[] items = cardChoice.card.getRequiredItems();
                GL11.glPushMatrix();
                for (int a = 0; a < items.length; ++a) {
                    if (items[a] == null) {
                        GL11.glPushMatrix();
                        this.field_146297_k.field_71446_o.func_110577_a(this.txQuestion);
                        GL11.glScaled((double)0.125, (double)0.125, (double)0.0);
                        GL11.glColor4f((float)0.75f, (float)0.75f, (float)0.75f, (float)alpha);
                        GL11.glTranslated((double)(-9 * items.length + 18 * a), (double)35.0, (double)0.0);
                        UtilsFX.drawTexturedQuadFull(0.0f, 0.0f, 0.0);
                        GL11.glPopMatrix();
                        continue;
                    }
                    GL11.glPushMatrix();
                    GL11.glScaled((double)0.125, (double)0.125, (double)0.0);
                    RenderHelper.func_74520_c();
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179091_B();
                    GlStateManager.func_179142_g();
                    GlStateManager.func_179145_e();
                    this.field_146296_j.func_180450_b(items[a], -9 * items.length + 18 * a, 35);
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179126_j();
                    GL11.glPopMatrix();
                }
                GL11.glPopMatrix();
            }
        }
        GlStateManager.func_179084_k();
        GL11.glPopMatrix();
    }

    private void drawSheetOverlay(double x, double y, ResearchTableData.CardChoice cardChoice, int mx, int my) {
        GL11.glPushMatrix();
        if (cardChoice != null && cardChoice.card.getRequiredItems() != null) {
            ItemStack[] items = cardChoice.card.getRequiredItems();
            for (int a = 0; a < items.length; ++a) {
                if (!this.func_146978_c((int)(x - (double)(9 * items.length) + (double)(18 * a)), (int)(y + 36.0), 15, 15, mx, my)) continue;
                if (items[a] == null) {
                    this.func_146283_a(Arrays.asList(I18n.func_74838_a((String)"tc.card.unknown")), mx, my);
                    continue;
                }
                this.func_146285_a(items[a], mx, my);
            }
        }
        GL11.glPopMatrix();
    }

    private void drawCards() {
        this.cardSelected = false;
        this.cardHover = new float[]{0.0f, 0.0f, 0.0f};
        this.cardZoomOut = new float[]{0.0f, 0.0f, 0.0f};
        this.cardZoomIn = new float[]{0.0f, 0.0f, 0.0f};
        this.cardActive = new boolean[]{true, true, true};
        int draw = 2;
        if (this.table.data.bonusDraws > 0) {
            ++draw;
            --this.table.data.bonusDraws;
        }
        this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, draw);
        this.cardChoices.clear();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(this.buttonCreate);
        this.buttonCreate.field_146128_h = this.field_147003_i + 128;
        this.buttonCreate.field_146129_i = this.field_147009_r + 22;
        this.field_146292_n.add(this.buttonComplete);
        this.buttonComplete.field_146128_h = this.field_147003_i + 191;
        this.buttonComplete.field_146129_i = this.field_147009_r + 96;
        this.field_146292_n.add(this.buttonScrap);
        this.buttonScrap.field_146128_h = this.field_147003_i + 128;
        this.buttonScrap.field_146129_i = this.field_147009_r + 168;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 1) {
            this.playButtonClick();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketStartTheoryToServer(this.table.func_174877_v(), this.selectedAids));
        } else if (button.field_146127_k == 7) {
            this.playButtonClick();
            this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, 7);
            this.tempCatTotals.clear();
            this.lastDraw = null;
        } else if (button.field_146127_k == 9) {
            this.playButtonClick();
            this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, 9);
            this.tempCatTotals.clear();
            this.lastDraw = null;
            this.table.data = null;
            this.cardChoices.clear();
        } else {
            super.func_146284_a(button);
        }
    }

    private void checkButtons() {
        this.buttonComplete.active = false;
        this.buttonComplete.field_146125_m = false;
        this.buttonScrap.active = false;
        this.buttonScrap.field_146125_m = false;
        if (this.table.data != null) {
            this.buttonCreate.active = false;
            this.buttonCreate.field_146125_m = false;
            if (this.table.data.isComplete()) {
                this.buttonComplete.active = true;
                this.buttonComplete.field_146125_m = true;
            } else {
                this.buttonScrap.active = true;
                this.buttonScrap.field_146125_m = true;
            }
        } else {
            this.buttonCreate.field_146125_m = true;
            this.buttonCreate.active = this.table.func_70301_a(1) != null && this.table.func_70301_a(0) != null && this.table.func_70301_a(0).func_77952_i() != this.table.func_70301_a(0).func_77958_k();
        }
    }

    protected void func_73864_a(int mx, int my, int par3) throws IOException {
        super.func_73864_a(mx, my, par3);
        int xx = (this.field_146294_l - this.field_146999_f) / 2;
        int yy = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.table.data == null) {
            if (!this.currentAids.isEmpty()) {
                int side = Math.min(this.currentAids.size(), 6);
                int c = 0;
                int r = 0;
                for (String key : this.currentAids) {
                    ITheorycraftAid mutator = TheorycraftManager.aids.get(key);
                    if (mutator == null) continue;
                    int x = 128 + 20 * c - side * 10;
                    int y = 85 + 35 * r;
                    if (this.func_146978_c(x, y, 16, 16, mx, my)) {
                        if (this.selectedAids.contains(key)) {
                            this.selectedAids.remove(key);
                        } else if (this.selectedAids.size() + 1 < this.dummyInspirationStart) {
                            this.selectedAids.add(key);
                        }
                    }
                    if (++c < side) continue;
                    ++r;
                    c = 0;
                }
            }
        } else {
            int sx = 128;
            int cw = 110;
            if (this.cardChoices.size() > 0) {
                int pressed = -1;
                for (int a = 0; a < this.cardChoices.size(); ++a) {
                    int var7 = mx - (5 + sx - 55 * this.cardChoices.size() + xx + cw * a);
                    int var8 = my - (100 + yy - 60);
                    if (!((double)this.cardZoomOut[a] >= 0.95) || this.cardSelected || var7 < 0 || var8 < 0 || var7 >= 100 || var8 >= 120) continue;
                    pressed = a;
                    break;
                }
                if (pressed >= 0 && this.table.func_70301_a(0) != null && this.table.func_70301_a(0).func_77952_i() != this.table.func_70301_a(0).func_77958_k()) {
                    this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, 4 + pressed);
                }
            } else {
                int var7 = mx - (25 + xx);
                int var8 = my - (55 + yy);
                if (var7 >= 0 && var8 >= 0 && var7 < 75 && var8 < 90 && this.table.func_70301_a(1) != null) {
                    this.drawCards();
                }
            }
        }
    }

    void checkCards() {
        if (this.table.data.cardChoices.size() > 0 && this.cardChoices.isEmpty()) {
            this.syncFromTableChoices();
        }
        if (!this.cardSelected) {
            for (int a = 0; a < this.cardChoices.size(); ++a) {
                if (this.table.data == null || this.table.data.cardChoices.size() <= a || !this.table.data.cardChoices.get((int)a).selected) continue;
                for (int q = 0; q < this.cardChoices.size(); ++q) {
                    this.cardActive[q] = this.table.data.cardChoices.get((int)q).selected;
                }
                this.cardSelected = true;
                this.playButtonPageSelect();
                this.field_146297_k.field_71442_b.func_78756_a(this.field_147002_h.field_75152_c, 1);
                break;
            }
        }
    }

    private void playButtonPageFlip() {
        this.field_146297_k.func_175606_aa().func_184185_a(SoundsTC.page, 1.0f, 1.0f);
    }

    private void playButtonPageSelect() {
        this.field_146297_k.func_175606_aa().func_184185_a(SoundsTC.pageturn, 1.0f, 1.0f);
    }

    private void playButtonClick() {
        this.field_146297_k.func_175606_aa().func_184185_a(SoundsTC.clack, 0.4f, 1.0f);
    }

    private void playButtonWrite() {
        this.field_146297_k.func_175606_aa().func_184185_a(SoundsTC.write, 0.3f, 1.0f);
    }
}

