/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.casters;

import java.util.HashMap;
import thaumcraft.api.casters.MutatorType;

public class MutatorStore {
    public HashMap<String, MutatorType> mutators = new HashMap();
    public final MutatorType POWER = new MutatorType("power", EnumMutatorOperand.MULT);
    public final MutatorType TIME = new MutatorType("time", EnumMutatorOperand.MULT);
    public final MutatorType COST = new MutatorType("cost", EnumMutatorOperand.MULT);
    public final MutatorType FORTUNE = new MutatorType("fortune", EnumMutatorOperand.SUM);
    public final MutatorType SILKTOUCH = new MutatorType("silk", EnumMutatorOperand.SUM);

    public MutatorStore() {
        this.registerMutator(this.POWER);
        this.registerMutator(this.COST);
        this.registerMutator(this.TIME);
    }

    public void registerMutator(MutatorType mutator) {
        if (!this.mutators.containsKey(mutator.key)) {
            this.mutators.put(mutator.key, mutator);
        } else {
            this.modifyMutator(mutator, mutator.value);
        }
    }

    public void modifyMutator(MutatorType mutator, float value) {
        this.modifyMutator(mutator.key, value);
    }

    public void modifyMutator(String key, float value) {
        if (this.mutators.containsKey(key)) {
            MutatorType mutator = this.mutators.get(key);
            mutator.apply(value);
            this.mutators.put(key, mutator);
        }
    }

    public float getValue(MutatorType mutator) {
        return this.getValue(mutator.key);
    }

    public float getValue(String key) {
        if (this.mutators.containsKey(key)) {
            return this.mutators.get((Object)key).value;
        }
        return 0.0f;
    }

    public void merge(MutatorStore store) {
        for (MutatorType mutator : store.mutators.values()) {
            if (!this.mutators.containsKey(mutator.key)) {
                this.registerMutator(mutator);
            }
            this.modifyMutator(mutator, mutator.value);
        }
    }

    public static enum EnumMutatorOperand {
        SUM,
        MULT;

    }
}

