/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.casters;

import java.util.Arrays;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.MutatorStore;

public interface IFocusPart {
    public String getKey();

    public String getResearch();

    public Aspect getAspect();

    default public boolean hasAttribute(EnumPartAttribute attribute) {
        return this.getAttributes() == null || Arrays.asList(this.getAttributes()).contains((Object)attribute);
    }

    public EnumPartAttribute[] getAttributes();

    default public String getName() {
        return I18n.func_74838_a((String)("focuspart." + this.getKey() + ".name"));
    }

    default public String getText() {
        return I18n.func_74838_a((String)("focuspart." + this.getKey() + ".text"));
    }

    public EnumFocusPartType getType();

    public ResourceLocation getIcon();

    public int getGemColor();

    public int getIconColor();

    default public boolean canConnectTo(IFocusPart part) {
        return true;
    }

    default public boolean hasCustomFX() {
        return false;
    }

    default public void drawCustomFX(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
    }

    default public void applyBaseMutators(MutatorStore mutators) {
    }

    public static enum EnumFocusPartType {
        MEDIUM,
        EFFECT,
        MODIFIER;

    }

    public static enum EnumPartAttribute {
        RANGED(false, EnumFocusPartType.MEDIUM),
        TOUCH(false, EnumFocusPartType.MEDIUM),
        BLOCKS(false, EnumFocusPartType.MEDIUM, EnumFocusPartType.EFFECT),
        ENTITIES(false, EnumFocusPartType.MEDIUM, EnumFocusPartType.EFFECT),
        TIMED(false, EnumFocusPartType.MODIFIER),
        HARVEST(true, EnumFocusPartType.EFFECT);

        EnumFocusPartType[] partTypes;
        public boolean required;

        private EnumPartAttribute(boolean required, EnumFocusPartType ... partTypes) {
            this.partTypes = partTypes;
            this.required = required;
        }

        public boolean shouldCheckAgainst(EnumFocusPartType checkType) {
            for (EnumFocusPartType tt : this.partTypes) {
                if (checkType != tt) continue;
                return true;
            }
            return false;
        }
    }
}

