/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.casters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thaumcraft.api.casters.FocusHelper;
import thaumcraft.api.casters.IFocusPart;
import thaumcraft.api.casters.IFocusPartEffect;
import thaumcraft.api.casters.IFocusPartMedium;
import thaumcraft.api.casters.IFocusPartModifier;
import thaumcraft.api.casters.MutatorStore;
import thaumcraft.api.casters.MutatorType;

public class FocusCore {
    public IFocusPartMedium medium;
    public IFocusPartModifier[] mediumModifiers;
    public FocusEffect[] effects;
    public float cost;
    public LinkedHashMap<String, IFocusPart> partsRaw;
    public ArrayList<String> ignoredParts = new ArrayList();
    public int uniqueId = 0;

    public FocusCore(IFocusPartMedium medium, IFocusPartModifier[] mediumModifiers, FocusEffect[] effects) {
        this.medium = medium;
        this.mediumModifiers = mediumModifiers;
        this.effects = effects;
    }

    public FocusCore() {
        this.medium = FocusHelper.TOUCH;
        FocusEffect fe = new FocusEffect();
        fe.effect = FocusHelper.FIRE;
        this.effects = new FocusEffect[]{fe};
        this.generate(false);
    }

    public FocusCore(NBTTagCompound nbt) {
        this.deserialize(nbt);
    }

    public void ignorePart(IFocusPart part) {
        this.ignoredParts.add(part.getKey());
    }

    public boolean isPartIgnored(IFocusPart part) {
        return this.ignoredParts.contains(part.getKey());
    }

    public IFocusPartMedium.EnumFocusCastMethod getFinalCastMethod() {
        if (this.mediumModifiers != null) {
            for (IFocusPartModifier part : this.mediumModifiers) {
                if (part != FocusHelper.CHARGE) continue;
                return IFocusPartMedium.EnumFocusCastMethod.CHARGE;
            }
        }
        return this.medium.getCastMethod();
    }

    public int getFinalChargeTime() {
        if (this.mediumModifiers != null) {
            for (IFocusPartModifier part : this.mediumModifiers) {
                if (part != FocusHelper.CHARGE) continue;
                return this.medium.getChargeTime() * 10;
            }
        }
        return this.medium.getChargeTime();
    }

    public void generate() {
        this.generate(false);
    }

    private void generate(boolean foundMutators) {
        this.partsRaw = new LinkedHashMap();
        if (this.medium == null) {
            return;
        }
        this.partsRaw.put(this.medium.getKey(), this.medium);
        this.cost = 0.0f;
        if (this.mediumModifiers != null) {
            Arrays.sort(this.mediumModifiers, new ModifierSorter());
            for (IFocusPartModifier mediumMod : this.mediumModifiers) {
                this.partsRaw.put(mediumMod.getKey(), mediumMod);
            }
        }
        for (FocusEffect focusEffect : this.effects) {
            if (!foundMutators) {
                focusEffect.mutators = new MutatorStore();
                this.medium.applyBaseMutators(focusEffect.mutators);
                if (this.mediumModifiers != null) {
                    for (IFocusPartModifier mediumMod : this.mediumModifiers) {
                        mediumMod.applyBaseMutators(focusEffect.mutators);
                    }
                }
                focusEffect.effect.applyBaseMutators(focusEffect.mutators);
                if (focusEffect.modifiers != null) {
                    Arrays.sort(focusEffect.modifiers, new ModifierSorter());
                    for (IFocusPartModifier effMod : focusEffect.modifiers) {
                        effMod.applyBaseMutators(focusEffect.mutators);
                    }
                }
            }
            this.partsRaw.put(focusEffect.effect.getKey(), focusEffect.effect);
            this.cost += focusEffect.effect.getBaseCost() * focusEffect.mutators.getValue(focusEffect.mutators.COST);
        }
    }

    public NBTTagCompound serialize() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("medium", this.medium.getKey());
        nbt.func_74768_a("id", this.uniqueId);
        if (this.mediumModifiers != null && this.mediumModifiers.length > 0) {
            String s = "";
            for (IFocusPartModifier p : this.mediumModifiers) {
                s = s + "~" + p.getKey();
            }
            s = s.replaceFirst("~", "");
            nbt.func_74778_a("mediumMods", s);
        }
        NBTTagList efflist = new NBTTagList();
        for (FocusEffect fe : this.effects) {
            NBTTagCompound gt = new NBTTagCompound();
            gt.func_74778_a("effect", fe.effect.getKey());
            if (fe.modifiers != null && fe.modifiers.length > 0) {
                String s = "";
                for (IFocusPartModifier p : fe.modifiers) {
                    s = s + "~" + p.getKey();
                }
                s = s.replaceFirst("~", "");
                gt.func_74778_a("mods", s);
            }
            NBTTagList mutlist = new NBTTagList();
            for (String key : fe.mutators.mutators.keySet()) {
                NBTTagCompound mu = new NBTTagCompound();
                mu.func_74778_a("name", key);
                mu.func_74778_a("type", fe.mutators.mutators.get((Object)key).operand.name());
                mu.func_74776_a("val", fe.mutators.getValue(key));
                mutlist.func_74742_a((NBTBase)mu);
            }
            gt.func_74782_a("mutators", (NBTBase)mutlist);
            efflist.func_74742_a((NBTBase)gt);
        }
        nbt.func_74782_a("effects", (NBTBase)efflist);
        NBTTagList iglist = new NBTTagList();
        for (String fe : this.ignoredParts) {
            NBTTagCompound gt = new NBTTagCompound();
            gt.func_74778_a("key", fe);
            iglist.func_74742_a((NBTBase)gt);
        }
        nbt.func_74782_a("ignored", (NBTBase)iglist);
        return nbt;
    }

    public void deserialize(NBTTagCompound nbt) {
        IFocusPart mp = FocusHelper.getFocusPart(nbt.func_74779_i("medium"));
        if (mp == null) {
            return;
        }
        this.uniqueId = nbt.func_74762_e("id");
        this.medium = (IFocusPartMedium)mp;
        String s = nbt.func_74779_i("mediumMods");
        String[] ss = s.split("~");
        if (ss.length > 0) {
            ArrayList<IFocusPartModifier> li = new ArrayList<IFocusPartModifier>();
            for (int a = 0; a < ss.length; ++a) {
                try {
                    IFocusPartModifier p = (IFocusPartModifier)FocusHelper.getFocusPart(ss[a]);
                    if (p == null) continue;
                    li.add(p);
                    continue;
                }
                catch (Exception p) {
                    // empty catch block
                }
            }
            this.mediumModifiers = li.toArray(new IFocusPartModifier[li.size()]);
        }
        boolean foundMutators = false;
        NBTTagList efflist = nbt.func_150295_c("effects", 10);
        ArrayList<FocusEffect> fes = new ArrayList<FocusEffect>();
        for (int x = 0; x < efflist.func_74745_c(); ++x) {
            NBTTagCompound nbtdata = efflist.func_150305_b(x);
            FocusEffect fe = new FocusEffect();
            fe.effect = (IFocusPartEffect)FocusHelper.getFocusPart(nbtdata.func_74779_i("effect"));
            String mods = nbtdata.func_74779_i("mods");
            if (!mods.isEmpty()) {
                String[] modlist = mods.split("~");
                ArrayList<IFocusPartModifier> li = new ArrayList<IFocusPartModifier>();
                for (int a = 0; a < modlist.length; ++a) {
                    try {
                        IFocusPartModifier p = (IFocusPartModifier)FocusHelper.getFocusPart(modlist[a]);
                        if (p == null) continue;
                        li.add(p);
                        continue;
                    }
                    catch (Exception p) {
                        // empty catch block
                    }
                }
                fe.modifiers = li.toArray(new IFocusPartModifier[li.size()]);
            }
            NBTTagList mutlist = nbtdata.func_150295_c("mutators", 10);
            for (int m = 0; m < mutlist.func_74745_c(); ++m) {
                foundMutators = true;
                NBTTagCompound mutnbtdata = mutlist.func_150305_b(m);
                MutatorType mut = null;
                mut = mutnbtdata.func_74779_i("type").equals("SUM") ? new MutatorType(mutnbtdata.func_74779_i("name"), MutatorStore.EnumMutatorOperand.SUM) : new MutatorType(mutnbtdata.func_74779_i("name"), MutatorStore.EnumMutatorOperand.MULT);
                mut.apply(mutnbtdata.func_74760_g("val"));
                fe.mutators.registerMutator(mut);
            }
            fes.add(fe);
        }
        NBTTagList iglist = nbt.func_150295_c("ignored", 10);
        for (int x = 0; x < iglist.func_74745_c(); ++x) {
            NBTTagCompound nbtdata = iglist.func_150305_b(x);
            this.ignoredParts.add(nbtdata.func_74779_i("key"));
        }
        this.effects = fes.toArray(new FocusEffect[fes.size()]);
        this.generate(foundMutators);
    }

    public String getSortingHelper() {
        String s = this.medium.getKey();
        if (this.mediumModifiers != null) {
            for (IFocusPartModifier pm : this.mediumModifiers) {
                s = s + pm.getKey();
            }
        }
        for (FocusEffect ef : this.effects) {
            s = s + ef.effect.getKey();
            if (ef.modifiers == null) continue;
            for (IFocusPartModifier pm : ef.modifiers) {
                s = s + pm.getKey();
            }
        }
        return s;
    }

    public FocusCore copy() {
        FocusCore nc = new FocusCore(this.serialize());
        return nc;
    }

    public class ModifierSorter
    implements Comparator<IFocusPartModifier> {
        @Override
        public int compare(IFocusPartModifier mod1, IFocusPartModifier mod2) {
            byte d1;
            byte d0 = mod1.getApplicationOrder();
            return d0 < (d1 = mod2.getApplicationOrder()) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }

    public static class FocusEffect {
        public IFocusPartEffect effect;
        public IFocusPartModifier[] modifiers;
        public MutatorStore mutators = new MutatorStore();
    }
}

