/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.casters;

import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import thaumcraft.api.casters.FocusCore;
import thaumcraft.api.casters.IFocusPartModifier;
import thaumcraft.api.casters.MutatorStore;

public class CasterEngine {
    public static boolean cast(FocusCore core, Entity casterEntity, ItemStack casterStack, RayTraceResult source, Vec3d castVector, MutatorStore castingMutators) {
        for (FocusCore.FocusEffect ef : core.effects) {
            ef.mutators.merge(castingMutators);
        }
        boolean cancel = false;
        if (core.mediumModifiers != null) {
            for (IFocusPartModifier mediumMod : core.mediumModifiers) {
                boolean b;
                if (core.isPartIgnored(mediumMod) || !(b = mediumMod.applyAtCast(casterEntity, casterStack, core, source, castVector))) continue;
                cancel = true;
            }
        }
        if (cancel || core.medium.onCast(casterEntity, casterStack, core, source, castVector)) {
            for (FocusCore.FocusEffect focusEffect : core.effects) {
                if (core.isPartIgnored(focusEffect.effect)) continue;
                boolean cancel2 = false;
                if (focusEffect.modifiers != null) {
                    for (IFocusPartModifier effectMod : focusEffect.modifiers) {
                        boolean b;
                        if (core.isPartIgnored(effectMod) || !(b = effectMod.applyAtCast(casterEntity, casterStack, core, source, castVector))) continue;
                        cancel2 = true;
                    }
                }
                if (cancel2) continue;
                focusEffect.effect.onCast(casterEntity, casterStack);
            }
            return true;
        }
        return false;
    }

    public static void applyEffectsFromFocus(FocusCore core, RayTraceResult source, RayTraceResult mediumTarget, Entity casterEntity, ItemStack casterStack) {
        boolean cancel = false;
        if (core.mediumModifiers != null) {
            for (IFocusPartModifier mediumMod : core.mediumModifiers) {
                boolean b;
                if (core.isPartIgnored(mediumMod) || !(b = mediumMod.applyAtMediumResolution(casterEntity, casterStack, core, mediumTarget, source, source.field_72308_g != null ? source.field_72308_g.func_70676_i(1.0f) : new Vec3d(0.0, 0.0, 0.0)))) continue;
                cancel = true;
            }
        }
        if (!cancel) {
            HashMap<Integer, Integer> hurtMap = new HashMap<Integer, Integer>();
            for (FocusCore.FocusEffect focusEffect : core.effects) {
                boolean cancel2;
                if (core.isPartIgnored(focusEffect.effect) || (cancel2 = core.medium.applyAtEffect(casterEntity, casterStack, focusEffect, mediumTarget, source, source.field_72308_g != null ? source.field_72308_g.func_70676_i(1.0f) : new Vec3d(0.0, 0.0, 0.0)))) continue;
                focusEffect.effect.onTrigger(casterEntity, casterStack, focusEffect, source, mediumTarget);
                if (focusEffect.modifiers != null) {
                    for (IFocusPartModifier effectMod : focusEffect.modifiers) {
                        boolean b;
                        if (core.isPartIgnored(effectMod) || !(b = effectMod.applyAtEffect(casterEntity, casterStack, focusEffect, mediumTarget, source, source.field_72308_g != null ? source.field_72308_g.func_70676_i(1.0f) : new Vec3d(0.0, 0.0, 0.0)))) continue;
                        cancel2 = true;
                    }
                }
                if (mediumTarget.field_72308_g != null) {
                    if (mediumTarget.field_72308_g.field_70172_ad <= 0) {
                        hurtMap.put(mediumTarget.field_72308_g.func_145782_y(), 0);
                    }
                    if (hurtMap.containsKey(mediumTarget.field_72308_g.func_145782_y())) {
                        hurtMap.put(mediumTarget.field_72308_g.func_145782_y(), mediumTarget.field_72308_g.field_70172_ad);
                        mediumTarget.field_72308_g.field_70172_ad = 0;
                    }
                }
                focusEffect.effect.applyToTarget(casterEntity, casterStack, focusEffect, source, mediumTarget);
            }
            for (Integer k : hurtMap.keySet()) {
                Entity e = casterEntity.func_130014_f_().func_73045_a(k.intValue());
                if (e == null) continue;
                e.field_70172_ad = (Integer)hurtMap.get(k);
            }
        }
    }
}

