/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.item;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.BlockRegistry;
import com.pam.harvestcraft.blocks.CropRegistry;
import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import com.pam.harvestcraft.item.GeneralOreRegistry;
import com.pam.harvestcraft.item.ItemRegistry;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeRegistry {
    public static void registerRecipes() {
        RecipeRegistry.registerFoodRecipes();
        RecipeRegistry.registerOtherRecipes();
        RecipeRegistry.registerBeeRecipes();
        RecipeRegistry.registerPresserRecipe();
        RecipeRegistry.registerMarketRecipe();
        RecipeRegistry.registerSmelting();
    }

    private static void registerSmelting() {
        RecipeRegistry.addSmelting(ItemRegistry.doughItem, Items.field_151025_P);
        RecipeRegistry.addSmelting(Items.field_151025_P, ItemRegistry.toastItem);
        RecipeRegistry.addSmelting(Items.field_151080_bb, ItemRegistry.roastedpumpkinseedsItem);
        RecipeRegistry.addSmelting((Block)Blocks.field_150338_P, ItemRegistry.grilledmushroomItem);
        RecipeRegistry.addSmelting((Block)Blocks.field_150337_Q, ItemRegistry.grilledmushroomItem);
        RecipeRegistry.addSmelting(ItemRegistry.calamarirawItem, ItemRegistry.calamaricookedItem);
        RecipeRegistry.addSmelting((Item)CropRegistry.getFood("asparagus"), ItemRegistry.grilledasparagusItem);
        RecipeRegistry.addSmelting((Item)CropRegistry.getFood("rice"), ItemRegistry.ricecakeItem);
        RecipeRegistry.addSmelting((Item)CropRegistry.getFood("tealeaf"), ItemRegistry.teaItem);
        RecipeRegistry.addSmelting((Item)CropRegistry.getFood("corn"), ItemRegistry.popcornItem);
        RecipeRegistry.addSmelting((Item)CropRegistry.getFood("sweetpotato"), ItemRegistry.bakedsweetpotatoItem);
        RecipeRegistry.addSmelting((Item)CropRegistry.getFood("coffeebean"), ItemRegistry.coffeeItem);
        RecipeRegistry.addSmelting((Item)CropRegistry.getFood("eggplant"), ItemRegistry.grilledeggplantItem);
        RecipeRegistry.addSmelting((Item)CropRegistry.getFood("grape"), ItemRegistry.raisinsItem);
        RecipeRegistry.addSmelting((Item)CropRegistry.getFood("whitemushroom"), ItemRegistry.grilledmushroomItem);
        RecipeRegistry.addSmelting(FruitRegistry.getFood("coconut"), ItemRegistry.toastedcoconutItem);
        RecipeRegistry.addSmelting(FruitRegistry.getFood("vanillabean"), ItemRegistry.vanillaItem);
        RecipeRegistry.addSmelting(FruitRegistry.getFood("chestnut"), ItemRegistry.roastedchestnutItem);
        RecipeRegistry.addSmelting((Item)CropRegistry.getFood("sesameseeds"), ItemRegistry.toastedsesameseedsItem);
        RecipeRegistry.addSmelting(ItemRegistry.anchovyrawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.bassrawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.carprawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.catfishrawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.charrrawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.eelrawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.grouperrawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.herringrawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.mudfishrawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.perchrawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.snapperrawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.tilapiarawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.troutrawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.tunarawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.walleyerawItem, Items.field_179566_aV);
        RecipeRegistry.addSmelting(ItemRegistry.clamrawItem, ItemRegistry.clamcookedItem);
        RecipeRegistry.addSmelting(ItemRegistry.crabrawItem, ItemRegistry.crabcookedItem);
        RecipeRegistry.addSmelting(ItemRegistry.crayfishrawItem, ItemRegistry.crayfishcookedItem);
        RecipeRegistry.addSmelting(ItemRegistry.frograwItem, ItemRegistry.frogcookedItem);
        RecipeRegistry.addSmelting(ItemRegistry.octopusrawItem, ItemRegistry.octopuscookedItem);
        RecipeRegistry.addSmelting(ItemRegistry.scalloprawItem, ItemRegistry.scallopcookedItem);
        RecipeRegistry.addSmelting(ItemRegistry.shrimprawItem, ItemRegistry.shrimpcookedItem);
        RecipeRegistry.addSmelting(ItemRegistry.snailrawItem, ItemRegistry.snailcookedItem);
        RecipeRegistry.addSmelting(ItemRegistry.turtlerawItem, ItemRegistry.turtlecookedItem);
    }

    private static void registerPresserRecipe() {
        RecipeRegistry.addShapedOreRecipe((Block)BlockRegistry.presser, "#O#", "# #", "#O#", Character.valueOf('#'), "ingotIron", Character.valueOf('O'), Blocks.field_150331_J);
        RecipeRegistry.addShapedOreRecipe((Block)BlockRegistry.presser, "#O#", "# #", "#O#", Character.valueOf('#'), "ingotCopper", Character.valueOf('O'), Blocks.field_150331_J);
        RecipeRegistry.addShapedOreRecipe((Block)BlockRegistry.presser, "#O#", "# #", "#O#", Character.valueOf('#'), "ingotSteel", Character.valueOf('O'), Blocks.field_150331_J);
    }

    private static void registerBeeRecipes() {
        for (int i = 0; i < 18; ++i) {
            RecipeRegistry.addShapelessOreRecipe(ItemRegistry.royaljellyItem, new ItemStack(ItemRegistry.queenbeeItem, 1, i));
        }
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.queenbeeItem, ItemRegistry.grubItem, ItemRegistry.royaljellyItem);
        RecipeRegistry.addShapedOreRecipe((Block)BlockRegistry.apiary, "#O#", "#O#", "#O#", Character.valueOf('#'), "plankWood", Character.valueOf('O'), Items.field_151160_bD);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.fruitbaitItem, Items.field_151007_F, "listAllfruit", "listAllfruit", "listAllfruit");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grainbaitItem, Items.field_151007_F, "listAllgrain", "listAllgrain", "listAllgrain");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.veggiebaitItem, Items.field_151007_F, "listAllveggie", "listAllveggie", "listAllveggie");
    }

    /*
     * Opcode count of 13209 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void registerFoodRecipes() {
        for (BlockPamSapling blockPamSapling : FruitRegistry.getSaplings()) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)blockPamSapling), (Object[])new Object[]{new ItemStack(blockPamSapling.getFruitItem()), new ItemStack(blockPamSapling.getFruitItem()), new ItemStack(blockPamSapling.getFruitItem()), new ItemStack(Blocks.field_150345_g, 1, Short.MAX_VALUE)});
        }
        if (HarvestCraft.config.enablecroptoseedRecipe) {
            for (Map.Entry entry : CropRegistry.getFoods().entrySet()) {
                if (HarvestCraft.config.enablecropspecialplanting && (((String)entry.getKey()).equals("cranberry") || ((String)entry.getKey()).equals("rice") || ((String)entry.getKey()).equals("seaweed"))) continue;
                RecipeRegistry.addShapelessOreRecipe(CropRegistry.getSeed((String)entry.getKey()), entry.getValue());
            }
        }
        if (HarvestCraft.config.enablesaltfromwaterbucketrecipe) {
            RecipeRegistry.addShapelessOreRecipe(ItemRegistry.saltItem, "toolPot", "listAllwater");
        }
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.sunflowerseedsItem, 2, 0), new ItemStack((Block)Blocks.field_150398_cm, 1, 0), new ItemStack((Block)Blocks.field_150398_cm, 1, 0));
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.freshwaterItem, "listAllwater");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bubblywaterItem, "toolPot", ItemRegistry.freshwaterItem);
        RecipeRegistry.addShapelessOreRecipe(Items.field_151102_aT, "toolPot", "foodHoneydrop");
        RecipeRegistry.addShapelessOreRecipe(Items.field_151102_aT, "toolPot", "dropHoney");
        RecipeRegistry.addShapelessOreRecipe(Items.field_151115_aP, "listAllfishraw");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.freshwaterItem, HarvestCraft.config.freshwaterfrombucket), Items.field_151131_as);
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.freshmilkItem, HarvestCraft.config.freshmilkfrombucket), Items.field_151117_aB);
        RecipeRegistry.addShapedOreRecipe(Items.field_151105_aU, "AAA", "BEB", "CCC", Character.valueOf('A'), "listAllmilk", Character.valueOf('B'), "listAllsugar", Character.valueOf('C'), "flourEqualswheat", Character.valueOf('E'), "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(Items.field_151009_A, Items.field_151054_z, "listAllmushroom", "listAllmushroom");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.flourItem, "toolMortarandpestle", Items.field_151015_O);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.flourItem, "toolMortarandpestle", "cropRice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.flourItem, "toolMortarandpestle", Items.field_151174_bG);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.flourItem, "toolMortarandpestle", "cropRye");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.flourItem, "toolMortarandpestle", "cropOats");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.flourItem, "toolMortarandpestle", "cropBarley");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.doughItem, "toolMixingbowl", "listAllwater", "foodFlour", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.doughItem, "toolMixingbowl", "listAllwater", "foodFlour", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.doughItem, "toolMixingbowl", "listAllwater", "foodFlour", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pastaItem, "toolMixingbowl", "foodDough", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.heavycreamItem, "toolMixingbowl", "listAllmilk");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.butterItem, "toolSaucepan", "listAllheavycream", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.butterItem, "toolSaucepan", "listAllheavycream", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.butterItem, "toolSaucepan", "listAllheavycream", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cheeseItem, "toolPot", "listAllmilk", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cheeseItem, "toolPot", "listAllmilk", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cheeseItem, "toolPot", "listAllmilk", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.icecreamItem, "toolMixingbowl", "listAllmilk", "foodSalt", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.icecreamItem, "toolMixingbowl", "listAllmilk", "dustSalt", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.icecreamItem, "toolMixingbowl", "listAllmilk", "itemSalt", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grilledcheeseItem, "toolSkillet", "foodToast", "foodButter", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.applesauceItem, "toolPot", "cropApple");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.applejuiceItem, "toolJuicer", "cropApple");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.applepieItem, "toolBakeware", "cropApple", "listAllsugar", "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.caramelappleItem, "cropApple", "foodCaramel", "stickWood");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pumpkinbreadItem, "toolBakeware", Blocks.field_150423_aK, "listAllsugar", "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pumpkinsoupItem, "toolPot", Blocks.field_150423_aK, "listAllheavycream", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.melonjuiceItem, "toolJuicer", Items.field_151127_ba);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.melonsmoothieItem, "toolJuicer", Items.field_151127_ba, Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.carrotjuiceItem, "toolJuicer", Items.field_151172_bF);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.carrotcakeItem, "toolBakeware", Items.field_151172_bF, "listAllsugar", "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.carrotsoupItem, "toolPot", Items.field_151172_bF, "listAllheavycream", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.glazedcarrotsItem, "toolSaucepan", Items.field_151172_bF, "foodButter", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.butteredpotatoItem, Items.field_151168_bH, "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.loadedbakedpotatoItem, "foodButteredpotato", "listAllporkcooked", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mashedpotatoesItem, "toolMixingbowl", "foodButteredpotato", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mashedpotatoesItem, "toolMixingbowl", "foodButteredpotato", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mashedpotatoesItem, "toolMixingbowl", "foodButteredpotato", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.potatosaladItem, "toolCuttingboard", Items.field_151168_bH, "foodMayo");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.potatosoupItem, "toolPot", Items.field_151174_bG, "foodSalt", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.potatosoupItem, "toolPot", Items.field_151174_bG, "dustSalt", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.potatosoupItem, "toolPot", Items.field_151174_bG, "itemSalt", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.friesItem, "toolBakeware", Items.field_151174_bG, "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.friesItem, "toolBakeware", Items.field_151174_bG, "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.friesItem, "toolBakeware", Items.field_151174_bG, "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.stuffedmushroomItem, "toolBakeware", "listAllmushroom", "foodCheese", "foodToast");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grilledmushroomItem, "toolSkillet", "listAllmushroom");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chickensandwichItem, "toolSkillet", "listAllchickenraw", Items.field_151025_P, "foodMayo");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chickennoodlesoupItem, "toolPot", "listAllchickenraw", Items.field_151172_bF, "foodPasta", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chickenpotpieItem, "toolBakeware", "listAllchickenraw", Items.field_151174_bG, Items.field_151172_bF, "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.breadedporkchopItem, "toolSkillet", "listAllporkraw", "foodFlour");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.hotdogItem, "toolPot", "listAllporkraw", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bakedhamItem, "toolBakeware", "listAllporkraw", "cropApple", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.hamburgerItem, "toolSkillet", "listAllbeefraw", "foodToast");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cheeseburgerItem, "foodHamburger", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.baconcheeseburgerItem, "foodCheeseburger", "listAllporkcooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.potroastItem, "toolPot", "listAllbeefraw", Items.field_151174_bG, Items.field_151172_bF, "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.fishsandwichItem, "toolSkillet", "listAllfishraw", "foodMayo", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.fishsticksItem, "toolBakeware", "listAllfishraw", "foodFlour");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.fishandchipsItem, "foodFishsticks", "foodFries");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mayoItem, "toolJuicer", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.friedeggItem, "toolSkillet", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.scrambledeggItem, "toolSaucepan", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.boiledeggItem, "toolPot", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.eggsaladItem, "toolCuttingboard", "foodBoiledegg", "foodMayo");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.caramelItem, "toolSaucepan", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.taffyItem, "toolSaucepan", "listAllsugar", "listAllwater", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.taffyItem, "toolSaucepan", "listAllsugar", "listAllwater", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.taffyItem, "toolSaucepan", "listAllsugar", "listAllwater", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.spidereyesoupItem, "toolPot", Items.field_151070_bp, "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.zombiejerkyItem, Items.field_151078_bh, "foodSalt", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.zombiejerkyItem, Items.field_151078_bh, "dustSalt", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.zombiejerkyItem, Items.field_151078_bh, "itemSalt", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.zombiejerkyItem, Items.field_151078_bh, "itemSalt", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.zombiejerkyItem, Items.field_151078_bh, "itemSalt", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.zombiejerkyItem, Items.field_151078_bh, "foodSalt", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cocoapowderItem, "toolMortarandpestle", GeneralOreRegistry.dyeBrown);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chocolatebarItem, "toolSaucepan", "foodCocoapowder", "foodButter", "listAllmilk");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.hotchocolateItem, "toolJuicer", "foodCocoapowder", "listAllmilk");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chocolateicecreamItem, "toolMixingbowl", "listAllicecream", "foodCocoapowder");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.vegetablesoupItem, "toolPot", Items.field_151174_bG, Items.field_151172_bF, "listAllmushroom", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.stockItem, 3), "toolPot", Items.field_151103_aS);
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.stockItem, 3), "toolPot", "listAllmeatraw");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.stockItem, 3), "toolPot", "listAllveggie");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.fruitsaladItem, "toolCuttingboard", "listAllfruit", "listAllfruit");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.spagettiItem, "toolSaucepan", "cropTomato", "foodPasta", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.spagettiandmeatballsItem, "toolMixingbowl", "foodSpagetti", "listAllbeefcooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.tomatosoupItem, "toolPot", "cropTomato", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.ketchupItem, "toolJuicer", "cropTomato");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chickenparmasanItem, "toolBakeware", "listAllchickencooked", "cropTomato", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pizzaItem, "toolBakeware", "foodDough", "cropTomato", "foodCheese", "listAllporkraw");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", Items.field_151172_bF);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", "cropOnion");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", "cropRadish");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", "cropCucumber");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", "cropBellpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", "cropZucchini");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", "cropAsparagus");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", "cropBroccoli");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", "cropPeas");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", "cropTomato");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", "cropSunflower");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", "cropWalnut");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", "cropCauliflower");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.springsaladItem, "toolCuttingboard", "cropLettuce", "cropRhubarb");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.porklettucewrapItem, "toolCuttingboard", "cropLettuce", "listAllporkcooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.fishlettucewrapItem, "toolCuttingboard", "cropLettuce", "listAllfishcooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bltItem, "toolCuttingboard", "cropLettuce", "cropTomato", "listAllporkcooked", "foodToast");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.leafychickensandwichItem, "foodChickensandwich", "cropLettuce");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.leafyfishsandwichItem, "foodFishsandwich", "cropLettuce");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.deluxecheeseburgerItem, "foodCheeseburger", "cropLettuce", "cropTomato");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.delightedmealItem, "foodDeluxecheeseburger", "foodFries", "listAllsmoothie");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.delightedmealItem, "foodDeluxecheeseburger", "foodZucchinifries", "listAllsmoothie");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.onionsoupItem, "toolPot", "cropOnion", "foodStock", "foodGrilledcheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.potatocakesItem, "toolSkillet", "cropOnion", Items.field_151174_bG, "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.hashItem, "toolSkillet", "cropOnion", "listAllbeefcooked", Items.field_151174_bG, "foodKetchup");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.braisedonionsItem, "toolSaucepan", "cropOnion", "foodButter", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.heartybreakfastItem, "listAllporkcooked", "foodFriedegg", "foodToast", "foodPotatocakes", "listAlljuice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.heartybreakfastItem, "listAllporkcooked", "foodFriedegg", "foodToast", "foodPotatocakes", "foodChocolatemilk");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cornonthecobItem, "cropCorn", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cornmealItem, "toolMortarandpestle", "cropCorn");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cornbreadItem, "toolSkillet", "foodCornmeal", "listAllegg", "listAllmilk");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.tortillaItem, "toolSkillet", "foodCornmeal", "listAllwater");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.nachoesItem, "toolCuttingboard", "foodTortilla", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.tacoItem, "toolCuttingboard", "listAllbeefcooked", "cropLettuce", "foodCheese", "foodTortilla");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.fishtacoItem, "toolCuttingboard", "listAllfishcooked", "cropLettuce", "foodCheese", "foodTortilla");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.creamedcornItem, "toolSaucepan", "cropCorn", "cropOnion", "foodHeavycream");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.strawberrysmoothieItem, "toolJuicer", "cropStrawberry", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.strawberrypieItem, "toolBakeware", "cropStrawberry", "foodDough", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.strawberrysaladItem, "cropStrawberry", "foodFruitsalad");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.strawberryjuiceItem, "toolJuicer", "cropStrawberry");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chocolatestrawberryItem, "toolSaucepan", "cropStrawberry", "foodChocolatebar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.peanutbutterItem, "toolJuicer", "cropPeanut");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.trailmixItem, "listAllseed", "listAllseed", "listAllseed", "listAllseed", "listAllseed", "listAllseed", "foodRaisins", "foodChocolatebar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.trailmixItem, "foodSaltedsunflowerseeds", "foodRaisins", "foodChocolatebar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.trailmixItem, "listAllnut", "listAllnut", "foodRaisins", "foodChocolatebar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.trailmixItem, "foodRoastedpumpkinseeds", "foodRaisins", "foodChocolatebar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pbandjItem, "toolCuttingboard", "listAllnutbutter", "foodGrapejelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.peanutbuttercookiesItem, "toolBakeware", "listAllnutbutter", "foodFlour", "listAllegg", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grapejuiceItem, "toolJuicer", "cropGrape");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.vinegarItem, "toolPot", "foodGrapejuice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grapejellyItem, "toolSaucepan", "cropGrape", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grapesaladItem, "cropGrape", "foodFruitsalad");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.raisincookiesItem, "toolBakeware", "foodFlour", "listAllegg", "listAllsugar", "foodRaisins");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.picklesItem, "toolPot", "cropCucumber", "foodSalt", "foodVinegar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.picklesItem, "toolPot", "cropCucumber", "dustSalt", "foodVinegar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.picklesItem, "toolPot", "cropCucumber", "itemSalt", "foodVinegar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cucumbersaladItem, "toolCuttingboard", "cropCucumber", "foodSpringsalad");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cucumbersoupItem, "toolPot", "cropCucumber", "foodStock", "listAllheavycream");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.vegetarianlettucewrapItem, "toolCuttingboard", "cropCucumber", "cropLettuce", "cropTomato");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.marinatedcucumbersItem, "toolPot", "cropCucumber", "cropOnion", "listAllsugar", "foodVinegar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.ricesoupItem, "toolPot", "cropRice", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.friedriceItem, "toolSkillet", "cropRice", Items.field_151172_bF, "listAllegg", "cropOnion");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mushroomrisottoItem, "toolBakeware", "cropRice", "listAllmushroom", "cropOnion", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.curryItem, "toolSaucepan", "cropRice", "foodSalt", "cropChilipepper", "foodCoconutmilk", "listAllspice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.curryItem, "toolSaucepan", "cropRice", "dustSalt", "cropChilipepper", "foodCoconutmilk", "listAllspice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.curryItem, "toolSaucepan", "cropRice", "itemSalt", "cropChilipepper", "foodCoconutmilk", "listAllspice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.rainbowcurryItem, "toolSkillet", "cropRice", GeneralOreRegistry.dyeRed, GeneralOreRegistry.dyeYellow, GeneralOreRegistry.dyeOrange, GeneralOreRegistry.dyeGreen, GeneralOreRegistry.dyePurple, GeneralOreRegistry.dyeBlue);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.refriedbeansItem, "toolSkillet", "cropBean", "cropOnion", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bakedbeansItem, "toolPot", "cropBean", "listAllporkcooked", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.beansandriceItem, "toolPot", "cropBean", "cropRice", "cropOnion", "listAllporkcooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.beansandriceItem, "toolPot", "cropBean", "cropRice", "cropBellpepper", "listAllporkcooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.beansandriceItem, "toolPot", "cropBean", "cropRice", "cropChilipepper", "listAllporkcooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chiliItem, "toolPot", "cropBean", "cropOnion", "listAllbeefcooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chiliItem, "toolPot", "cropBean", "cropBellpepper", "listAllbeefcooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chiliItem, "toolPot", "cropBean", "cropChilipepper", "listAllbeefcooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.beanburritoItem, "toolSkillet", "cropBean", "foodTortilla", "cropRice", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.stuffedpepperItem, "toolBakeware", "cropBellpepper", "cropTomato", "cropRice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.veggiestirfryItem, "toolSkillet", "cropBellpepper", Items.field_151172_bF, "cropRice", "cropOnion", "cropBean");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.veggiestirfryItem, "toolSkillet", "cropBellpepper", Items.field_151172_bF, "cropRice", "cropOnion", "cropChilipepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.veggiestirfryItem, "toolSkillet", "cropBellpepper", Items.field_151172_bF, "cropRice", "cropOnion", "listAllmushroom");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grilledskewersItem, "toolCuttingboard", "cropBellpepper", "cropOnion", Items.field_151172_bF, "stickWood");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.supremepizzaItem, "toolCuttingboard", "foodPizza", "cropBellpepper", "cropOnion", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.omeletItem, "toolSkillet", "listAllegg", "cropBellpepper", "cropOnion");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.hotwingsItem, "toolSkillet", "cropChilipepper", "listAllchickencooked", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chilipoppersItem, "toolBakeware", "cropChilipepper", "foodFlour", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.extremechiliItem, "foodChili", "cropChilipepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chilichocolateItem, "toolMixingbowl", "foodChocolatebar", "cropChilipepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.lemonaideItem, "toolJuicer", "cropLemon");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.lemonbarItem, "toolBakeware", "cropLemon", "foodDough", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.fishdinnerItem, "toolSkillet", "cropLemon", "foodFlour", "listAllfishraw", "foodMayo");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.lemonsmoothieItem, "toolJuicer", "cropLemon", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.lemonmeringueItem, "toolBakeware", "cropLemon", "listAllsugar", "foodDough", "listAllheavycream");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.candiedlemonItem, "toolBakeware", "cropLemon", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.lemonchickenItem, "toolBakeware", "cropLemon", "listAllchickenraw", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blueberrysmoothieItem, "toolJuicer", "cropBlueberry", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blueberrypieItem, "toolBakeware", "cropBlueberry", "foodDough", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blueberrymuffinItem, "toolBakeware", "cropBlueberry", "foodFlour", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blueberryjuiceItem, "toolJuicer", "cropBlueberry");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pancakesItem, "toolSkillet", "foodFlour", "listAllegg", "listAllmilk");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blueberrypancakesItem, "cropBlueberry", "foodPancakes");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cherryjuiceItem, "toolJuicer", "cropCherry");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cherrypieItem, "toolBakeware", "cropCherry", "foodDough", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chocolatecherryItem, "toolSaucepan", "cropCherry", "foodChocolatebar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cherrysmoothieItem, "toolJuicer", "cropCherry", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cheesecakeItem, "toolBakeware", "foodFlour", "listAllheavycream", "listAllsugar", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cherrycheesecakeItem, "cropCherry", "foodCheesecake");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.stuffedeggplantItem, "toolBakeware", "cropEggplant", "cropOnion", "cropBellpepper", "foodButter", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.stuffedeggplantItem, "toolBakeware", "cropEggplant", "cropGarlic");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.eggplantparmItem, "toolBakeware", "cropEggplant", "cropTomato", "foodPasta", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.raspberryicedteaItem, "cropTea", Items.field_151126_ay, "cropRaspberry");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chaiteaItem, "cropTea", "foodGroundcinnamon", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.espressoItem, "cropCoffee", "cropCoffee", "cropCoffee", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.coffeeconlecheItem, "foodEspresso", "listAllmilk", "foodGroundcinnamon");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mochaicecreamItem, "toolMixingbowl", "listAllicecream", "cropCoffee", "foodCocoapowder");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pickledbeetsItem, "toolPot", "cropBeet", "foodVinegar", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pickledbeetsItem, "toolPot", "cropBeet", "foodVinegar", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pickledbeetsItem, "toolPot", "cropBeet", "foodVinegar", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.beetsaladItem, "toolMixingbowl", "cropBeet", "cropLettuce", "foodVinegar", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.beetsoupItem, "toolPot", "cropBeet", "cropOnion", "foodBlackpepper", "listAllmilk");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bakedbeetsItem, "toolBakeware", "cropBeet", "foodButter", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.broccolimacItem, "toolPot", "cropBroccoli", "foodPasta", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.broccolindipItem, "toolMixingbowl", "cropBroccoli", "cropOnion", "listAllheavycream");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.creamedbroccolisoupItem, "toolPot", "cropBroccoli", Items.field_151172_bF, "foodFlour", "foodBlackpepper", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sweetpotatopieItem, "toolBakeware", "cropSweetpotato", "foodDough", "foodGroundcinnamon", "foodMarshmellows");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.candiedsweetpotatoesItem, "toolSaucepan", "cropSweetpotato", "listAllsugar", "foodGroundcinnamon");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mashedsweetpotatoesItem, "toolSaucepan", "cropSweetpotato", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.steamedpeasItem, "toolPot", "cropPeas", "listAllwater", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.steamedpeasItem, "toolPot", "cropPeas", "listAllwater", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.steamedpeasItem, "toolPot", "cropPeas", "listAllwater", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.splitpeasoupItem, "toolPot", "cropPeas", "listAllporkcooked", "foodBlackpepper", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pineappleupsidedowncakeItem, "toolBakeware", "cropPineapple", "foodDough", "cropCherry", "cropWalnut");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pineapplehamItem, "toolBakeware", "cropPineapple", "listAllporkraw", "cropCherry", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pineappleyogurtItem, "cropPineapple", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.turnipsoupItem, "toolPot", "cropTurnip", Blocks.field_150423_aK, "foodButter", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.roastedrootveggiemedleyItem, "toolBakeware", "cropTurnip", Items.field_151172_bF, "cropOnion", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.roastedrootveggiemedleyItem, "toolBakeware", Blocks.field_150423_aK, Items.field_151172_bF, "cropOnion", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.roastedrootveggiemedleyItem, "toolBakeware", Items.field_151174_bG, Items.field_151172_bF, "cropOnion", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.roastedrootveggiemedleyItem, "toolBakeware", "cropSweetpotato", Items.field_151172_bF, "cropOnion", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.roastedrootveggiemedleyItem, "toolBakeware", "cropRadish", Items.field_151172_bF, "cropOnion", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.roastedrootveggiemedleyItem, "toolBakeware", "cropParsnip", Items.field_151172_bF, "cropOnion", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bakedturnipsItem, "toolBakeware", "cropTurnip", "foodButter", "foodSalt", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bakedturnipsItem, "toolBakeware", "cropTurnip", "foodButter", "dustSalt", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bakedturnipsItem, "toolBakeware", "cropTurnip", "foodButter", "itemSalt", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gingerbreadItem, "toolBakeware", "cropGinger", "foodFlour", "foodButter", "listAllegg", "foodGroundcinnamon");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gingersnapsItem, "toolBakeware", "cropGinger", "foodFlour", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.candiedgingerItem, "toolSaucepan", "cropGinger", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mustardItem, "toolJuicer", "cropMustard");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.softpretzelandmustardItem, "foodSoftpretzel", "foodMustard");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.spicymustardporkItem, "toolSaucepan", "foodMustard", "listAllporkraw", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.spicymustardporkItem, "toolSaucepan", "foodMustard", "listAllporkraw", "cropGarlic");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.spicymustardporkItem, "toolSaucepan", "foodMustard", "listAllporkraw", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.spicymustardporkItem, "toolSaucepan", "foodMustard", "listAllporkraw", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.spicymustardporkItem, "toolSaucepan", "foodMustard", "listAllporkraw", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.spicygreensItem, "toolSaucepan", "foodMustard", "cropLettuce", "foodBlackpepper", "cropGarlic", "foodOliveoil", "cropOnion");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.spicygreensItem, "toolSaucepan", "foodMustard", "cropBroccoli", "foodBlackpepper", "cropGarlic", "foodOliveoil", "cropOnion");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.spicygreensItem, "toolSaucepan", "foodMustard", "cropPeas", "foodBlackpepper", "cropGarlic", "foodOliveoil", "cropOnion");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.garlicbreadItem, "cropGarlic", "foodToast", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.garlicmashedpotatoesItem, "foodMashedpotatoes", "cropGarlic");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.garlicchickenItem, "toolBakeware", "cropGarlic", "cropGarlic", "cropGarlic", "foodOliveoil", "listAllchickenraw");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.summerradishsaladItem, "toolMixingbowl", "cropRadish", "cropOnion", "cropCucumber", "foodVinegar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.summersquashwithradishItem, "toolMixingbowl", "cropRadish", "cropZucchini", Blocks.field_150423_aK, "cropSpiceleaf", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.celeryandpeanutbutterItem, "cropCelery", "listAllnutbutter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chickencelerycasseroleItem, "toolBakeware", "cropCelery", "listAllchickenraw", "cropGarlic", Items.field_151172_bF, "listAllmushroom");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.peasandceleryItem, "toolMixingbowl", "cropCelery", "cropPeas", "cropLemon", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.celerysoupItem, "toolPot", "cropCelery", "cropOnion", Items.field_151172_bF, "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.zucchinibreadItem, "toolBakeware", "cropZucchini", "foodDough", "foodGroundcinnamon", "cropWalnut");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.zucchinifriesItem, "toolBakeware", "cropZucchini", "foodToast", "foodCheese", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.zestyzucchiniItem, "toolBakeware", "cropZucchini", "foodPasta", "cropChilipepper", "cropGarlic", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.zucchinibakeItem, "toolBakeware", "cropZucchini", "cropTomato", "foodToast", "cropCorn", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.asparagusquicheItem, "toolSkillet", "cropAsparagus", "listAllegg", "cropOnion", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.asparagussoupItem, "toolPot", "cropAsparagus", "cropOnion", "foodButter", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.walnutraisinbreadItem, "toolBakeware", "cropWalnut", "foodRaisins", "foodDough", "foodGroundcinnamon");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.candiedwalnutsItem, "toolSaucepan", "cropWalnut", "foodVanilla", "foodGroundcinnamon", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.brownieItem, "toolBakeware", "cropWalnut", "foodFlour", "listAllegg", "foodButter", "listAllsugar", "foodCocoapowder", "foodVanilla");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.papayajuiceItem, "toolJuicer", "cropPapaya");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.papayasmoothieItem, "toolJuicer", "cropPapaya", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.papayayogurtItem, "cropPapaya", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.starfruitjuiceItem, "toolJuicer", "cropStarfruit");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.starfruitsmoothieItem, "toolJuicer", "cropStarfruit", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.starfruityogurtItem, "cropStarfruit", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.guacamoleItem, "toolCuttingboard", "cropAvocado", "cropChilipepper", "cropTomato", "cropOnion", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.creamofavocadosoupItem, "toolPot", "cropAvocado", "listAllheavycream", "cropLime", "cropSpiceleaf", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.avocadoburritoItem, "toolCuttingboard", "cropAvocado", "foodTortilla", "foodCheese", "listAllchickencooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.avocadoburritoItem, "toolCuttingboard", "cropAvocado", "foodTortilla", "foodCheese", "listAllporkcooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.poachedpearItem, "toolSaucepan", "cropPear", "foodVanilla", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.fruitcrumbleItem, "toolBakeware", "listAllfruit", "foodGroundcinnamon", "foodFlour", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pearyogurtItem, "cropPear", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.plumyogurtItem, "cropPlum", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bananasplitItem, "toolMixingbowl", "cropBanana", "foodCocoapowder", "cropCherry", "listAllicecream", "cropStrawberry");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.banananutbreadItem, "toolBakeware", "cropBanana", "foodFlour", "cropWalnut", "listAllmilk", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.banananutbreadItem, "toolBakeware", "cropBanana", "foodFlour", "cropWalnut", "listAllmilk", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.banananutbreadItem, "toolBakeware", "cropBanana", "foodFlour", "cropWalnut", "listAllmilk", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bananasmoothieItem, "toolJuicer", "cropBanana", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bananayogurtItem, "cropBanana", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.coconutmilkItem, "toolJuicer", "cropCoconut");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chickencurryItem, "toolPot", "cropCoconut", "foodPlainyogurt", "listAllchickenraw", "listAllspice", "cropChilipepper", "cropRice", "foodGroundcinnamon", "cropGarlic");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.coconutshrimpItem, "toolSkillet", "cropCoconut", "listAllegg", "foodFlour", "foodShrimpraw", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.coconutyogurtItem, "cropCoconut", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.orangejuiceItem, "toolJuicer", "cropOrange");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.orangechickenItem, "toolSaucepan", "cropOrange", "listAllchickenraw", "listAllsugar", "cropRice", "cropBroccoli");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.orangesmoothieItem, "toolJuicer", "cropOrange", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.orangeyogurtItem, "cropOrange", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.peachjuiceItem, "toolJuicer", "cropPeach");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.peachcobblerItem, "toolBakeware", "cropPeach", "listAllsugar", "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.peachsmoothieItem, "toolJuicer", "cropPeach", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.peachyogurtItem, "cropPeach", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.limejuiceItem, "toolJuicer", "cropLime");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.keylimepieItem, "toolBakeware", "cropLime", "listAllheavycream", "listAllsugar", "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.limesmoothieItem, "toolJuicer", "cropLime", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.limeyogurtItem, "cropLime", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mangojuiceItem, "toolJuicer", "cropMango");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mangosmoothieItem, "toolJuicer", "cropMango", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mangoyogurtItem, "cropMango", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pomegranatejuiceItem, "toolJuicer", "cropPomegranate");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pomegranatesmoothieItem, "toolJuicer", "cropPomegranate", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pomegranateyogurtItem, "cropPomegranate", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.vanillayogurtItem, "foodVanilla", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cinnamonrollItem, "toolBakeware", "foodGroundcinnamon", "listAllsugar", "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.frenchtoastItem, "toolSkillet", "foodGroundcinnamon", "foodToast", "listAllsugar", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.marshmellowsItem, "toolPot", "listAllsugar", "listAllwater", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.donutItem, "toolPot", "foodDough", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chocolatedonutItem, "foodDonut", "foodChocolatebar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.powdereddonutItem, "foodDonut", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.jellydonutItem, "foodDonut", "foodGrapejelly");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.frosteddonutItem, "foodDonut", "listAllsugar", GeneralOreRegistry.dyeRed, GeneralOreRegistry.dyeGreen, GeneralOreRegistry.dyeYellow);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cactussoupItem, "toolPot", Blocks.field_150434_aF, "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.wafflesItem, "toolSkillet", "foodFlour", "listAllegg", "listAllmilk", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.seedsoupItem, "toolPot", "listAllseed", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.softpretzelItem, "toolBakeware", "foodDough", "foodButter", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.softpretzelItem, "toolBakeware", "foodDough", "foodButter", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.softpretzelItem, "toolBakeware", "foodDough", "foodButter", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.jellybeansItem, "toolSaucepan", "listAllsugar", GeneralOreRegistry.dyeRed, GeneralOreRegistry.dyeYellow);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.biscuitItem, "toolBakeware", "foodDough", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.creamcookieItem, "toolBakeware", "foodDough", "listAllheavycream", "listAllsugar", "foodCocoapowder");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.jaffaItem, "toolBakeware", "listAllegg", "listAllsugar", "foodFlour", "foodChocolatebar", "cropOrange");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.friedchickenItem, "toolPot", "listAllchickenraw", "foodFlour", "cropSpiceleaf", "foodBlackpepper", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chocolatesprinklecakeItem, "toolBakeware", "foodCocoapowder", "listAllsugar", "foodDough", GeneralOreRegistry.dyeRed, GeneralOreRegistry.dyeGreen, GeneralOreRegistry.dyeYellow);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.redvelvetcakeItem, "toolBakeware", "listAllmilk", "foodFlour", "listAllheavycream", "listAllsugar", "listAllegg", GeneralOreRegistry.dyeRed, GeneralOreRegistry.dyeRed);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.footlongItem, "toolCuttingboard", Items.field_151025_P, "listAllbeefcooked", "cropLettuce", "cropTomato", "foodMayo");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.footlongItem, "toolCuttingboard", Items.field_151025_P, "listAllchickencooked", "cropLettuce", "cropTomato", "foodMayo");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.footlongItem, "toolCuttingboard", Items.field_151025_P, "listAllporkcooked", "cropLettuce", "cropTomato", "foodMayo");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blueberryyogurtItem, "cropBlueberry", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.lemonyogurtItem, "cropLemon", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cherryyogurtItem, "cropCherry", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.strawberryyogurtItem, "cropStrawberry", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grapeyogurtItem, "cropGrape", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chocolateyogurtItem, "foodCocoapowder", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blackberryjuiceItem, "toolJuicer", "cropBlackberry");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blackberrycobblerItem, "cropBlackberry", "toolBakeware", "listAllsugar", "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blackberrysmoothieItem, "toolJuicer", "cropBlackberry", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blackberryyogurtItem, "cropBlackberry", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chocolatemilkItem, "listAllmilk", "foodCocoapowder");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pumpkinyogurtItem, Blocks.field_150423_aK, "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.raspberryjuiceItem, "toolJuicer", "cropRaspberry");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.raspberrypieItem, "cropRaspberry", "toolBakeware", "listAllsugar", "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.raspberrysmoothieItem, "toolJuicer", "cropRaspberry", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.raspberryyogurtItem, "cropRaspberry", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cinnamonsugardonutItem, "foodDonut", "listAllsugar", "foodGroundcinnamon");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.melonyogurtItem, Items.field_151127_ba, "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.kiwijuiceItem, "toolJuicer", "cropKiwi");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.kiwismoothieItem, "toolJuicer", "cropKiwi", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.kiwiyogurtItem, "cropKiwi", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.plainyogurtItem, 4), "listAllmilk", Items.field_151116_aA);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.appleyogurtItem, "cropApple", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.saltedsunflowerseedsItem, "cropSunflower", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.saltedsunflowerseedsItem, "cropSunflower", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.saltedsunflowerseedsItem, "cropSunflower", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sunflowerwheatrollsItem, "toolBakeware", "cropSunflower", "foodFlour", "listAllegg", "foodSalt", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sunflowerwheatrollsItem, "toolBakeware", "cropSunflower", "foodFlour", "listAllegg", "dustSalt", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sunflowerwheatrollsItem, "toolBakeware", "cropSunflower", "foodFlour", "listAllegg", "itemSalt", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sunflowerbroccolisaladItem, "toolCuttingboard", "cropSunflower", "cropBroccoli", "foodMayo", "listAllsugar", "listAllporkcooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cranberryjuiceItem, "toolJuicer", "cropCranberry");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cranberrysauceItem, "toolPot", "cropCranberry", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cranberrybarItem, "toolBakeware", "cropCranberry", "listAllsugar", "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.peppermintItem, "toolSaucepan", "cropSpiceleaf", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cactusfruitjuiceItem, "toolJuicer", "cropCactusfruit");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blackpepperItem, "toolMortarandpestle", "cropPeppercorn");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.groundcinnamonItem, "toolMortarandpestle", "cropCinnamon");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.groundnutmegItem, "toolMortarandpestle", "cropNutmeg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.oliveoilItem, "toolJuicer", "cropOlive");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.oliveoilItem, "toolJuicer", "cropSunflower");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.oliveoilItem, "toolJuicer", "cropWalnut");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.baklavaItem, "toolBakeware", "foodDough", "cropWalnut", "cropCinnamon", "foodButter", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gummybearsItem, "toolSaucepan", "listAllsugar", GeneralOreRegistry.dyeRed, GeneralOreRegistry.dyeGreen);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.baconmushroomburgerItem, "foodBaconcheeseburger", "listAllmushroom");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.baconmushroomburgerItem, "foodBaconcheeseburger", "cropWhitemushroom");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.fruitpunchItem, "toolJuicer", "listAllfruit", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.meatystewItem, "toolPot", "listAllmeatraw", "foodFlour", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mixedsaladItem, "toolCuttingboard", "listAllveggie", "listAllveggie", "foodSaladdressing");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pinacoladaItem, "toolJuicer", "cropCoconut", "cropPineapple");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.saladdressingItem, "toolJuicer", "foodOliveoil", "foodSalt", "foodVinegar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.saladdressingItem, "toolJuicer", "foodOliveoil", "dustSalt", "foodVinegar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.saladdressingItem, "toolJuicer", "foodOliveoil", "itemSalt", "foodVinegar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.saladdressingItem, "toolJuicer", "foodMayo", "cropSpiceleaf", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.shepardspieItem, "toolBakeware", "listAllmuttonraw", Items.field_151174_bG, Items.field_151172_bF, "foodDough", "cropPeas");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.eggnogItem, "toolJuicer", "listAllegg", "foodGroundnutmeg", "cropCinnamon", "listAllheavycream");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.custardItem, "toolSaucepan", "listAllegg", "foodGroundnutmeg", "cropCinnamon", "listAllheavycream");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sushiItem, "toolCuttingboard", "listAllfishraw", "cropSeaweed", "cropRice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gardensoupItem, "toolPot", "foodStock", "listAllveggie", "listAllveggie");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.applejellyItem, "toolSaucepan", "cropApple", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blackberryjellyItem, "toolSaucepan", "cropBlackberry", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blueberryjellyItem, "toolSaucepan", "cropBlueberry", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cherryjellyItem, "toolSaucepan", "cropCherry", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cranberryjellyItem, "toolSaucepan", "cropCranberry", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.kiwijellyItem, "toolSaucepan", "cropKiwi", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.lemonjellyItem, "toolSaucepan", "cropLemon", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.limejellyItem, "toolSaucepan", "cropLime", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mangojellyItem, "toolSaucepan", "cropMango", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.orangejellyItem, "toolSaucepan", "cropOrange", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.papayajellyItem, "toolSaucepan", "cropPapaya", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.peachjellyItem, "toolSaucepan", "cropPeach", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pomegranatejellyItem, "toolSaucepan", "cropPomegranate", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.raspberryjellyItem, "toolSaucepan", "cropRaspberry", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.starfruitjellyItem, "toolSaucepan", "cropStarfruit", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.strawberryjellyItem, "toolSaucepan", "cropStrawberry", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.watermelonjellyItem, "toolSaucepan", Items.field_151127_ba, Items.field_151127_ba, "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.applejellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodApplejelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blackberryjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodBlackberryjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.blueberryjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodBlueberryjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cherryjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodCherryjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cranberryjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodCranberryjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.kiwijellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodKiwijelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.lemonjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodLemonjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.limejellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodLimejelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mangojellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodMangojelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.orangejellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodOrangejelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.papayajellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodPapayajelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.peachjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodPeachjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pomegranatejellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodPomegranatejelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.raspberryjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodRaspberryjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.starfruitjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodStarfruitjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.strawberryjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodStrawberryjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.watermelonjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodWatermelonjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cherrysodaItem, "toolPot", "foodBubblywater", "listAllsugar", "foodCherryjuice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.colasodaItem, "toolPot", "foodBubblywater", "listAllsugar", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gingersodaItem, "toolPot", "foodBubblywater", "listAllsugar", "cropGinger");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grapesodaItem, "toolPot", "foodBubblywater", "listAllsugar", "foodGrapejuice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.lemonlimesodaItem, "toolPot", "foodBubblywater", "listAllsugar", "cropLemon", "foodLimejuice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.orangesodaItem, "toolPot", "foodBubblywater", "listAllsugar", "foodOrangejuice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.rootbeersodaItem, "toolPot", "foodBubblywater", "listAllsugar", "cropEdibleroot");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.strawberrysodaItem, "toolPot", "foodBubblywater", "listAllsugar", "foodStrawberryjuice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.caramelicecreamItem, "toolMixingbowl", "listAllicecream", "foodCaramel");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mintchocolatechipicemcreamItem, "toolMixingbowl", "listAllicecream", "cropSpiceleaf", "foodChocolatebar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.strawberryicecreamItem, "toolMixingbowl", "listAllicecream", "cropStrawberry");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.vanillaicecreamItem, "toolMixingbowl", "listAllicecream", "foodVanilla");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.ediblerootItem, "toolCuttingboard", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gingerchickenItem, "toolSaucepan", "listAllchickenraw", "cropGinger", "cropScallion", "foodHoneydrop");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gingerchickenItem, "toolSaucepan", "listAllchickenraw", "cropGinger", "cropScallion", "dropHoney");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.oldworldveggiesoupItem, "toolPot", "foodStock", "cropOnion", "cropPeas", "cropBarley");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.spicebunItem, "toolBakeware", "foodFlour", "listAllmilk", "foodGroundnutmeg", "foodGroundcinnamon", "foodRaisins");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gingeredrhubarbtartItem, "toolBakeware", "foodDough", "cropRhubarb", "cropGinger", "listAllsugar", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.lambbarleysoupItem, "toolPot", "foodStock", "listAllmuttonraw", "cropOnion", Items.field_151172_bF, "cropBarley");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.honeylemonlambItem, "toolBakeware", "listAllmuttonraw", "cropLemon", "foodMustard", "foodHoneydrop");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.honeylemonlambItem, "toolBakeware", "listAllmuttonraw", "cropLemon", "foodMustard", "dropHoney");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pumpkinoatsconesItem, "toolBakeware", "foodFlour", "cropOats", Blocks.field_150423_aK, "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.beefjerkyItem, "listAllbeefraw", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.beefjerkyItem, "listAllbeefraw", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.beefjerkyItem, "listAllbeefraw", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.plumjuiceItem, "toolJuicer", "cropPlum");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pearjuiceItem, "toolJuicer", "cropPear");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.ovenroastedcauliflowerItem, "toolBakeware", "cropCauliflower", "foodOliveoil", "cropGarlic", "cropLemon");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.leekbaconsoupItem, "toolPot", "cropLeek", "listAllporkcooked", Items.field_151174_bG, "listAllheavycream");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.herbbutterparsnipsItem, "toolSaucepan", "cropParsnip", "foodButter", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.scallionbakedpotatoItem, Items.field_151168_bH, "cropScallion", "listAllheavycream");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bamboosteamedriceItem, "toolPot", "cropRice", "cropBambooshoot");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sweetpotatosouffleItem, "toolBakeware", "cropSweetpotato", "cropPecan", "foodDough", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cashewchickenItem, "toolSaucepan", "listAllchickenraw", "cropCashew", "cropRice", "listAllpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.apricotjuiceItem, "toolJuicer", "cropApricot");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.apricotyogurtItem, "cropApricot", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.apricotglazedporkItem, "listAllporkcooked", "foodApricotjelly");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.apricotjellyItem, "toolSaucepan", "cropApricot", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.apricotjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodApricotjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.apricotsmoothieItem, "toolJuicer", "cropApricot", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.figbarItem, "toolBakeware", "cropFig", "listAllsugar", "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.figjellyItem, "toolSaucepan", "cropFig", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.figjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodFigjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.figsmoothieItem, "toolJuicer", "cropFig", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.figyogurtItem, "cropFig", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.figjuiceItem, "toolJuicer", "cropFig");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grapefruitjuiceItem, "toolJuicer", "cropGrapefruit");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grapefruitjellyItem, "toolSaucepan", "cropGrapefruit", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grapefruitjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodGrapefruitjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grapefruitsmoothieItem, "toolJuicer", "cropGrapefruit", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grapefruityogurtItem, "cropGrapefruit", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grapefruitsodaItem, "toolPot", "foodBubblywater", "listAllsugar", "foodGrapefruitjuice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.citrussaladItem, "toolCuttingboard", "listAllcitrus", "cropLettuce");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pecanpieItem, "toolBakeware", "cropPecan", "foodDough", "listAllsugar", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pralinesItem, "toolSaucepan", "cropPecan", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.persimmonjuiceItem, "toolJuicer", "cropPersimmon");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.persimmonyogurtItem, "cropPersimmon", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.persimmonsmoothieItem, "toolJuicer", "cropPersimmon", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.persimmonjellyItem, "toolSaucepan", "cropPersimmon", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.persimmonjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodPersimmonjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pistachiobakedsalmonItem, "toolBakeware", "cropPistachio", "foodSalmonraw");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.baconwrappeddatesItem, "toolBakeware", "cropDate", "listAllporkcooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.datenutbreadItem, "toolBakeware", "cropDate", "foodDough", "listAllnut");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.maplesyruppancakesItem, "foodPancakes", "cropMaplesyrup");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.maplesyrupwafflesItem, "foodWaffles", "cropMaplesyrup");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.maplesausageItem, "listAllbeefraw", "cropSpiceleaf", "cropMaplesyrup");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mapleoatmealItem, "toolMixingbowl", "cropOats", "cropMaplesyrup");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.peachesandcreamoatmealItem, "toolMixingbowl", "cropOats", "cropPeach", "listAllheavycream");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cinnamonappleoatmealItem, "toolMixingbowl", "cropOats", "foodGroundcinnamon", "cropApple");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.maplecandiedbaconItem, "toolBakeware", "listAllporkcooked", "cropMaplesyrup");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.toastsandwichItem, "foodToast", "foodToast");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.potatoandcheesepirogiItem, "toolSkillet", "foodDough", "cropPotato", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.zeppoleItem, "toolPot", "foodOliveoil", "foodDough", "foodGroundcinnamon");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sausageinbreadItem, "foodMaplesausage", Items.field_151025_P, "foodKetchup", "cropOnion");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chocolatecaramelfudgeItem, "toolBakeware", "foodChocolatebar", "foodCaramel");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.lavendershortbreadItem, "toolBakeware", GeneralOreRegistry.dyePurple, "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.beefwellingtonItem, "listAllbeefraw", "foodDough", "listAllmushroom", "cropSpinach");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.epicbaconItem, "listAllporkcooked", GeneralOreRegistry.dyeRed, GeneralOreRegistry.dyeOrange, GeneralOreRegistry.dyeYellow, GeneralOreRegistry.dyeGreen, GeneralOreRegistry.dyeBlue, GeneralOreRegistry.dyePurple, GeneralOreRegistry.dyeMagenta);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.manjuuItem, "toolMixingbowl", "listAllsugar", "cropRice", "cropBean");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chickengumboItem, "toolPot", "cropOkra", "listAllchickenraw", "cropCelery", "cropOnion", "foodStock", "listAllspice", "cropBellpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.generaltsochickenItem, "toolSkillet", "listAllchickenraw", "cropBroccoli", "listAllsugar", "foodFlour", "cropChilipepper", "cropRice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.californiarollItem, "toolCuttingboard", "listAllfishraw", "cropAvocado", "cropCucumber", "cropSeaweed", "cropRice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.futomakiItem, "toolCuttingboard", "foodBoiledegg", "cropCucumber", "cropWintersquash", "cropRadish", "cropSeaweed", "cropGinger", "cropRice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.beansontoastItem, "toolCuttingboard", "foodToast", "foodButter", "foodBakedbeans");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.vegemiteItem, "toolPot", "listAllsugar", "cropBarley", "listAllwater", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.honeycombchocolatebarItem, "toolSaucepan", "foodChocolatebar", "foodHoneydrop");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cherrycoconutchocolatebarItem, "toolSaucepan", "foodChocolatebar", "cropCherry", "foodToastedcoconut");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.fairybreadItem, "toolBakeware", Items.field_151025_P, "foodButter", GeneralOreRegistry.dyeRed, GeneralOreRegistry.dyeGreen, GeneralOreRegistry.dyeYellow);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.lamingtonItem, "toolBakeware", "foodDough", "foodChocolatebar", "foodToastedcoconut");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.timtamItem, "toolBakeware", "listAllsugar", "foodFlour", "listAllmilk", "foodChocolatebar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.meatpieItem, "toolBakeware", "listAllbeefraw", "foodDough", "cropOnion", "cropGarlic", "foodBlackpepper", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chikorollItem, "toolPot", "foodOliveoil", "foodDough", "listAllchickencooked", "cropCarrot", "cropCabbage", "cropLeek", "cropOnion");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.damperItem, "toolBakeware", "foodFlour", "listAllmilk", "foodSalt", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.damperItem, "toolBakeware", "foodFlour", "listAllmilk", "oreSalt", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.damperItem, "toolBakeware", "foodFlour", "listAllmilk", "dustSalt", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.damperItem, "toolBakeware", "foodFlour", "listAllmilk", "itemSalt", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.beetburgerItem, "toolCuttingboard", "listAllbeefcooked", "cropBeet", "foodFriedegg", "listAllporkcooked", "cropPineapple", "foodToast");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pavlovaItem, "toolBakeware", "listAllegg", "listAllsugar", "cropLemon", "listAllheavycream", "cropStrawberry");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gherkinItem, "toolPot", "foodVinegar", "foodSalt", "cropSpiceleaf", "cropCucumber");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gherkinItem, "toolPot", "foodVinegar", "oreSalt", "cropSpiceleaf", "cropCucumber");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gherkinItem, "toolPot", "foodVinegar", "dustSalt", "cropSpiceleaf", "cropCucumber");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gherkinItem, "toolPot", "foodVinegar", "itemSalt", "cropSpiceleaf", "cropCucumber");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mcpamItem, "toolCuttingboard", "listAllbeefcooked", "cropLettuce", "foodPickles", "cropOnion", "foodToast", "foodSaladdressing");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mcpamItem, "toolCuttingboard", "listAllbeefcooked", "cropLettuce", "foodGherkin", "cropOnion", "foodToast", "foodSaladdressing");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.ceasarsaladItem, "toolMixingbowl", "cropLettuce", "foodToast", "foodCheese", "cropGarlic", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chaoscookieItem, "toolBakeware", "foodFlour", "foodChocolatebar", GeneralOreRegistry.dyePurple);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chocolatebaconItem, "toolSaucepan", "listAllporkcooked", "foodChocolatebar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.lambkebabItem, "toolCuttingboard", "listAllmuttoncooked", "cropOnion", "cropBellpepper", "stickWood");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.nutellaItem, "toolSaucepan", "foodChocolatebar", "foodGroundnutmeg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.snickersbarItem, "toolSaucepan", "foodChocolatebar", "cropPeanut", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.spinachpieItem, "toolBakeware", "foodDough", "cropSpinach", "foodCheese", "foodToast");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.steamedspinachItem, "toolPot", "cropSpinach", "listAllwater");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.vegemiteontoastItem, "toolCuttingboard", "foodVegemite", "foodToast");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.holidaycakeItem, "toolBakeware", "listAllegg", "listAllsugar", "cropCherry", "listAllheavycream", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.appleciderItem, "toolPot", "cropApple", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bangersandmashItem, "toolSkillet", "foodPorksausage", "foodMashedpotatoes");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.batteredsausageItem, "toolPot", "foodPorksausage", "foodBatter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.batterItem, "toolMixingbowl", "foodFlour", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chorizoItem, "toolCuttingboard", "listAllporkcooked", "listAllspice", "cropGarlic", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chorizoItem, "toolCuttingboard", "listAllporkcooked", "listAllspice", "cropGarlic", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chorizoItem, "toolCuttingboard", "listAllporkcooked", "listAllspice", "cropGarlic", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.coleslawItem, "toolMixingbowl", "cropCabbage", "cropCarrot", "foodMayo", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.energydrinkItem, "toolPot", "foodBubblywater", "listAllsugar", Items.field_151137_ax);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.friedonionsItem, "toolPot", "cropOnion", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.meatfeastpizzaItem, "toolPot", "foodPizza", "foodPepperoni", "foodPorksausage", "listAllbeefcooked", Items.field_151077_bg);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mincepieItem, "toolBakeware", "listAllbeefcooked", "listAllfruit", "listAllnut", "foodDough", "foodButter");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.onionhamburgerItem, "toolCuttingboard", "foodHamburger", "foodFriedonions");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pepperoniItem, "toolCuttingboard", "listAllporkcooked", "listAllspice", "cropBellpepper", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pepperoniItem, "toolCuttingboard", "listAllporkcooked", "listAllspice", "cropBellpepper", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pepperoniItem, "toolCuttingboard", "listAllporkcooked", "listAllspice", "cropBellpepper", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pickledonionsItem, "toolPot", "cropOnion", "foodSalt", "foodVinegar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pickledonionsItem, "toolPot", "cropOnion", "dustSalt", "foodVinegar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pickledonionsItem, "toolPot", "cropOnion", "itemSalt", "foodVinegar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.porksausageItem, "toolCuttingboard", "listAllporkcooked", "listAllspice", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.porksausageItem, "toolCuttingboard", "listAllporkcooked", "listAllspice", "dustSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.porksausageItem, "toolCuttingboard", "listAllporkcooked", "listAllspice", "itemSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.raspberrytrifleItem, "toolBakeware", "cropRaspberry", "listAllheavycream", "foodVanilla", "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pumpkincheesecakeItem, Blocks.field_150423_aK, "foodCheesecake");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pumpkinmuffinItem, "toolBakeware", Blocks.field_150423_aK, "foodFlour", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.suaderoItem, "toolCuttingboard", "listAllbeefcooked", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.randomtacoItem, "toolCuttingboard", "listAllbeefcooked", "cropOnion", "foodCheese", "cropAvocado", "listAllspice", "foodLimejuice", "foodTortilla");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.strawberrymilkshakeItem, "toolJuicer", "listAllmilk", "cropStrawberry", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chocolatemilkshakeItem, "toolJuicer", "listAllmilk", "foodCocoapowder", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bananamilkshakeItem, "toolJuicer", "listAllmilk", "cropBanana", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cornflakesItem, "toolMixingbowl", "listAllmilk", "cropCorn");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.coleslawburgerItem, "toolCuttingboard", "foodHamburger", "foodColeslaw");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.roastchickenItem, "toolBakeware", "listAllchickenraw", "foodSalt", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.roastpotatoesItem, "toolBakeware", "cropPotato", "foodSalt", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sundayroastItem, "toolBakeware", "foodRoastchicken", "foodRoastpotatoes", "listAllgreenveggie");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.bbqpulledporkItem, "toolCuttingboard", "listAllporkcooked", "foodToast", "cropTomato", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.lambwithmintsauceItem, "toolBakeware", "listAllmuttonraw", "cropSpiceleaf", "foodVinegar", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.steakandchipsItem, "toolSkillet", "listAllbeefraw", "foodFries");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cherryicecreamItem, "toolMixingbowl", "listAllicecream", "cropCherry");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pistachioicecreamItem, "toolMixingbowl", "listAllicecream", "cropPistachio");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.neapolitanicecreamItem, 3), "foodChocolateicecream", "foodStrawberryicecream", "foodVanillaicecream");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.spumoniicecreamItem, 3), "foodCherryicecream", "foodPistachioicecream", "foodVanillaicecream");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.plainyogurtItem, 2), "foodPlainyogurt", "listAllmilk");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.almondbutterItem, "toolJuicer", "cropAlmond");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cashewbutterItem, "toolJuicer", "cropCashew");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chestnutbutterItem, "toolJuicer", "cropChestnut");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cornishpastyItem, "toolBakeware", "listAllbeefraw", "cropPotato", "foodDough", "cropRutabaga", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cottagepieItem, "toolBakeware", "listAllbeefraw", "cropPotato", "cropCarrot", "foodDough", "cropPeas");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.croissantItem, "toolBakeware", "foodDough", "foodButter", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.currypowderItem, "toolMortarandpestle", "cropCurryleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.dimsumItem, "toolPot", "cropRice", "foodDough", "cropWaterchestnut", "listAllmushroom", "listAllmeatraw");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.friedpecanokraItem, "toolSkillet", "cropOkra", "cropPecan", "foodOliveoil", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gooseberryjellyItem, "toolSaucepan", "cropGooseberry", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gooseberryjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodGooseberryjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gooseberrymilkshakeItem, "toolJuicer", "listAllmilk", "cropGooseberry", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gooseberrypieItem, "toolBakeware", "cropGooseberry", "listAllsugar", "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gooseberrysmoothieItem, "toolJuicer", "cropGooseberry", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gooseberryyogurtItem, "cropGooseberry", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.hamsweetpicklesandwichItem, "toolCuttingboard", "foodSweetpickle", Items.field_151025_P, "listAllporkcooked", "foodMayo");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.hushpuppiesItem, "toolPot", "foodCornmeal", "listAllegg", "cropOnion", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.kimchiItem, "toolPot", "foodSalt", "cropCabbage", "cropGarlic", "cropGinger", "cropRadish", "cropScallion", "listAllspice", "cropSesame");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mochiItem, "toolMortarandpestle", "cropRice", "listAllsugar", "listAllwater");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.museliItem, "toolMixingbowl", "listAllgrain", "foodRaisins", "cropPecan", "listAllsugar", "listAllmilk");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.naanItem, "toolSkillet", "foodDough", "cropOnion", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.okrachipsItem, "toolBakeware", "cropOkra", "foodSalt", "cropSpiceleaf");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.okracreoleItem, "toolSkillet", "cropOkra", "cropGarlic", "cropTomato", "cropBellpepper", "cropOnion", "listAllspice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pistachiobutterItem, "toolJuicer", "cropPistachio");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.ploughmanslunchItem, "toolCuttingboard", Items.field_151025_P, "cropApple", "foodCheese", "foodSweetpickle", "cropOnion", "listAllporkcooked", "foodBoiledegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.porklomeinItem, "toolPot", "listAllporkraw", "foodPasta", "cropOnion", "cropCarrot", "cropCabbage", "cropGarlic", "foodSoysauce");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.salmonpattiesItem, "toolSkillet", "foodSalmonraw", "foodToast", "listAllegg", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sausageItem, "toolCuttingboard", "listAllmeatraw", "foodSalt", "listAllspice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sausagerollItem, "toolCuttingboard", "foodSausage", "foodDough", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sesameballItem, "toolPot", "cropSesame", "foodOliveoil", "cropBean", "listAllsugar", "foodFlour");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sesamesnapsItem, "toolSkillet", "cropSesame", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.shrimpokrahushpuppiesItem, "toolPot", "foodCornmeal", "listAllegg", "cropOnion", "foodOliveoil", "foodShrimpraw", "cropOkra");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.soysauceItem, "toolJuicer", "cropSoybean", "listAllwater", "foodSalt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sweetpickleItem, "toolPot", "foodVinegar", "foodSalt", "cropSpiceleaf", "cropCucumber", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.veggiestripsItem, "toolBakeware", "listAllveggie", "listAllveggie", "listAllveggie", "foodSalt", "listAllspice");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.vindalooItem, "toolSaucepan", "listAllmeatraw", "foodCurrypowder", "foodButter", "foodBlackpepper", "cropOnion");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.applesmoothieItem, "toolJuicer", "cropApple", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cheeseontoastItem, "toolBakeware", "foodToast", "foodCheese");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chocolaterollItem, "toolBakeware", "foodChocolatebar", "foodFlour", "listAllheavycream");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.coconutcreamItem, "toolPot", "cropCoconut");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.coconutsmoothieItem, "toolJuicer", "cropCoconut", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.crackerItem, "toolBakeware", "foodFlour", "foodOliveoil", "foodSalt", "listAllwater");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cranberrysmoothieItem, "toolJuicer", "cropCranberry", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.cranberryyogurtItem, "cropCranberry", "foodPlainyogurt");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.deluxechickencurryItem, "toolCuttingboard", "foodChickencurry", "cropRice", "foodNaan", "foodMangochutney");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.garammasalaItem, 4), "toolMortarandpestle", "foodBlackpepper", "foodGroundcinnamon", "cropSpiceleaf", "foodGroundnutmeg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.grapesmoothieItem, "toolJuicer", "cropGrape", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.gravyItem, "foodStock", "foodFlour");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.honeysandwichItem, "toolCuttingboard", "listAllnutbutter", ItemRegistry.honeyItem, Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.jamrollItem, "toolBakeware", "foodChocolatebar", "foodFlour", "foodRaspberryjelly");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.mangochutneyItem, "toolPot", "cropMango", "cropSpiceleaf", "cropMustard", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.marzipanItem, "toolMortarandpestle", ItemRegistry.honeyItem, "cropAlmond");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.paneerItem, "toolPot", "listAllmilk", "foodVinegar", "foodLemonaide");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.paneertikkamasalaItem, "toolSaucepan", "foodPaneer", "foodGarammasala", "foodCurrypowder", "foodCoconutcream", "cropOnion", "cropBellpepper", "cropTomato", "cropGinger");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.peaandhamsoupItem, "toolPot", "cropPeas", "listAllporkraw", "cropOnion", "cropCarrot", "cropCelery", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pearjellyItem, "toolSaucepan", "cropPear", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pearjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodPearjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.pearsmoothieItem, "toolJuicer", "cropPear", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.plumjellyItem, "toolSaucepan", "cropPlum", "listAllsugar");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.plumjellysandwichItem, "toolCuttingboard", "listAllnutbutter", "foodPlumjelly", Items.field_151025_P);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.plumsmoothieItem, "toolJuicer", "cropPlum", Items.field_151126_ay);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.potatoandleeksoupItem, "toolPot", "cropPotato", "cropLeek", "foodStock", "listAllheavycream", "cropSpiceleaf", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.toadintheholeItem, "toolBakeware", "foodYorkshirepudding", "foodSausage");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.tunapotatoItem, "toolCuttingboard", "foodButteredpotato", "cropCorn", "listAllfishcooked");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.yorkshirepuddingItem, "toolBakeware", "foodFlour", "foodSalt", "foodStock", "listAllegg", "listAllmilk");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sesameoilItem, "toolJuicer", "cropSesame");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.oliveoilItem, "foodSesameoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.hotandsoursoupItem, "toolSaucepan", "listAllporkraw", "foodSesameoil", "listAllmushroom", "cropBambooshoot", "listAllegg", "foodVinegar", "foodBlackpepper");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.noodlesItem, "toolCuttingboard", "foodDough");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.chickenchowmeinItem, "toolSkillet", "listAllchickenraw", "foodNoodles", "cropOnion", "cropCelery", "cropCarrot", "foodStock");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.kungpaochickenItem, "toolSaucepan", "listAllchickenraw", "cropOrange", "cropGinger", "cropGarlic", "listAllsugar", "foodOliveoil", "cropPeppercorn", "cropPeanut");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.hoisinsauceItem, "toolSaucepan", "cropSweetpotato", "listAllwater", "listAllsugar", "cropSoybean", "cropSesame", "foodVinegar", "cropGarlic", "cropChilipepper");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.fivespiceItem, 5), "toolMortarandpestle", "cropPeppercorn", "cropSpiceleaf", "cropCinnamon", "cropNutmeg", "cropGinger");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.charsiuItem, "toolSaucepan", "listAllporkcooked", "foodHoisinsauce", "foodFivespice", ItemRegistry.honeyItem, "foodSoysauce");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.sweetandsoursauceItem, 5), "toolSaucepan", "foodKetchup", ItemRegistry.honeyItem, "foodVinegar", "foodSoysauce", "cropGinger");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sweetandsourchickenItem, "toolSaucepan", "listAllchickenraw", "foodBatter", "cropPineapple", "cropBellpepper", "cropOnion", "foodSweetandsoursauce", "foodKetchup");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.baconandeggsItem, "toolSkillet", "listAllporkraw", "listAllegg");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.biscuitsandgravyItem, "toolCuttingboard", "foodBiscuit", "foodGravy");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.applefritterItem, "toolPot", "cropApple", "foodDough", "listAllsugar", "foodOliveoil");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.sweetteaItem, "toolPot", "foodTea", "listAllsugar", "cropLemon");
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.creepercookieItem, "toolBakeware", "foodFlour", "listAllegg", "listAllsugar", GeneralOreRegistry.dyeGreen);
        RecipeRegistry.addShapelessOreRecipe(ItemRegistry.patreonpieItem, "toolBakeware", Items.field_151074_bl, "listAllsugar", "foodDough");
    }

    private static void registerMarketRecipe() {
        Item marketRecipeItem;
        switch (HarvestCraft.config.marketblockrecipeItem) {
            case 1: {
                marketRecipeItem = Items.field_151045_i;
                break;
            }
            case 2: {
                marketRecipeItem = Items.field_151043_k;
                break;
            }
            case 3: {
                marketRecipeItem = Items.field_151074_bl;
                break;
            }
            case 4: {
                marketRecipeItem = Items.field_151042_j;
                break;
            }
            case 5: {
                marketRecipeItem = Items.field_151034_e;
                break;
            }
            default: {
                marketRecipeItem = Items.field_151166_bC;
            }
        }
        RecipeRegistry.addShapedOreRecipe(new ItemStack(BlockRegistry.pamMarket, 1), "XOX", "OEO", "XOX", Character.valueOf('X'), "plankWood", Character.valueOf('O'), Blocks.field_150325_L, Character.valueOf('E'), marketRecipeItem);
    }

    private static void registerOtherRecipes() {
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.potItem, true, "X@@", " @@", Character.valueOf('@'), "ingotIron", Character.valueOf('X'), "stickWood");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.skilletItem, true, "@  ", " @ ", "  X", Character.valueOf('@'), "ingotIron", Character.valueOf('X'), "stickWood");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.saucepanItem, true, "@ ", "X ", Character.valueOf('@'), "ingotIron", Character.valueOf('X'), "stickWood");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.bakewareItem, true, "@@@", "@ @", "@@@", Character.valueOf('@'), "ingotBrick");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.cuttingboardItem, true, "@  ", " X ", "  O", Character.valueOf('@'), "ingotIron", Character.valueOf('X'), "stickWood", Character.valueOf('O'), "plankWood");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.mortarandpestleItem, true, "X@X", " X ", Character.valueOf('@'), "stickWood", Character.valueOf('X'), "stone");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.mixingbowlItem, true, "X@X", " X ", Character.valueOf('@'), "stickWood", Character.valueOf('X'), "plankWood");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.juicerItem, true, "@ ", "X ", Character.valueOf('@'), "stone", Character.valueOf('X'), Blocks.field_150456_au);
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.potItem, true, "X@@", " @@", Character.valueOf('@'), "ingotCopper", Character.valueOf('X'), "stickWood");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.skilletItem, true, "@  ", " @ ", "  X", Character.valueOf('@'), "ingotCopper", Character.valueOf('X'), "stickWood");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.saucepanItem, true, "@  ", "X  ", Character.valueOf('@'), "ingotCopper", Character.valueOf('X'), "stickWood");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.cuttingboardItem, true, "@  ", " X ", "  O", Character.valueOf('@'), "ingotCopper", Character.valueOf('X'), "stickWood", Character.valueOf('O'), "plankWood");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.potItem, true, "X@@", " @@", Character.valueOf('@'), "ingotSteel", Character.valueOf('X'), "stickWood");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.skilletItem, true, "@  ", " @ ", "  X", Character.valueOf('@'), "ingotSteel", Character.valueOf('X'), "stickWood");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.saucepanItem, true, "@  ", "X  ", Character.valueOf('@'), "ingotSteel", Character.valueOf('X'), "stickWood");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.cuttingboardItem, true, "@  ", " X ", "  O", Character.valueOf('@'), "ingotSteel", Character.valueOf('X'), "stickWood", Character.valueOf('O'), "plankWood");
        RecipeRegistry.addShapedOreRecipe(ItemRegistry.bakewareItem, true, "@@@", "@ @", "@@@", Character.valueOf('@'), "ingotBrickNether");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack((Block)CropRegistry.getCrop("cotton"), 2), "cropCotton", "cropCotton");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(Items.field_151007_F, 2), "cropCotton", "cropCotton", "cropCotton");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.wovencottonItem, 1), Items.field_151007_F, Items.field_151007_F);
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(ItemRegistry.wovencottonItem, 3), "materialCloth", "materialCloth", "materialCloth");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(Blocks.field_150325_L, 1, 0), "materialCloth", "materialCloth");
        RecipeRegistry.addShapedOreRecipe(new ItemStack((Item)Items.field_151024_Q, 1), "XXX", "X X", Character.valueOf('X'), ItemRegistry.wovencottonItem);
        RecipeRegistry.addShapedOreRecipe(new ItemStack((Item)Items.field_151027_R, 1), "X X", "XXX", "XXX", Character.valueOf('X'), ItemRegistry.wovencottonItem);
        RecipeRegistry.addShapedOreRecipe(new ItemStack((Item)Items.field_151026_S, 1), "XXX", "X X", "X X", Character.valueOf('X'), ItemRegistry.wovencottonItem);
        RecipeRegistry.addShapedOreRecipe(new ItemStack((Item)Items.field_151021_T, 1), "X X", "X X", Character.valueOf('X'), ItemRegistry.wovencottonItem);
        RecipeRegistry.addShapelessOreRecipe(CropRegistry.getSeed("candleberry"), CropRegistry.getFood("candleberry"));
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(Items.field_151123_aH, 1), "foodJellyfishraw");
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(Blocks.field_150428_aP, 1), "cropPumpkin", "blockTorch");
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150344_f, 4, 1), (Object[])new Object[]{new ItemStack((Block)FruitRegistry.getLog("maple"))});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150344_f, 4, 3), (Object[])new Object[]{new ItemStack((Block)FruitRegistry.getLog("paperbark"))});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150344_f, 4, 3), (Object[])new Object[]{new ItemStack((Block)FruitRegistry.getLog("cinnamon"))});
    }

    private static void addShapelessOreRecipe(Block result, Object ... recipe) {
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(result), recipe);
    }

    private static void addShapelessOreRecipe(Item result, Object ... recipe) {
        RecipeRegistry.addShapelessOreRecipe(new ItemStack(result), recipe);
    }

    private static void addShapelessOreRecipe(ItemStack result, Object ... recipe) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(result, recipe));
    }

    private static void addShapedOreRecipe(Block result, Object ... recipe) {
        RecipeRegistry.addShapedOreRecipe(new ItemStack(result), recipe);
    }

    private static void addShapedOreRecipe(Item result, Object ... recipe) {
        RecipeRegistry.addShapedOreRecipe(new ItemStack(result), recipe);
    }

    private static void addShapedOreRecipe(ItemStack result, Object ... recipe) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(result, recipe));
    }

    private static void addSmelting(Item input, Item output) {
        GameRegistry.addSmelting((Item)input, (ItemStack)new ItemStack(output), (float)0.1f);
    }

    private static void addSmelting(Block input, Item output) {
        GameRegistry.addSmelting((Block)input, (ItemStack)new ItemStack(output), (float)0.1f);
    }
}

