/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.config;

import com.pam.harvestcraft.blocks.blocks.BlockBaseGarden;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ConfigHandler {
    private final Configuration config;
    private static final String CATEGORY_GENERAL = "general";
    private static final String CATEGORY_CROPS = "crops";
    private static final String CATEGORY_GARDENS = "gardens";
    private static final String CATEGORY_FRUIT_TREES = "fruit trees";
    private static final String CATEGORY_SALT = "salt";
    private static final String CATEGORY_BEE = "beekeeping";
    private static final String CATEGORY_MARKET_SALES = "market sales";
    private static final String CATEGORY_MARKET_PRICES = "market prices";
    private static final String CATEGORY_MARKET_CURRENCY = "market currency";
    private static final String CATEGORY_CANDLES = "candles";
    private static final String CATEGORY_DIMENSIONS = "dimensions";
    private static final String CATEGORY_SEEDS = "seeds";
    private static final String CATEGORY_MISC_RECIPES = "miscellaneous recipes";
    private static final int defaultCropFoodRestore = 1;
    private static final double defaultSaturationSmall = (double)0.6f;
    private static final double defaultSaturationMeal = (double)1.2f;
    private static final double defaultSaturationMeatyMeal = (double)1.6f;
    public boolean squiddropCalamari;
    public int cropfoodRestore;
    public float cropsaturationRestore;
    public float snacksaturation;
    public float mealsaturation;
    public float meatymealsaturation;
    public int freshmilkfrombucket;
    public int freshwaterfrombucket;
    public boolean enablesaltfromwaterbucketrecipe;
    public int seedrarity;
    public boolean enablecroptoseedRecipe;
    public boolean enableTofuAsMeatInRecipes;
    public boolean enableTofuAsMilkInRecipes;
    public boolean enablelistAllwaterfreshwater;
    public boolean enablelistAllwatervanillawaterbucket;
    public final HashMap<String, Boolean> seedDropFromGrass = new HashMap();
    private final Map<String, String[]> gardenDropConfig = new HashMap<String, String[]>();
    public int gardenRarity;
    public int gardendropAmount;
    public int gardenSpreadMax;
    public boolean enablegardenSpread;
    public int gardenspreadRate;
    public boolean enablearidgardenGeneration;
    public boolean enablefrostgardenGeneration;
    public boolean enabletropicalgardenGeneration;
    public boolean enablewindygardenGeneration;
    public boolean enableshadedgardenGeneration;
    public boolean enablesoggygardenGeneration;
    public int temperatefruittreeRarity;
    public int tropicalfruittreeRarity;
    public int coniferousfruittreeRarity;
    public boolean appletreeGeneration;
    public boolean almondtreeGeneration;
    public boolean apricottreeGeneration;
    public boolean avocadotreeGeneration;
    public boolean bananatreeGeneration;
    public boolean cashewtreeGeneration;
    public boolean cherrytreeGeneration;
    public boolean chestnuttreeGeneration;
    public boolean cinnamontreeGeneration;
    public boolean coconuttreeGeneration;
    public boolean datetreeGeneration;
    public boolean dragonfruittreeGeneration;
    public boolean duriantreeGeneration;
    public boolean figtreeGeneration;
    public boolean grapefruittreeGeneration;
    public boolean lemontreeGeneration;
    public boolean limetreeGeneration;
    public boolean mapletreeGeneration;
    public boolean mangotreeGeneration;
    public boolean nutmegtreeGeneration;
    public boolean olivetreeGeneration;
    public boolean orangetreeGeneration;
    public boolean papayatreeGeneration;
    public boolean paperbarktreeGeneration;
    public boolean peachtreeGeneration;
    public boolean peartreeGeneration;
    public boolean pecantreeGeneration;
    public boolean peppercorntreeGeneration;
    public boolean persimmontreeGeneration;
    public boolean pistachiotreeGeneration;
    public boolean plumtreeGeneration;
    public boolean pomegranatetreeGeneration;
    public boolean starfruittreeGeneration;
    public boolean vanillabeantreeGeneration;
    public boolean walnuttreeGeneration;
    public boolean gooseberrytreeGeneration;
    public boolean enablecropspecialplanting;
    public boolean marketsellSeeds;
    public boolean marketselltemperateSaplings;
    public boolean marketselltropicalSaplings;
    public boolean marketsellconiferousSaplings;
    public boolean marketsellPig;
    public boolean marketsellSheep;
    public boolean marketsellCow;
    public boolean marketsellChicken;
    public boolean marketsellHorse;
    public boolean marketsellBonemeal;
    public int marketblockrecipeItem;
    public int marketseedPrice;
    public int marketsaplingPrice;
    public int marketpigPrice;
    public int marketsheepPrice;
    public int marketcowPrice;
    public int marketchickenPrice;
    public int markethorsePrice;
    public int marketbonemealPrice;
    public int marketcurrencySeeds;
    public int marketcurrencytemperateSaplings;
    public int marketcurrencytropicalSaplings;
    public int marketcurrencyconiferousSaplings;
    public int marketcurrencyPig;
    public int marketcurrencySheep;
    public int marketcurrencyCow;
    public int marketcurrencyChicken;
    public int marketcurrencyHorse;
    public int marketcurrencyBonemeal;
    public boolean enableEasyHarvest;
    public boolean enableBeehiveGeneration;
    public int beehiveRarity;

    public ConfigHandler(Configuration config) {
        this.config = config;
        this.initSettings();
    }

    private void initSettings() {
        this.config.load();
        this.initGeneralSettings();
        this.initCropSettings();
        this.initSeedDropSettings();
        this.initFoodTreesSettings();
        this.initGardenSettings();
        this.initMarketSettings();
        this.initBeesSettings();
        this.initMiscRecipesSettings();
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    private void initBeesSettings() {
        this.enableBeehiveGeneration = this.config.getBoolean(CATEGORY_BEE, "enableBeehiveGeneration", true, "Enable generation of beehives.");
        this.beehiveRarity = this.config.getInt(CATEGORY_BEE, "beehiveRarity", 10, 0, Short.MAX_VALUE, "The higher the value, the more beehives are generated.");
    }

    private void initGeneralSettings() {
        this.squiddropCalamari = this.config.get(CATEGORY_GENERAL, "squiddropCalamari", true).getBoolean();
        this.enableEasyHarvest = this.config.getBoolean("enableEasyHarvest", CATEGORY_GENERAL, true, "Enables harvesting by right-clicking.");
    }

    private void initCropSettings() {
        this.cropfoodRestore = this.config.get(CATEGORY_CROPS, "cropfoodRestore", 1).getInt();
        this.cropsaturationRestore = (float)this.config.get(CATEGORY_CROPS, "cropsaturationRestore", (double)0.6f).getDouble();
        this.snacksaturation = (float)this.config.get(CATEGORY_CROPS, "snacksaturation", (double)0.6f).getDouble();
        this.mealsaturation = (float)this.config.get(CATEGORY_CROPS, "mealsaturation", (double)1.2f).getDouble();
        this.meatymealsaturation = (float)this.config.get(CATEGORY_CROPS, "meatymealsaturation", (double)1.6f).getDouble();
        this.enablecropspecialplanting = this.config.get(CATEGORY_CROPS, "enablecropspecialplanting", true).getBoolean();
    }

    private void initFoodTreesSettings() {
        this.temperatefruittreeRarity = this.config.get(CATEGORY_FRUIT_TREES, "temperatefruittreeRarity", 48).getInt();
        this.tropicalfruittreeRarity = this.config.get(CATEGORY_FRUIT_TREES, "tropicalfruittreeRarity", 64).getInt();
        this.coniferousfruittreeRarity = this.config.get(CATEGORY_FRUIT_TREES, "coniferousfruittreeRarity", 48).getInt();
        this.appletreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "appletreeGeneration", true).getBoolean();
        this.almondtreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "almondtreeGeneration", true).getBoolean();
        this.apricottreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "apricottreeGeneration", true).getBoolean();
        this.avocadotreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "avocadotreeGeneration", true).getBoolean();
        this.bananatreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "bananatreeGeneration", true).getBoolean();
        this.cashewtreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "cashewtreeGeneration", true).getBoolean();
        this.cherrytreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "cherrytreeGeneration", true).getBoolean();
        this.chestnuttreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "chestnuttreeGeneration", true).getBoolean();
        this.cinnamontreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "cinnamontreeGeneration", true).getBoolean();
        this.coconuttreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "coconuttreeGeneration", true).getBoolean();
        this.datetreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "datetreeGeneration", true).getBoolean();
        this.dragonfruittreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "dragonfruittreeGeneration", true).getBoolean();
        this.duriantreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "duriantreeGeneration", true).getBoolean();
        this.figtreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "figtreeGeneration", true).getBoolean();
        this.grapefruittreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "grapefruittreeGeneration", true).getBoolean();
        this.lemontreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "lemontreeGeneration", true).getBoolean();
        this.limetreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "limetreeGeneration", true).getBoolean();
        this.mapletreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "mapletreeGeneration", true).getBoolean();
        this.mangotreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "mangotreeGeneration", true).getBoolean();
        this.nutmegtreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "nutmegtreeGeneration", true).getBoolean();
        this.olivetreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "olivetreeGeneration", true).getBoolean();
        this.orangetreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "orangetreeGeneration", true).getBoolean();
        this.papayatreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "papayatreeGeneration", true).getBoolean();
        this.paperbarktreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "paperbarktreeGeneration", true).getBoolean();
        this.peachtreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "peachtreeGeneration", true).getBoolean();
        this.peartreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "peartreeGeneration", true).getBoolean();
        this.pecantreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "pecantreeGeneration", true).getBoolean();
        this.peppercorntreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "peppercorntreeGeneration", true).getBoolean();
        this.persimmontreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "persimmontreeGeneration", true).getBoolean();
        this.pistachiotreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "pistachiotreeGeneration", true).getBoolean();
        this.plumtreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "plumtreeGeneration", true).getBoolean();
        this.pomegranatetreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "pomegranatetreeGeneration", true).getBoolean();
        this.starfruittreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "starfruittreeGeneration", true).getBoolean();
        this.vanillabeantreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "vanillabeantreeGeneration", true).getBoolean();
        this.walnuttreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "walnuttreeGeneration", true).getBoolean();
        this.gooseberrytreeGeneration = this.config.get(CATEGORY_FRUIT_TREES, "gooseberrytreeGeneration", true).getBoolean();
    }

    private void initGardenSettings() {
        this.gardenRarity = this.config.get(CATEGORY_GARDENS, "gardenRarity", 2).getInt();
        this.gardendropAmount = this.config.get(CATEGORY_GARDENS, "gardendropAmount", 3).getInt();
        this.enablegardenSpread = this.config.get(CATEGORY_GARDENS, "enablegardenSpread", true).getBoolean();
        this.gardenspreadRate = this.config.getInt("gardenSpreadRate", CATEGORY_GARDENS, 30, 1, 100, "Garden spread rate. 100 means a garden spawns every tick. 1 means a garden spawns with a probability of 1% per tick.");
        this.gardenSpreadMax = this.config.get(CATEGORY_GARDENS, "gardenspreadMax", 8).getInt();
        this.enablearidgardenGeneration = this.config.get(CATEGORY_GARDENS, "enablearidgardenGeneration", true).getBoolean();
        this.enablefrostgardenGeneration = this.config.get(CATEGORY_GARDENS, "enablefrostgardenGeneration", true).getBoolean();
        this.enabletropicalgardenGeneration = this.config.get(CATEGORY_GARDENS, "enabletropicalgardenGeneration", true).getBoolean();
        this.enablewindygardenGeneration = this.config.get(CATEGORY_GARDENS, "enablewindygardenGeneration", true).getBoolean();
        this.enableshadedgardenGeneration = this.config.get(CATEGORY_GARDENS, "enableshadedgardenGeneration", true).getBoolean();
        this.enablesoggygardenGeneration = this.config.get(CATEGORY_GARDENS, "enablesoggygardenGeneration", true).getBoolean();
        this.gardenDropConfig.put("aridGarden", this.config.getStringList("aridGarden", "drops", new String[]{"harvestcraft:cactusfruitItem"}, ""));
        this.gardenDropConfig.put("frostGarden", this.config.getStringList("frostGarden", "drops", new String[]{"harvestcraft:raspberryItem", "harvestcraft:oatsItem", "harvestcraft:ryeItem", "harvestcraft:celeryItem", "harvestcraft:peasItem", "harvestcraft:beetItem", "harvestcraft:rutabagaItem", "harvestcraft:broccoliItem", "harvestcraft:cauliflowerItem", "harvestcraft:cabbageItem", "harvestcraft:spinachItem", "harvestcraft:cottonItem"}, ""));
        this.gardenDropConfig.put("shadedGarden", this.config.getStringList("shadedGarden", "drops", new String[]{"harvestcraft:whitemushroomItem", "harvestcraft:blackberryItem", "harvestcraft:zucchiniItem", "harvestcraft:radishItem", "harvestcraft:rhubarbItem", "harvestcraft:tealeafItem", "harvestcraft:garlicItem", "harvestcraft:sweetpotatoItem", "harvestcraft:turnipItem", "harvestcraft:spiceleafItem", "harvestcraft:beanItem", "harvestcraft:leekItem", "harvestcraft:scallionItem", "harvestcraft:tomatoItem", "harvestcraft:cottonItem"}, ""));
        this.gardenDropConfig.put("soggyGarden", this.config.getStringList("soggyGarden", "drops", new String[]{"harvestcraft:brusselsproutItem", "harvestcraft:spiceleafItem", "harvestcraft:blueberryItem", "harvestcraft:asparagusItem", "harvestcraft:cranberryItem", "harvestcraft:riceItem", "harvestcraft:seaweedItem", "harvestcraft:waterchestnutItem", "harvestcraft:okraItem", "harvestcraft:cottonItem"}, ""));
        this.gardenDropConfig.put("tropicalGarden", this.config.getStringList("tropicalGarden", "drops", new String[]{"harvestcraft:grapeItem", "harvestcraft:pineappleItem", "harvestcraft:kiwiItem", "harvestcraft:sesameseedsItem", "harvestcraft:curryleafItem", "harvestcraft:bambooshootItem", "harvestcraft:cantaloupeItem", "harvestcraft:gingerItem", "harvestcraft:coffeebeanItem", "harvestcraft:soybeanItem", "harvestcraft:eggplantItem", "harvestcraft:cottonItem"}, ""));
        this.gardenDropConfig.put("windyGarden", this.config.getStringList("windyGarden", "drops", new String[]{"harvestcraft:strawberryItem", "harvestcraft:barleyItem", "harvestcraft:cornItem", "harvestcraft:cucumberItem", "harvestcraft:wintersquashItem", "harvestcraft:mustardseedsItem", "harvestcraft:onionItem", "harvestcraft:parsnipItem", "harvestcraft:peanutItem", "minecraft:potato", "minecraft:carrot", "harvestcraft:lettuceItem", "harvestcraft:artichokeItem", "harvestcraft:bellpepperItem", "harvestcraft:chilipepperItem", "minecraft:wheat", "harvestcraft:cottonItem"}, ""));
    }

    private void initMarketSettings() {
        this.marketsellSeeds = this.config.get(CATEGORY_MARKET_SALES, "marketsellSeeds", true).getBoolean();
        this.marketselltemperateSaplings = this.config.get(CATEGORY_MARKET_SALES, "marketselltemperateSaplings", true).getBoolean();
        this.marketselltropicalSaplings = this.config.get(CATEGORY_MARKET_SALES, "marketselltropicalSaplings", true).getBoolean();
        this.marketsellconiferousSaplings = this.config.get(CATEGORY_MARKET_SALES, "marketsellconiferousSaplings", true).getBoolean();
        this.marketsellPig = this.config.get(CATEGORY_MARKET_SALES, "marketsellPig", true).getBoolean();
        this.marketsellSheep = this.config.get(CATEGORY_MARKET_SALES, "marketsellSheep", true).getBoolean();
        this.marketsellCow = this.config.get(CATEGORY_MARKET_SALES, "marketsellCow", true).getBoolean();
        this.marketsellChicken = this.config.get(CATEGORY_MARKET_SALES, "marketsellChicken", true).getBoolean();
        this.marketsellHorse = this.config.get(CATEGORY_MARKET_SALES, "marketsellHorse", true).getBoolean();
        this.marketsellBonemeal = this.config.get(CATEGORY_MARKET_SALES, "marketsellBonemeal", true).getBoolean();
        this.marketseedPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketseedPrice", 1).getInt();
        this.marketsaplingPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketsaplingPrice", 3).getInt();
        this.marketpigPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketpigPrice", 6).getInt();
        this.marketsheepPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketsheepPrice", 6).getInt();
        this.marketcowPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketcowPrice", 9).getInt();
        this.marketchickenPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketchickenPrice", 3).getInt();
        this.markethorsePrice = this.config.get(CATEGORY_MARKET_PRICES, "markethorsePrice", 12).getInt();
        this.marketbonemealPrice = this.config.get(CATEGORY_MARKET_PRICES, "marketbonemealPrice", 3).getInt();
        this.marketcurrencySeeds = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencySeeds", 0).getInt();
        this.marketcurrencytemperateSaplings = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencytemperateSaplings", 0).getInt();
        this.marketcurrencytropicalSaplings = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencytropicalSaplings", 0).getInt();
        this.marketcurrencyconiferousSaplings = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyconiferousSaplings", 0).getInt();
        this.marketcurrencyPig = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyPig", 0).getInt();
        this.marketcurrencySheep = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencySheep", 0).getInt();
        this.marketcurrencyCow = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyCow", 0).getInt();
        this.marketcurrencyChicken = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyChicken", 0).getInt();
        this.marketcurrencyHorse = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyHorse", 0).getInt();
        this.marketcurrencyBonemeal = this.config.get(CATEGORY_MARKET_CURRENCY, "marketcurrencyBonemeal", 0).getInt();
    }

    private void initSeedDropSettings() {
        this.seedrarity = this.config.get(CATEGORY_SEEDS, "seedrarity", 1).getInt();
        this.initSeedDropFromGrassSetting("asparagusseeddropfromgrass", "asparagus");
        this.initSeedDropFromGrassSetting("barleyseeddropfromgrass", "barley");
        this.initSeedDropFromGrassSetting("beanseeddropfromgrass", "bean");
        this.initSeedDropFromGrassSetting("beetseeddropfromgrass", "beet");
        this.initSeedDropFromGrassSetting("broccoliseeddropfromgrass", "broccoli");
        this.initSeedDropFromGrassSetting("cauliflowerseeddropfromgrass", "cauliflower");
        this.initSeedDropFromGrassSetting("celeryseeddropfromgrass", "celery");
        this.initSeedDropFromGrassSetting("cranberryseeddropfromgrass", "cranberry");
        this.initSeedDropFromGrassSetting("garlicseeddropfromgrass", "garlic");
        this.initSeedDropFromGrassSetting("gingerseeddropfromgrass", "ginger");
        this.initSeedDropFromGrassSetting("leekseeddropfromgrass", "leek");
        this.initSeedDropFromGrassSetting("lettuceseeddropfromgrass", "lettuce");
        this.initSeedDropFromGrassSetting("oatsseeddropfromgrass", "oats");
        this.initSeedDropFromGrassSetting("onionseeddropfromgrass", "onion");
        this.initSeedDropFromGrassSetting("parsnipseeddropfromgrass", "parsnip");
        this.initSeedDropFromGrassSetting("peanutseeddropfromgrass", "peanut");
        this.initSeedDropFromGrassSetting("pineappleseeddropfromgrass", "pineapple");
        this.initSeedDropFromGrassSetting("radishseeddropfromgrass", "radish");
        this.initSeedDropFromGrassSetting("riceseeddropfromgrass", "rice");
        this.initSeedDropFromGrassSetting("rutabagaseeddropfromgrass", "rutabaga");
        this.initSeedDropFromGrassSetting("ryeseeddropfromgrass", "rye");
        this.initSeedDropFromGrassSetting("scallionseeddropfromgrass", "scallion");
        this.initSeedDropFromGrassSetting("soybeanseeddropfromgrass", "soybean");
        this.initSeedDropFromGrassSetting("spiceleafseeddropfromgrass", "spiceleaf");
        this.initSeedDropFromGrassSetting("sweetpotatoseeddropfromgrass", "sweetpotato");
        this.initSeedDropFromGrassSetting("teaseeddropfromgrass", "tealeaf");
        this.initSeedDropFromGrassSetting("turnipseeddropfromgrass", "turnip");
        this.initSeedDropFromGrassSetting("whitemushroomseeddropfromgrass", "whitemushroom");
        this.initSeedDropFromGrassSetting("artichokeseeddropfromgrass", "artichoke");
        this.initSeedDropFromGrassSetting("bellpepperseeddropfromgrass", "bellpepper");
        this.initSeedDropFromGrassSetting("blackberryseeddropfromgrass", "blackberry");
        this.initSeedDropFromGrassSetting("blueberryseeddropfromgrass", "blueberry");
        this.initSeedDropFromGrassSetting("brusselsproutseeddropfromgrass", "brusselsprout");
        this.initSeedDropFromGrassSetting("cabbageseeddropfromgrass", "cabbage");
        this.initSeedDropFromGrassSetting("cactusfruitseeddropfromgrass", "cactusfruit");
        this.initSeedDropFromGrassSetting("candleberryseeddropfromgrass", "candleberry");
        this.initSeedDropFromGrassSetting("cantaloupeseeddropfromgrass", "cantaloupe");
        this.initSeedDropFromGrassSetting("chilipepperseeddropfromgrass", "chilipepper");
        this.initSeedDropFromGrassSetting("coffeeseeddropfromgrass", "coffeebean");
        this.initSeedDropFromGrassSetting("cornseeddropfromgrass", "corn");
        this.initSeedDropFromGrassSetting("cottonseeddropfromgrass", "cotton");
        this.initSeedDropFromGrassSetting("cucumberseeddropfromgrass", "cucumber");
        this.initSeedDropFromGrassSetting("eggplantseeddropfromgrass", "eggplant");
        this.initSeedDropFromGrassSetting("grapeseeddropfromgrass", "grape");
        this.initSeedDropFromGrassSetting("kiwiseeddropfromgrass", "kiwi");
        this.initSeedDropFromGrassSetting("mustardseeddropfromgrass", "mustardseeds");
        this.initSeedDropFromGrassSetting("okraseeddropfromgrass", "okra");
        this.initSeedDropFromGrassSetting("peasseeddropfromgrass", "peas");
        this.initSeedDropFromGrassSetting("raspberryseeddropfromgrass", "raspberry");
        this.initSeedDropFromGrassSetting("rhubarbseeddropfromgrass", "rhubarb");
        this.initSeedDropFromGrassSetting("seaweedseeddropfromgrass", "seaweed");
        this.initSeedDropFromGrassSetting("strawberryseeddropfromgrass", "strawberry");
        this.initSeedDropFromGrassSetting("tomatoseeddropfromgrass", "tomato");
        this.initSeedDropFromGrassSetting("wintersquashseeddropfromgrass", "wintersquash");
        this.initSeedDropFromGrassSetting("zucchiniseeddropfromgrass", "zucchini");
        this.initSeedDropFromGrassSetting("bambooshootseeddropfromgrass", "bambooshoot");
        this.initSeedDropFromGrassSetting("spinachseeddropfromgrass", "spinach");
        this.initSeedDropFromGrassSetting("curryleafseeddropfromgrass", "curryleaf");
        this.initSeedDropFromGrassSetting("sesameseedsseeddropfromgrass", "sesameseeds");
        this.initSeedDropFromGrassSetting("waterchestnutseeddropfromgrass", "waterchestnut");
    }

    private void initMiscRecipesSettings() {
        this.freshmilkfrombucket = this.config.get(CATEGORY_MISC_RECIPES, "freshmilkfrombucket", 4).getInt();
        this.freshwaterfrombucket = this.config.get(CATEGORY_MISC_RECIPES, "freshwaterfrombucket", 1).getInt();
        this.enablesaltfromwaterbucketrecipe = this.config.get(CATEGORY_MISC_RECIPES, "enablesaltfromwaterbucketrecipe", true).getBoolean();
        this.enablecroptoseedRecipe = this.config.get(CATEGORY_MISC_RECIPES, "enablecroptoseedRecipe", true).getBoolean();
        this.enableTofuAsMeatInRecipes = this.config.get(CATEGORY_MISC_RECIPES, "enabletofuasmeatinRecipes", true).getBoolean();
        this.enableTofuAsMilkInRecipes = this.config.get(CATEGORY_MISC_RECIPES, "enabletofuasmilkinRecipes", true).getBoolean();
        this.enablelistAllwaterfreshwater = this.config.get(CATEGORY_MISC_RECIPES, "enablelistAllwaterfreshwater", true).getBoolean();
        this.enablelistAllwatervanillawaterbucket = this.config.get(CATEGORY_MISC_RECIPES, "enablelistAllwatervanillawaterbucket", true).getBoolean();
        this.marketblockrecipeItem = this.config.get(CATEGORY_MISC_RECIPES, "marketblockrecipeItem", 0).getInt();
    }

    private void initSeedDropFromGrassSetting(String key, String item) {
        boolean doDrop = this.config.get(CATEGORY_SEEDS, key, false).getBoolean();
        this.seedDropFromGrass.put(item, doDrop);
    }

    public void configureGardenDrops() {
        Pattern ITEM_STACK_PATTERN = Pattern.compile("(?:([0-9]+)x)?([\\w:]+)(?:[@:]([0-9]+))?");
        Matcher ITEM_STACK_MATCHER = ITEM_STACK_PATTERN.matcher("");
        for (String garden : this.gardenDropConfig.keySet()) {
            String[] itemNames;
            FMLLog.info((String)"Registering drops for %s.", (Object[])new Object[]{garden});
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (String baseItemName : itemNames = this.gardenDropConfig.get(garden)) {
                ItemStack drop;
                ITEM_STACK_MATCHER.reset(baseItemName);
                if (!ITEM_STACK_MATCHER.find()) continue;
                String itemName = ITEM_STACK_MATCHER.group(2);
                int metadata = 0;
                if (ITEM_STACK_MATCHER.group(3) != null) {
                    metadata = Integer.parseInt(ITEM_STACK_MATCHER.group(3));
                }
                int stackSize = 1;
                if (ITEM_STACK_MATCHER.group(1) != null) {
                    stackSize = Integer.parseInt(ITEM_STACK_MATCHER.group(1));
                }
                if ((drop = GameRegistry.makeItemStack((String)itemName, (int)metadata, (int)stackSize, null)) != null) {
                    drops.add(drop);
                    continue;
                }
                FMLLog.severe((String)"Unable to find item %s to add to this garden.", (Object[])new Object[]{baseItemName});
            }
            BlockBaseGarden.drops.put(garden, drops);
        }
    }
}

