/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.blocks;

import com.pam.harvestcraft.blocks.blocks.ApiaryBlock;
import com.pam.harvestcraft.blocks.blocks.BeehiveBlock;
import com.pam.harvestcraft.blocks.blocks.BlockBaseGarden;
import com.pam.harvestcraft.blocks.blocks.BlockPamMarket;
import com.pam.harvestcraft.blocks.blocks.PresserBlock;
import com.pam.harvestcraft.item.ItemRegistry;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public final class BlockRegistry {
    public static final String marketItemName = "market";
    public static Block pamMarket;
    public static ItemBlock marketItemBlock;
    public static BeehiveBlock beehive;
    public static ItemBlock beehiveItemBlock;
    public static ApiaryBlock apiary;
    public static ItemBlock apiaryItemBlock;
    public static PresserBlock presser;
    public static ItemBlock presserItemBlock;
    public static final HashMap<String, BlockBaseGarden> gardens;
    public static final String aridGarden = "aridGarden";
    public static final String frostGarden = "frostGarden";
    public static final String tropicalGarden = "tropicalGarden";
    public static final String windyGarden = "windyGarden";
    public static final String shadedGarden = "shadedGarden";
    public static final String soggyGarden = "soggyGarden";
    private static boolean initialized;

    public static void initBlockRegistry() {
        BlockRegistry.registerMarket();
        BlockRegistry.registerBeeFeatures();
        BlockRegistry.registerGardens();
        BlockRegistry.registerPresser();
        initialized = true;
    }

    public static BlockBaseGarden getGarden(String gardenName) {
        if (!initialized) {
            FMLLog.bigWarning((String)"BlockRegistry has not been initialized yet.", (Object[])new Object[0]);
            return null;
        }
        if (!gardens.containsKey(gardenName)) {
            FMLLog.bigWarning((String)"Garden %s is not registered.", (Object[])new Object[]{gardenName});
            return null;
        }
        return gardens.get(gardenName);
    }

    private static void registerPresser() {
        presser = new PresserBlock();
        presserItemBlock = new ItemBlock((Block)presser);
        ItemRegistry.items.put("presser", (Item)presserItemBlock);
        BlockRegistry.registerBlock("presser", presserItemBlock, (Block)presser);
    }

    private static void registerBeeFeatures() {
        beehive = new BeehiveBlock();
        beehiveItemBlock = new ItemBlock((Block)beehive);
        ItemRegistry.items.put("beehive", (Item)beehiveItemBlock);
        BlockRegistry.registerBlock("beehive", beehiveItemBlock, beehive);
        apiary = new ApiaryBlock();
        apiaryItemBlock = new ItemBlock((Block)apiary);
        ItemRegistry.items.put("apiary", (Item)apiaryItemBlock);
        BlockRegistry.registerBlock("apiary", apiaryItemBlock, (Block)apiary);
    }

    private static void registerMarket() {
        pamMarket = new BlockPamMarket().func_149711_c(1.0f).func_149752_b(1.0f);
        marketItemBlock = new ItemBlock(pamMarket);
        ItemRegistry.items.put(marketItemName, (Item)marketItemBlock);
        BlockRegistry.registerBlock(marketItemName, marketItemBlock, pamMarket);
    }

    private static void registerGardens() {
        BlockRegistry.addGarden(aridGarden, BlockBaseGarden.Region.DESERT);
        BlockRegistry.addGarden(frostGarden, BlockBaseGarden.Region.PLAINS);
        BlockRegistry.addGarden(shadedGarden, BlockBaseGarden.Region.PLAINS);
        BlockRegistry.addGarden(soggyGarden, BlockBaseGarden.Region.PLAINS);
        BlockRegistry.addGarden(tropicalGarden, BlockBaseGarden.Region.PLAINS);
        BlockRegistry.addGarden(windyGarden, BlockBaseGarden.Region.PLAINS);
    }

    private static void addGarden(String gardenName, BlockBaseGarden.Region region) {
        BlockBaseGarden garden = new BlockBaseGarden(gardenName, region);
        gardens.put(gardenName, garden);
    }

    public static void registerBlock(String registerName, ItemBlock itemBlock, Block block) {
        block.setRegistryName(registerName);
        block.func_149663_c(registerName);
        GameRegistry.register((IForgeRegistryEntry)block);
        itemBlock.setRegistryName(registerName);
        itemBlock.func_77655_b(registerName);
        GameRegistry.register((IForgeRegistryEntry)itemBlock);
    }

    public static void registerBlock(String registerName, Block block) {
        ItemBlock itemBlock = new ItemBlock(block);
        BlockRegistry.registerBlock(registerName, itemBlock, block);
    }

    static {
        gardens = new HashMap();
        initialized = false;
    }
}

