/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.cbcore;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.Language;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LangUtil {
    public static LangUtil instance = new LangUtil(null);
    public String prefix;

    public LangUtil(String prefix) {
        this.prefix = prefix;
    }

    public static String translateG(String s, Object ... format) {
        return instance.translate(s, format);
    }

    public String translate(String s, Object ... format) {
        String ret;
        if (this.prefix != null && !s.startsWith(this.prefix + ".")) {
            s = this.prefix + "." + s;
        }
        if ((ret = I18n.func_74838_a((String)s)).length() == 0) {
            ret = I18n.func_74838_a((String)s);
        }
        if (ret.length() == 0) {
            ret = I18n.func_74838_a((String)s);
        }
        if (ret.length() == 0) {
            return s;
        }
        if (format.length > 0) {
            ret = String.format(ret, format);
        }
        return ret;
    }

    public void addLangFile(InputStream resource, String lang) throws IOException {
        String read;
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource, "UTF-8"));
        while ((read = reader.readLine()) != null) {
            int equalIndex = read.indexOf(61);
            if (equalIndex == -1) continue;
            String key = read.substring(0, equalIndex);
            String value = read.substring(equalIndex + 1);
            if (this.prefix == null) continue;
            key = this.prefix + "." + key;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static LangUtil loadLangDir(String domain) {
        return new LangUtil(domain).addLangDir(new ResourceLocation(domain, "lang"));
    }

    @SideOnly(value=Side.CLIENT)
    public LangUtil addLangDir(ResourceLocation dir) {
        IResourceManager resManager = Minecraft.func_71410_x().func_110442_L();
        for (Language lang : Minecraft.func_71410_x().func_135016_M().func_135040_d()) {
            IResource langRes;
            String langID = lang.func_135034_a();
            try {
                langRes = resManager.func_110536_a(new ResourceLocation(dir.func_110624_b(), dir.func_110623_a() + '/' + langID + ".lang"));
            }
            catch (Exception e) {
                continue;
            }
            try {
                this.addLangFile(langRes.func_110527_b(), langID);
            }
            catch (IOException e) {
                System.err.println("Failed to load lang resource. domain=" + this.prefix + ", resource=" + langRes);
                e.printStackTrace();
            }
        }
        return this;
    }
}

