/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.vanillamc;

import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.cbcore.LangUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HUDHandlerVanilla
implements IWailaDataProvider {
    static List<Block> removemetadata = new ArrayList<Block>(){
        {
            this.add(Blocks.field_150320_F);
            this.add(Blocks.field_150331_J);
            this.add(Blocks.field_150335_W);
            this.add(Blocks.field_150442_at);
            this.add(Blocks.field_150431_aC);
            this.add(Blocks.field_150434_aF);
            this.add(Blocks.field_150423_aK);
            this.add(Blocks.field_150428_aP);
            this.add(Blocks.field_150420_aW);
            this.add(Blocks.field_150419_aX);
            this.add(Blocks.field_150395_bd);
            this.add(Blocks.field_150378_br);
            this.add(Blocks.field_150407_cf);
            this.add(Blocks.field_185764_cQ);
            this.add(Blocks.field_185771_cX);
            this.add(Blocks.field_185766_cS);
            this.add(Blocks.field_185768_cU);
            this.add(Blocks.field_150479_bC);
        }
    };
    static Block mobSpawner = Blocks.field_150474_ac;
    static Block crops = Blocks.field_150464_aj;
    static Block farmland = Blocks.field_150458_ak;
    static Block melonStem = Blocks.field_150394_bc;
    static Block pumpkinStem = Blocks.field_150393_bb;
    static Block carrot = Blocks.field_150459_bM;
    static Block potato = Blocks.field_150469_bN;
    static Block lever = Blocks.field_150442_at;
    static Block repeaterIdle = Blocks.field_150413_aR;
    static Block repeaterActv = Blocks.field_150416_aS;
    static Block comparatorIdl = Blocks.field_150441_bU;
    static Block comparatorAct = Blocks.field_150455_bV;
    static Block redstone = Blocks.field_150488_af;
    static Block jukebox = Blocks.field_150421_aI;
    static Block cocoa = Blocks.field_150375_by;
    static Block netherwart = Blocks.field_150388_bm;
    static Block silverfish = Blocks.field_150418_aU;
    static Block doubleplant = Blocks.field_150398_cm;
    static Block leave = Blocks.field_150362_t;
    static Block leave2 = Blocks.field_150361_u;
    static Block log = Blocks.field_150364_r;
    static Block log2 = Blocks.field_150363_s;
    static Block quartz = Blocks.field_150371_ca;
    static Block sapling = Blocks.field_150345_g;
    static Block stickypiston = Blocks.field_150320_F;
    static Block piston = Blocks.field_150331_J;
    static Block pistonhead = Blocks.field_150332_K;
    static Block stoneslab = Blocks.field_150333_U;
    static Block doublestoneslab = Blocks.field_150334_T;
    static Block woodenslab = Blocks.field_150376_bx;
    static Block doublewoodenslab = Blocks.field_150373_bw;
    static Block flowerpot = Blocks.field_150457_bL;
    static Block anvil = Blocks.field_150467_bQ;
    static Block stoneslab2 = Blocks.field_180389_cP;
    static Block doublestoneslab2 = Blocks.field_180388_cO;

    @Override
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        BlockFlowerPot.EnumFlowerType variant;
        int z;
        int y;
        int x;
        Block block = accessor.getBlock();
        if (block == silverfish && config.getConfig("vanilla.silverfish")) {
            int metadata = accessor.getMetadata();
            switch (metadata) {
                case 0: {
                    return new ItemStack(Blocks.field_150348_b);
                }
                case 1: {
                    return new ItemStack(Blocks.field_150347_e);
                }
                case 2: {
                    return new ItemStack(Blocks.field_150336_V);
                }
            }
            return null;
        }
        if (block == redstone) {
            return new ItemStack(Items.field_151137_ax);
        }
        if (block == doubleplant && (accessor.getMetadata() & 8) != 0) {
            x = accessor.getPosition().func_177958_n();
            y = accessor.getPosition().func_177956_o() - 1;
            z = accessor.getPosition().func_177952_p();
            if (accessor.getWorld().func_180495_p(new BlockPos(x, y, z)) != Blocks.field_150398_cm) {
                ++y;
            }
            variant = (BlockDoublePlant.EnumPlantType)accessor.getWorld().func_180495_p(new BlockPos(x, y, z)).func_177229_b((IProperty)BlockDoublePlant.field_176493_a);
            switch (2.$SwitchMap$net$minecraft$block$BlockDoublePlant$EnumPlantType[variant.ordinal()]) {
                case 1: {
                    return new ItemStack(doubleplant, 1, 3);
                }
                case 2: {
                    return new ItemStack(doubleplant, 1, 2);
                }
                case 3: {
                    return new ItemStack(doubleplant, 1, 5);
                }
                case 4: {
                    return new ItemStack(doubleplant, 1, 4);
                }
                case 5: {
                    return new ItemStack(doubleplant, 1, 0);
                }
                case 6: {
                    return new ItemStack(doubleplant, 1, 1);
                }
            }
        }
        if (block == flowerpot) {
            x = accessor.getPosition().func_177958_n();
            y = accessor.getPosition().func_177956_o();
            z = accessor.getPosition().func_177952_p();
            if (!accessor.getWorld().func_180495_p(new BlockPos(x, y, z)).func_177227_a().contains(BlockFlowerPot.field_176443_b)) {
                return new ItemStack(Blocks.field_150457_bL, 1, accessor.getMetadata());
            }
            variant = (BlockFlowerPot.EnumFlowerType)accessor.getWorld().func_180495_p(new BlockPos(x, y, z)).func_177229_b((IProperty)BlockFlowerPot.field_176443_b);
            switch (variant) {
                case ACACIA_SAPLING: {
                    return new ItemStack(Blocks.field_150345_g, 1, 4);
                }
                case ALLIUM: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 2);
                }
                case BIRCH_SAPLING: {
                    return new ItemStack(Blocks.field_150345_g, 1, 2);
                }
                case BLUE_ORCHID: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 1);
                }
                case CACTUS: {
                    return new ItemStack((Block)Blocks.field_150434_aF, 1, 0);
                }
                case DANDELION: {
                    return new ItemStack((Block)Blocks.field_150327_N, 1, 0);
                }
                case DARK_OAK_SAPLING: {
                    return new ItemStack(Blocks.field_150345_g, 1, 5);
                }
                case DEAD_BUSH: {
                    return new ItemStack((Block)Blocks.field_150329_H, 1, 0);
                }
                case EMPTY: {
                    return new ItemStack(Items.field_151162_bE, 1, 0);
                }
                case FERN: {
                    return new ItemStack((Block)Blocks.field_150329_H, 1, 2);
                }
                case HOUSTONIA: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 3);
                }
                case JUNGLE_SAPLING: {
                    return new ItemStack(Blocks.field_150345_g, 1, 3);
                }
                case MUSHROOM_BROWN: {
                    return new ItemStack((Block)Blocks.field_150338_P, 1, 0);
                }
                case MUSHROOM_RED: {
                    return new ItemStack((Block)Blocks.field_150337_Q, 1, 0);
                }
                case OAK_SAPLING: {
                    return new ItemStack(Blocks.field_150345_g, 1, 0);
                }
                case ORANGE_TULIP: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 5);
                }
                case OXEYE_DAISY: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 8);
                }
                case PINK_TULIP: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 7);
                }
                case POPPY: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 0);
                }
                case RED_TULIP: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 4);
                }
                case SPRUCE_SAPLING: {
                    return new ItemStack(Blocks.field_150345_g, 1, 1);
                }
                case WHITE_TULIP: {
                    return new ItemStack((Block)Blocks.field_150328_O, 1, 6);
                }
            }
        }
        if (block instanceof BlockRedstoneOre) {
            return new ItemStack(Blocks.field_150450_ax);
        }
        if (block == crops) {
            return new ItemStack(Items.field_151015_O);
        }
        if (block == farmland) {
            return new ItemStack(Blocks.field_150458_ak);
        }
        if (block == leave || block == leave2 || block == log || block == log2) {
            return new ItemStack(block, 1, accessor.getMetadata() % 4);
        }
        if (block == quartz && accessor.getMetadata() > 2) {
            return new ItemStack(block, 1, 2);
        }
        if (block == sapling) {
            return new ItemStack(block, 1, accessor.getMetadata() % 8);
        }
        if (block == pistonhead) {
            if (accessor.getMetadata() < 8) {
                return new ItemStack((Block)Blocks.field_150331_J, 1, 0);
            }
            return new ItemStack((Block)Blocks.field_150320_F, 1, 0);
        }
        if (block == stoneslab) {
            return new ItemStack(block, 1, accessor.getMetadata() % 8);
        }
        if (block == doublestoneslab) {
            return new ItemStack((Block)Blocks.field_150333_U, 1, accessor.getMetadata() % 8);
        }
        if (block == woodenslab) {
            return new ItemStack(block, 1, accessor.getMetadata() % 8);
        }
        if (block == doublewoodenslab) {
            return new ItemStack((Block)Blocks.field_150376_bx, 1, accessor.getMetadata() % 8);
        }
        if (block == anvil) {
            return new ItemStack(block, 1, accessor.getMetadata() / 4);
        }
        if (block == stoneslab2) {
            return new ItemStack(block, 1, accessor.getMetadata() % 8);
        }
        if (block == doublestoneslab2) {
            return new ItemStack((Block)Blocks.field_180389_cP, 1, accessor.getMetadata() % 8);
        }
        if (removemetadata.contains(block)) {
            return new ItemStack(block, 1, 0);
        }
        if (block instanceof BlockStairs) {
            return new ItemStack(block, 1, 0);
        }
        if (block instanceof BlockTorch) {
            return new ItemStack(block, 1, 0);
        }
        if (block instanceof BlockLadder) {
            return new ItemStack(block, 1, 0);
        }
        if (block instanceof BlockFenceGate) {
            return new ItemStack(block, 1, 0);
        }
        if (block instanceof BlockButton) {
            return new ItemStack(block, 1, 0);
        }
        if (block instanceof BlockBasePressurePlate) {
            return new ItemStack(block, 1, 0);
        }
        if (block instanceof BlockRailBase) {
            return new ItemStack(block, 1, 0);
        }
        if (block instanceof BlockTrapDoor) {
            return new ItemStack(block, 1, 0);
        }
        return null;
    }

    @Override
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        String name;
        Block block = accessor.getBlock();
        if (block == mobSpawner && accessor.getTileEntity() instanceof TileEntityMobSpawner && config.getConfig("vanilla.spawntype")) {
            name = currenttip.get(0);
            String mobname = ((TileEntityMobSpawner)accessor.getTileEntity()).func_145881_a().func_184994_d().func_70005_c_();
            currenttip.set(0, String.format("%s (%s)", name, mobname));
        }
        if (block == redstone) {
            name = currenttip.get(0).replaceFirst(String.format(" %s", accessor.getMetadata()), "");
            currenttip.set(0, name);
        }
        if (block == melonStem) {
            currenttip.set(0, SpecialChars.WHITE + "Melon stem");
        }
        if (block == pumpkinStem) {
            currenttip.set(0, SpecialChars.WHITE + "Pumpkin stem");
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        boolean iscrop = crops.getClass().isInstance(block);
        if (config.getConfig("general.showcrop") && (iscrop || block == melonStem || block == pumpkinStem || block == carrot || block == potato)) {
            float growthValue = (float)accessor.getMetadata() / 7.0f * 100.0f;
            if ((double)growthValue < 100.0) {
                currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG("hud.msg.growth", new Object[0]), Float.valueOf(growthValue)));
            } else {
                currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.growth", new Object[0]), LangUtil.translateG("hud.msg.mature", new Object[0])));
            }
            return currenttip;
        }
        if (block == cocoa && config.getConfig("general.showcrop")) {
            float growthValue = (float)(accessor.getMetadata() >> 2) / 2.0f * 100.0f;
            if ((double)growthValue < 100.0) {
                currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG("hud.msg.growth", new Object[0]), Float.valueOf(growthValue)));
            } else {
                currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.growth", new Object[0]), LangUtil.translateG("hud.msg.mature", new Object[0])));
            }
            return currenttip;
        }
        if (block == netherwart && config.getConfig("general.showcrop")) {
            float growthValue = (float)accessor.getMetadata() / 3.0f * 100.0f;
            if ((double)growthValue < 100.0) {
                currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG("hud.msg.growth", new Object[0]), Float.valueOf(growthValue)));
            } else {
                currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.growth", new Object[0]), LangUtil.translateG("hud.msg.mature", new Object[0])));
            }
            return currenttip;
        }
        if (config.getConfig("vanilla.leverstate") && block == lever) {
            String redstoneOn = (accessor.getMetadata() & 8) == 0 ? LangUtil.translateG("hud.msg.off", new Object[0]) : LangUtil.translateG("hud.msg.on", new Object[0]);
            currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.state", new Object[0]), redstoneOn));
            return currenttip;
        }
        if (config.getConfig("vanilla.repeater") && (block == repeaterIdle || block == repeaterActv)) {
            int tick = (accessor.getMetadata() >> 2) + 1;
            if (tick == 1) {
                currenttip.add(String.format("%s : %s tick", LangUtil.translateG("hud.msg.delay", new Object[0]), tick));
            } else {
                currenttip.add(String.format("%s : %s ticks", LangUtil.translateG("hud.msg.delay", new Object[0]), tick));
            }
            return currenttip;
        }
        if (config.getConfig("vanilla.comparator") && (block == comparatorIdl || block == comparatorAct)) {
            String mode = (accessor.getMetadata() >> 2 & 1) == 0 ? LangUtil.translateG("hud.msg.comparator", new Object[0]) : LangUtil.translateG("hud.msg.substractor", new Object[0]);
            currenttip.add("Mode : " + mode);
            return currenttip;
        }
        if (config.getConfig("vanilla.redstone") && block == redstone) {
            currenttip.add(String.format("%s : %s", LangUtil.translateG("hud.msg.power", new Object[0]), accessor.getMetadata()));
            return currenttip;
        }
        if (config.getConfig("vanilla.jukebox") && block == jukebox) {
            NBTTagCompound tag = accessor.getNBTData();
            if (tag.func_150297_b("RecordItem", 10)) {
                Item record = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("RecordItem")).func_77973_b();
                currenttip.add(LangUtil.translateG("record.nowPlaying", new Object[0]).replace("%s", ((ItemRecord)record).func_150927_i()));
            } else {
                currenttip.add(LangUtil.translateG("hud.msg.empty", new Object[0]));
            }
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te != null) {
            te.func_189515_b(tag);
        }
        return tag;
    }

    public static void register() {
        ModuleRegistrar.instance().addConfig("VanillaMC", "vanilla.spawntype");
        ModuleRegistrar.instance().addConfig("VanillaMC", "vanilla.leverstate");
        ModuleRegistrar.instance().addConfig("VanillaMC", "vanilla.repeater");
        ModuleRegistrar.instance().addConfig("VanillaMC", "vanilla.comparator");
        ModuleRegistrar.instance().addConfig("VanillaMC", "vanilla.redstone");
        ModuleRegistrar.instance().addConfig("VanillaMC", "vanilla.silverfish");
        ModuleRegistrar.instance().addConfigRemote("VanillaMC", "vanilla.jukebox");
        HUDHandlerVanilla provider = new HUDHandlerVanilla();
        ModuleRegistrar.instance().registerStackProvider(provider, silverfish.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, redstone.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, doubleplant.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, BlockRedstoneOre.class);
        ModuleRegistrar.instance().registerStackProvider(provider, crops.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, farmland.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, leave.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, leave2.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, log.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, log2.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, quartz.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, sapling.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, stickypiston.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, piston.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, pistonhead.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, stoneslab.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, doublestoneslab.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, lever.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, woodenslab.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, doublewoodenslab.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, anvil.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, stoneslab2.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, doublestoneslab2.getClass());
        ModuleRegistrar.instance().registerStackProvider(provider, flowerpot.getClass());
        for (Block b : removemetadata) {
            ModuleRegistrar.instance().registerStackProvider(provider, b.getClass());
        }
        ModuleRegistrar.instance().registerStackProvider(provider, BlockStairs.class);
        ModuleRegistrar.instance().registerStackProvider(provider, BlockTorch.class);
        ModuleRegistrar.instance().registerStackProvider(provider, BlockLadder.class);
        ModuleRegistrar.instance().registerStackProvider(provider, BlockFenceGate.class);
        ModuleRegistrar.instance().registerStackProvider(provider, BlockButton.class);
        ModuleRegistrar.instance().registerStackProvider(provider, BlockBasePressurePlate.class);
        ModuleRegistrar.instance().registerStackProvider(provider, BlockRailBase.class);
        ModuleRegistrar.instance().registerStackProvider(provider, BlockTrapDoor.class);
        ModuleRegistrar.instance().registerHeadProvider(provider, mobSpawner.getClass());
        ModuleRegistrar.instance().registerHeadProvider(provider, melonStem.getClass());
        ModuleRegistrar.instance().registerHeadProvider(provider, pumpkinStem.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, crops.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, melonStem.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, pumpkinStem.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, lever.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, repeaterIdle.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, repeaterActv.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, comparatorIdl.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, comparatorAct.getClass());
        ModuleRegistrar.instance().registerHeadProvider(provider, redstone.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, redstone.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, jukebox.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, cocoa.getClass());
        ModuleRegistrar.instance().registerBodyProvider(provider, netherwart.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, mobSpawner.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, crops.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, melonStem.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, pumpkinStem.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, carrot.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, potato.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, lever.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, repeaterIdle.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, repeaterActv.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, comparatorIdl.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, comparatorAct.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, redstone.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, jukebox.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, cocoa.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, netherwart.getClass());
        ModuleRegistrar.instance().registerNBTProvider(provider, silverfish.getClass());
    }
}

