/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.ic2;

import java.util.List;
import mcp.mobius.waila.addons.ic2.IC2Module;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.cbcore.LangUtil;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class HUDHandlerTEGenerator
implements IWailaDataProvider {
    @Override
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        try {
            double storage = accessor.getNBTData().func_74769_h("storage");
            int production = accessor.getNBTData().func_74762_e("production");
            long maxStorage = accessor.getNBTData().func_74763_f("maxStorage");
            String storedStr = LangUtil.translateG("hud.msg.stored", new Object[0]);
            String outputStr = LangUtil.translateG("hud.msg.output", new Object[0]);
            if (ConfigHandler.instance().getConfig("ic2.storage") && maxStorage > 0L) {
                currenttip.add(String.format("%s%s\u00a7f%d\u00a7r / \u00a7f%d\u00a7r EU", storedStr, SpecialChars.TAB + SpecialChars.ALIGNRIGHT, Math.round(Math.min(storage, (double)maxStorage)), maxStorage));
            }
            if (ConfigHandler.instance().getConfig("ic2.outputeu")) {
                currenttip.add(String.format("%s%s\u00a7f%d\u00a7r EU/t", outputStr, SpecialChars.TAB + SpecialChars.ALIGNRIGHT, production));
            }
        }
        catch (Exception e) {
            currenttip = WailaExceptionHandler.handleErr(e, accessor.getTileEntity().getClass().getName(), currenttip);
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        try {
            double storage = -1.0;
            long production = -1L;
            long maxStorage = -1L;
            if (IC2Module.TileBaseGenerator.isInstance(te)) {
                storage = IC2Module.TileBaseGenerator_storage.getDouble(te);
                production = IC2Module.TileBaseGenerator_production.getInt(te);
                maxStorage = IC2Module.TileBaseGenerator_maxStorage.getShort(te);
            } else if (IC2Module.TileGeoGenerator.isInstance(te)) {
                storage = IC2Module.TileGeoGenerator_storage.getDouble(te);
                production = IC2Module.TileGeoGenerator_production.getInt(te);
                maxStorage = IC2Module.TileGeoGenerator_maxStorage.getShort(te);
            } else if (IC2Module.TileKineticGenerator.isInstance(te)) {
                storage = IC2Module.TileKineticGenerator_storage.getDouble(te);
                production = MathHelper.func_76124_d((double)IC2Module.TileKineticGenerator_production.getDouble(te));
                maxStorage = IC2Module.TileKineticGenerator_maxStorage.getInt(te);
            } else if (IC2Module.TileSemifluidGenerator.isInstance(te)) {
                storage = IC2Module.TileSemifluidGenerator_storage.getDouble(te);
                production = MathHelper.func_76124_d((double)IC2Module.TileSemifluidGenerator_production.getDouble(te));
                maxStorage = IC2Module.TileSemifluidGenerator_maxStorage.getShort(te);
            } else if (IC2Module.TileStirlingGenerator.isInstance(te)) {
                storage = IC2Module.TileStirlingGenerator_storage.getDouble(te);
                production = MathHelper.func_76124_d((double)IC2Module.TileStirlingGenerator_production.getDouble(te));
                maxStorage = IC2Module.TileStirlingGenerator_maxStorage.getShort(te);
            }
            tag.func_74780_a("storage", storage);
            tag.func_74772_a("production", production);
            tag.func_74772_a("maxStorage", maxStorage);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tag;
    }
}

